PRO mark_position,xpos,ypos,win
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

	nterm=n_elements(xpos)
	wset,win

	FOR i=0,nterm-1 do begin
		draw_ellipse,(xpos[i]-xoffset)/samplefac,(ypos[i]-yoffset)/samplefac,100/samplefac,100/samplefac,/device
		xyouts,(xpos[i]-xoffset)/samplefac,(ypos[i]-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5
	ENDFOR
END

PRO set_intensity_level,holebuttom,holetop,starbuttom,startop

	if N_elements(holebuttom) EQ 0 then countlevel=[10,400,600,2000] ELSE countlevel=[holebuttom,holetop,starbuttom,startop]
	count_input_retry:
	countlevel=dialog_input(prompt=["Bottom Count of Alignment Hole",'Top Count of Alignment Hole','Bottom Count of Alignment Star','Top Count of Alignment Star (Display purpose only)'],nfield=4,initial=countlevel,title="Input Count Level")
; Check 1
	if (n_elements(countlevel) NE 4 ) then begin
		flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong.')
		CASE flag OF
			'Retry': begin
				goto,count_input_retry
				end
			'Quit': return;message,'Finish!'
		ENDCASE
	endif
; Check 2
	if (float(countlevel[0]) GT float(countlevel[1])) OR (float(countlevel[1]) GT float(countlevel[2])) OR (float(countlevel[2]) GT float(countlevel[3])) then begin
		flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
		CASE flag OF
			'Retry': begin
					goto,count_input_retry
				end
			'Quit': return;message,'Finish!'
		ENDCASE
	endif

	holebuttom=float(countlevel[0]) & holetop=float(countlevel[1]) & starbuttom=float(countlevel[2]) & startop=float(countlevel[3])
END

PRO get_pos,image,X,Y,buttom_level,top_level,i,win,win2,win3,width
	get_star_pos,image < top_level > buttom_level,X,Y,i,win,win2,win3,width,RANGE=[buttom_level,top_level]
END

PRO get_star_pos,image,xpos,ypos,i,win,win2,win3,width,RANGE=range
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

;	width=40
	wset,win

	CURSOR,xpos,ypos,/device
	xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset

	image3=image[xpos-width:xpos+width,ypos-width:ypos+width]

	result=gauss2dfit(image3,a)

	if a[4] GT 2*width or a[4] LT 0 then begin
		print,'Wrong Fit'
		flag=dialog_message('Fit Result Out-of-bound! (X)')
		a[4]=width
	END

	if a[5] GT 2*width OR a[5] LT 0 then begin
		print,'Wrong Fit'
		flag=dialog_message('Fit Result Out-of-bound! (Y)')
		a[5]=width
	END

	xpos=a[4]-width+xpos
	ypos=a[5]-width+ypos

;	WSET,2 & ERASE
	wset,win2
	show3,image3
	wset,win3
	show3,result

	wset,win
	draw_ellipse,(xpos-xoffset)/samplefac,(ypos-yoffset)/samplefac,100/samplefac,100/samplefac,/device
	xyouts,(xpos-xoffset)/samplefac,(ypos-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5

;	aper,image,a[4]-width+xpos,a[5]-width+ypos,flux,errap,sky,skyerr,1,[8],[10,15],[-500,30000],/flux
END

PRO file_read,files,image
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

	image1=MRDFITS(files[0],0,headers1,/silent,/fscale)
	suboverscan,image1,image1_os,1,overscan
	image1=0
	image2=MRDFITS(files[1],0,headers2,/silent,/fscale)
	suboverscan,image2,image2_os,2,overscan
	image2=0
	combine_chip12,image1_os,image2_os,image,headers1
	image1_os=0 & image2_os=0
	;image_med=filter_image(starimage,/median)
END



PRO calc_mosshift,star_x,star_y,hole_x,hole_y,PA,winres
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

mag=0.015/beta
;s=size(holeimage)
;maxx=s(1) & maxy=s(2)

nterm=n_elements(star_x)

x_shift=fltarr(nterm) & y_shift=fltarr(nterm)
ang_star=fltarr(nterm) & ang_hole=fltarr(nterm) & difangle=fltarr(nterm)

; CCD coord -> Sky coord
disttransform_inv,star_x,XDistCenter,star_y,YDistCenter,star_x_trans,star_y_trans,mag,maxx,maxy,coef
disttransform_inv,hole_x,XDistCenter,hole_y,YDistCenter,hole_x_trans,hole_y_trans,mag,maxx,maxy,coef

x_shift=star_x-hole_x
y_shift=star_y-hole_y

;mean_x_shift=mean(x_shift)
;mean_y_shift=mean(y_shift)

; Shift value (SKY coord)
x_shift_trans=star_x_trans-hole_x_trans
y_shift_trans=star_y_trans-hole_y_trans

hole_x_mean=mean(hole_x_trans)
hole_y_mean=mean(hole_y_trans)

; Mean shift value (SKY coord)
mean_x_shift_trans=mean(x_shift_trans)
mean_y_shift_trans=mean(y_shift_trans)

; Move star positions to mean hole positions (SKY coord)
star_x_shift_trans=star_x_trans-mean(x_shift_trans) 
star_y_shift_trans=star_y_trans-mean(y_shift_trans)

; Rotation calc
ang_star=atan(star_y_shift_trans-YMaskRotCenter,star_x_shift_trans-XMaskRotCenter)
ang_hole=atan(hole_y_trans      -YMaskRotCenter,hole_x_trans      -XMaskRotCenter)
difangle=ang_star-ang_hole
r_star=sqrt((star_y_shift_trans-YMaskRotCenter)^2+(star_x_shift_trans-XMaskRotCenter)^2)
mean_difangle=meanw(difangle,r_star)

ang_star2=atan(star_y_shift_trans-hole_y_mean,star_x_shift_trans-hole_x_mean)
ang_hole2=atan(hole_y_trans      -hole_y_mean,hole_x_trans      -hole_x_mean)
difangle2=ang_star2-ang_hole2
r_star2=sqrt((star_y_shift_trans-hole_y_mean)^2+(star_x_shift_trans-hole_x_mean)^2)
mean_difangle2=meanw(difangle2,r_star2)

print,'new theta',mean_difangle2*180/1.341592

dif=sqrt(x_shift_trans^2+y_shift_trans^2)

;star_x_new=star_x_trans & star_y_new=star_y_trans

; Sky coord -> CCD coord
disttransform,star_x_shift_trans,XDistCenter,star_y_shift_trans,YDistCenter,star_x_shift,star_y_shift,mag,maxx,maxy,0,0,coef_inv

; New position after rotation (SKY coord, NEW coord)
star_x_new_trans= (star_x_shift_trans-XMASKRotCenter)*cos(mean_difangle)+(star_y_shift_trans-YMASKRotCenter)*sin(mean_difangle)+XMASKRotCenter
star_y_new_trans=-(star_x_shift_trans-XMASKRotCenter)*sin(mean_difangle)+(star_y_shift_trans-YMASKRotCenter)*cos(mean_difangle)+YMASKRotCenter

; Sky coord -> CCD coord (NEW coord)
disttransform,star_x_new_trans,XDistCenter,star_y_new_trans,YDistCenter,star_x_new,star_y_new,mag,maxx,maxy,0,0,coef_inv

; CCD coord -> Sky coord (NEW coord)
disttransform_inv,star_x_new,XDistCenter,star_y_new,YDistCenter,star_x_new_trans,star_y_new_trans,mag,maxx,maxy, coef
disttransform_inv,hole_x,    XDistCenter,hole_y,    YDistCenter,hole_x_new_trans,hole_y_new_trans,mag,maxx,maxy, coef

; Mean shift (SKY coord, NEW coord)
x_shift_new=star_x_new_trans-hole_x_new_trans
y_shift_new=star_y_new_trans-hole_y_new_trans

; Rotation angle (New coord)
ang_star_new=atan(star_y_new_trans-YMASKRotCenter,star_x_new_trans-XMASKRotCenter)
difangle_new=ang_star_new-ang_hole
dif_new=sqrt(x_shift_new^2+y_shift_new^2)

; Final shift
true_X_shift=mean_x_shift_trans+mean(x_shift_new)
true_Y_shift=mean_y_shift_trans+mean(y_shift_new)
true_difangle=mean_difangle+meanw(difangle_new,r_star)

; Residual plot (SKY coord)
wset,winres
!P.MULTI=[0,1,2]
partvelvec,[x_shift,1],[y_shift,1],[star_x,500],[star_y,500],[0,4000],[0,4000],title='Before'
draw_ellipse,90,427,10,10,/device
xyouts,80,400,'1pix by 1pix ref. vec.',/device,charsize=1.0
;xyouts,70,960,'Residual offset: '+strtrim(string(mean(dif)),2)+' [pix]',/device,charsize=1.5

; Residual plot (SKY coord, NEW coord)
partvelvec,[x_shift_new,1],[y_shift_new,1],[star_x,500],[star_y,500],[0,4000],[0,4000],title='After'
draw_ellipse,90,77,10,10,/device
xyouts,80,55,'1pix by 1pix ref. vec.',/device,charsize=1.0
;xyouts,70,460,'Residual offset: '+strtrim(string(mean(dif_new)),2)+' [pix]',/device,charsize=1.5
!P.MULTI=0

; Results output
print,mean(x_shift_new),mean(y_shift_new),meanw(difangle_new,r_star)
print,'Shift: X=',true_x_shift,' +-',sigma(x_shift_new),' [pix]; Y=',true_y_shift,' +-',sigma(y_shift_new),' [pix]; angle=',true_difangle*180/3.141592,' +-',mean(difangle_new*180/3.141592),' [deg]'
print,'Residual offset:',mean(dif_new),' +-',sigma(dif_new),' [pix]'

;result=dialog_message('Move MOS angle '+string(-true_difangle*180/3.141592)+ ' deg. relatively.',/information)
;;result=dialog_message('Move TEL PA (= -offset) '+string(-true_difangle*180/3.141592)+ ' deg. relatively.',/information)
;result=dialog_message('Move Telescope '+string(-true_x_shift*0.1)+' arcsec N &'+string(true_y_shift*0.1)+' arcsec E, relatively.',/information)
;result=dialog_message('Move MOS angle '+string(-true_difangle*180/3.141592)+' deg., Move Telescope '+string(-true_x_shift*0.1)+' arcsec N &'+string(true_y_shift*0.1)+' arcsec E, relatively.',/information)

;if PA EQ 0  then result=dialog_message(['delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.','delta Alpha= '+strtrim(string( true_y_shift*0.1),2)+', delta Dec= '+strtrim(string(-true_x_shift*0.1),2),'Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],/information)
;if PA EQ 90 then result=dialog_message(['delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.','delta Alpha= '+strtrim(string(-true_x_shift*0.1),2)+', delta Dec= '+strtrim(string(-true_y_shift*0.1),2),'Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],/information)

pix_scale=0.1038
delta_ra =( (true_y_shift)*cos(pa*3.141592/180)-(true_x_shift)*sin(pa*3.141592/180))*pix_scale
delta_dec=(-(true_y_shift)*sin(pa*3.141592/180)-(true_x_shift)*cos(pa*3.141592/180))*pix_scale

result=dialog_message(['delta Alpha= '+strtrim(string(delta_ra),2)+', delta Dec= '+strtrim(string(delta_dec),2),'delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.','Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],/information)

END
;---


pro mos_pointing2
;
; Hole operation first, then Star operation
;
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

fitsdir=strarr(4)

fitsdir[*]=getenv("FOCASRED_FITS_IN")+'/'
if fitsdir[0] EQ '/' then fitsdir[*]=getenv('PWD')
fitsoutdir=getenv("FOCASRED_FITS_OUT")+'/'
if fitsoutdir EQ '/' then fitsoutdir=getenv('PWD')


pa_input_retry:
result=dialog_input(prompt=["# of alignment stars","PA (deg)"],title="",nfield=2)
nterm=result[0]
PA=float(result[1])

if n_elements(nterm) NE 1 then goot,pa_input_retry

if nterm LT 0 then begin
	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
				goto,pa_input_retry
			end
		'Quit': message,'Finish!'
	ENDCASE
endif

;if NOT ((PA EQ 0) OR (PA EQ 90)) then begin
;	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
;	CASE flag OF
;		'Retry': begin
;				goto,pa_input_retry
;			end
;		'Quit': message,'Finish!'
;	ENDCASE
;endif

hole_x=fltarr(nterm) & hole_y=fltarr(nterm) & star_x=fltarr(nterm) & star_y=fltarr(nterm)

set_intensity_level,holebuttom,holetop,starbuttom,startop

retry:
files=dialog_input(prompt=["Mask 1","Mask 2","Star 1", "Star 2"],nfield=4,title='FCSA000XXXXX (last five number)')

files=fitsdir+'FCSA000'+files+'.fits'
print,files

d = FINDFILE (files[0], COUNT = fileExists)
IF (fileExists EQ 0) THEN begin
	print,'File error'

	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
			goto,retry
			end
		'Quit': message,'Finish!'
	ENDCASE
ENDIF

d = FINDFILE (files[1], COUNT = fileExists)
IF (fileExists EQ 0) THEN begin
	print,'File error'
	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
			goto,retry
			end
		'Quit': message,'Finish!'
	ENDCASE
ENDIF

file_read,files[0:1],holeimage
s=size(holeimage) & maxx=s(1) & maxy=s(2)

xoffset=50 & xend=maxx-50 & yoffset=50 & yend=maxy-50 & samplefac=get_samplefac(maxy)*2.0

width=40

base = WIDGET_BASE (mbar=bar,TITLE = 'MOS Pointing', /row, MAP = 0)
menu1=widget_button(bar, value='Quit',/menu)
button1=widget_button(menu1,value='Quit')

base2 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)
base0 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)
base1 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)
base3 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)

label=widget_label(base0,value='Alignment Stars')
w1 = WIDGET_DRAW (base0, XSIZE = FIX((xend-xoffset)/samplefac), YSIZE = FIX((xend-xoffset)/samplefac), /FRAME)
label=widget_label(base1,value='Alignment Holes')
w2 = WIDGET_DRAW (base1, XSIZE = FIX((xend-xoffset)/samplefac), YSIZE = FIX((xend-xoffset)/samplefac), /FRAME)
label=widget_label(base2,value='FIT')
w3 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200)
label=widget_label(base2,value='OBS')
w4 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200)
button1 = widget_button(base2, VALUE = 'Change Intensity Range',/frame)
button1 = widget_button(base2, VALUE = 'Change Fitting Region Size',/frame)

label=widget_label(base3,value='Pointing Results')
w5 = WIDGET_DRAW (base3, XSIZE = 300, YSIZE = 700, /FRAME)
button1 = widget_button(base3, VALUE = 'CALC',/frame)

button1 = widget_button(base0, VALUE = 'Redraw Star',/frame)
button1 = widget_button(base1, VALUE = 'Redraw Hole',/frame)

button1 = widget_button(base0, VALUE = 'Mark Star',/frame)
button1 = widget_button(base1, VALUE = 'Mark Hole',/frame)

button1 = widget_button(base0, VALUE = 'Set Star Position',/frame)
button1 = widget_button(base1, VALUE = 'Set Hole Position',/frame)


WIDGET_CONTROL, base, /REALIZE,/UPDATE
WIDGET_CONTROL, w1, GET_VALUE = winid_star
WIDGET_CONTROL, w2, GET_VALUE = winid_hole
WIDGET_CONTROL, w3, GET_VALUE = winobs
WIDGET_CONTROL, w4, GET_VALUE = winfit
WIDGET_CONTROL, w5, GET_VALUE = winres

WIDGET_CONTROL, base, MAP = 1
WIDGET_CONTROL, base0, MAP = 1
WIDGET_CONTROL, base1, MAP = 1
WIDGET_CONTROL, base2, MAP = 1
WIDGET_CONTROL, base3, MAP = 1
;
; Mask Operation
;


expand,holeimage,FIX(maxx/samplefac),FIX(maxy/samplefac),holeimage2
;WINDOW,0,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
wset,winid_hole
TV,BYTSCL(holeimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=holebuttom,max=holetop)
;WINDOW,2,xsize=FIX((maxx-xoffset)/samplefac),ysize=FIX((maxy-yoffset)/samplefac),TITLE=name

for i=0,nterm-1 do begin
	get_pos,holeimage,X,Y,holebuttom,holetop,i,winid_hole,winfit,winobs,width
	hole_x[i]=X & hole_y[i]=Y
ENDFOR
;
; Star operation
;

IF files[0] NE files[2] then begin
nofile:
	flag = DIALOG_MENU (["Let's go to object image NOW"], TITLE = 'Click here when object image is ready.')

	d = FINDFILE (files[3], COUNT = fileExists)
	IF (fileExists EQ 0) THEN BEGIN
		print,"The Files are not ready."
		goto,nofile
	END

	file_read,files[2:3],starimage
	expand,starimage,FIX(maxx/samplefac),FIX(maxy/samplefac),starimage2
ENDIF ELSE BEGIN
	starimage=holeimage
	starimage2=holeimage2
ENDELSE

wset,winid_star
TV,BYTSCL(starimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=starbuttom,max=startop)

for i=0,nterm-1 do begin
	get_pos,starimage,X,Y,starbuttom,50000,i,winid_star,winfit,winobs,width; 50000 was startop
	star_x[i]=X & star_y[i]=Y
ENDFOR

calc_mosshift,star_x,star_y,hole_x,hole_y,PA,winres

NEXT:

event = WIDGET_EVENT (base)
WIDGET_CONTROL, event.id, GET_VALUE = value;,/hourglass

IF (value EQ 'Redraw Star') THEN begin
	wset,winid_star
	TV,BYTSCL(starimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=starbuttom,max=startop)
	GOTO,NEXT
END

IF (value EQ 'Redraw Hole') THEN begin
	wset,winid_hole
	TV,BYTSCL(holeimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=holebuttom,max=holetop)
	GOTO,NEXT
END

IF (value EQ 'Set Star Position') THEN begin
	wset,winid_star
;	TV,BYTSCL(starimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=starbuttom,max=startop)

	i=dialog_input(prompt=["Star ID"],title="",nfield=1)
;	FOR i=0,nterm-1 do begin
	get_pos,starimage,X,Y,starbuttom,50000,i,winid_star,winfit,winobs,width; 50000 was startop
	star_x[i]=X & star_y[i]=Y
;	ENDFOR
	GOTO,NEXT
END

IF (value EQ 'Set Hole Position') THEN begin

	wset,winid_hole
;	TV,BYTSCL(holeimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=holebuttom,max=holetop)
	i=dialog_input(prompt=["Hole ID"],title="",nfield=1)
;	for i=0,nterm-1 do begin
		get_pos,holeimage,X,Y,holebuttom,holetop,i,winid_hole,winfit,winobs,width
		hole_x[i]=X & hole_y[i]=Y
;	ENDFOR
	GOTO,NEXT
END

IF (value EQ 'Change Intensity Range') THEN begin
	set_intensity_level,holebuttom,holetop,starbuttom,startop		
	wset,winid_star
	TV,BYTSCL(starimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=starbuttom,max=startop)
	wset,winid_hole
	TV,BYTSCL(holeimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=holebuttom,max=holetop)
	GOTO,NEXT
END

IF (value EQ 'CALC') THEN begin
	calc_mosshift,star_x,star_y,hole_x,hole_y,PA,winres
	GOTO,NEXT
END

IF (value EQ 'Mark Star') THEN begin
	mark_position,star_x,star_y,winid_star
	GOTO,NEXT
END

IF (value EQ 'Mark Hole') THEN begin
	mark_position,hole_x,hole_y,winid_hole
	GOTO,NEXT
END

IF (value EQ 'Change Fitting Region Size') THEN begin
	result=dialog_input(prompt="Width (pixel)",title="",initial=width)
	width=FIX(result)
	GOTO,NEXT
END

IF (value EQ 'Quit') THEN begin
	message,'Finish'	
	GOTO,NEXT
END

message,'Finish'
;
;
;
; Residual plots
;

window
r_hole=sqrt((hole_y-YMASKRotCenter)^2+(hole_x-XMASKRotCenter)^2)
plot,r_star,(r_hole-r_star)/r_star*100,xrange=[0,2000]

;
; Rotation angle
;
plot,star_y,x_shift_new,psym=2
result=poly_fit(star_y,x_shift_new,1)
;print,-result[1]*180/3.141592

plot,star_x,y_shift_new,psym=2
result=poly_fit(star_x_shift,y_shift_new,1)
;print,result[1]*180/3.141592

;
; Distortion (radial) error
;
plot,r_star,(r_star-r_hole)/r_hole*100,psym=1,yrange=[-1,1]
plot,star_x,(r_star-r_hole),psym=1,yrange=[-10,10]
plot,r_star,r_star/r_hole,psym=1,yrange=[0.98,1.02]
plot,r_star,dif_new,psym=2
;
; Chip 1, 2 gap offset error
;
plot,star_x_shift,x_shift_new,psym=2
;
; Chip 1, 2 Y offset
;
plot,star_x_shift,y_shift_new,psym=2
;
; Rot center error
;
plot,ang_star*180/3.14,difangle_new*180/3.14,psym=2

;print,sqrt((x_shift_new-mean(x_shift_new))^2+(y_shift_new-mean(y_shift_new))^2)

message,'FINISH'


;
; write shift and rot star image
;
shiftstarimage=shift(starimage_med,-true_x_shift,-true_y_shift)
shiftrotstarimage=rot(shiftstarimage,true_difangle*180/3.141592,1,XMaskRotCenter,YMaskRotCenter,/pivot,/interp)
;write_fits,shiftrotstarimage,header
write_fits,shiftrotstarimage-holeimage_med ,header
;
;  Write rotated hole image
;
rotholeimage=rot(holeimage,true_difangle*180/3.141592,1,XMASKRotCenter,YMASKRotCenter,/pivot,/interp)
write_fits,rotholeimage ,header,dir=fitsoutdir

END
