PRO mark_position,xpos,ypos,win
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

	nterm=n_elements(xpos)
	wset,win

	FOR i=0,nterm-1 do begin
		draw_ellipse,(xpos[i]-xoffset)/samplefac,(ypos[i]-yoffset)/samplefac,100/samplefac,100/samplefac,/device
		xyouts,(xpos[i]+10-xoffset)/samplefac,(ypos[i]+10-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5
	ENDFOR
END

PRO set_intensity_level,holebuttom,holetop,starbuttom,startop

	if N_elements(holebuttom) EQ 0 then countlevel=[10,800,900,1500] ELSE countlevel=[holebuttom,holetop,starbuttom,startop]
	count_input_retry:
	countlevel=dialog_input(prompt=["Bottom Count of Alignment Hole",'Top Count of Alignment Hole','Bottom Count of Alignment Star','Top Count of Alignment Star (Display purpose only)'],nfield=4,initial=countlevel,title="Input Count Level")
; Check 1
	if (n_elements(countlevel) NE 4 ) then begin
		flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong.')
		CASE flag OF
			'Retry': begin
				goto,count_input_retry
				end
			'Quit': return;message,'Finish!'
		ENDCASE
	endif
; Check 2
	if (float(countlevel[0]) GT float(countlevel[1])) OR (float(countlevel[1]) GT float(countlevel[2])) OR (float(countlevel[2]) GT float(countlevel[3])) then begin
		flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
		CASE flag OF
			'Retry': begin
					goto,count_input_retry
				end
			'Quit': return;message,'Finish!'
		ENDCASE
	endif

	holebuttom=float(countlevel[0]) & holetop=float(countlevel[1]) & starbuttom=float(countlevel[2]) & startop=float(countlevel[3])
END

PRO refit_holes,holeimage,hole_x,hole_y,holebuttom,holetop,winid_hole,winfit,winobs,width,nterm,use,mode=mode
	for i=0,nterm-1 do begin
		if use[i] EQ 1 then begin
;			get_pos,holeimage,hole_x[i],hole_y[i],X,Y,holebuttom,holetop,i,winid_hole,winfit,winobs,width,mode="SINGLE"
			get_star_pos,holeimage,holetop,holebuttom,hole_x[i],hole_y[i],X,Y,i,winid_hole,winfit,winobs,width,RANGE=[holebuttom,holetop],MODE='SINGLE'
			hole_x[i]=X & hole_y[i]=Y
		endif
	ENDFOR
END


PRO refit_stars,starimage,star_x,star_y,starbuttom,startop,winid_star,winfit,winobs,width,nterm,use,mode=mode
	for i=0,nterm-1 do begin
		if use[i] EQ 1 then begin
			IF mode EQ "STAR2" then begin
				get_star_pos,starimage,startop,starbuttom,star_x[i],star_y[i],X,Y,i,winid_star,winfit,winobs,width,RANGE=[starbuttom,startop],MODE='STAR2'
			END ELSE begin
				get_star_pos,starimage,startop,starbuttom,star_x[i],star_y[i],X,Y,i,winid_star,winfit,winobs,width,RANGE=[starbuttom,startop],MODE='SINGLE'
			ENDELSE
			;get_pos,starimage,star_x[i],star_y[i],X,Y,starbuttom,startop,i,winid_star,winfit,winobs,width,mode="STAR2"
			star_x[i]=X & star_y[i]=Y
		endif
	ENDFOR
END

PRO get_pos,image,X,Y,XOUT,YOUT,buttom_level,top_level,i,win,win2,win3,width,MODE=MODE
	if mode EQ "STAR" then width2=30 > width else width2 =width > 30
	if mode EQ "STAR" then width2=width else width2 =width
	IF MODE EQ 'MANUAL' then begin
		get_star_pos_manual,image, top_level, buttom_level,X,Y,XOUT,YOUT,i,win,win2,win3,width2,RANGE=[buttom_level,top_level],MODE='SINGLE'
	endif else begin
		IF MODE EQ 'HOLE' then get_star_pos,image, top_level, buttom_level,X,Y,XOUT,YOUT,i,win,win2,win3,width2,RANGE=[buttom_level,top_level],MODE='SINGLE' ELSE get_star_pos2,image,top_level,buttom_level,X,Y,XOUT,YOUT,i,win,win2,win3,width2,RANGE=[buttom_level,top_level],MODE=MODE
	endelse

	; get_star_pos inline
END

;PRO get_pos,image,X,Y,XOUT,YOUT,buttom_level,top_level,i,win,win2,win3,width,MODE=MODE
;	if mode EQ "STAR" then width2=30 > width else width2 =width > 30
;	if mode EQ "STAR" then width2=width else width2 =width
;	IF MODE EQ 'HOLE' then get_star_pos,image, top_level, buttom_level,X,Y,XOUT,YOUT,i,win,win2,win3,width2,RANGE=[buttom_level,top_level],MODE='SINGLE' ELSE get_star_pos2,image,top_level,buttom_level,X,Y,XOUT,YOUT,i,win,win2,win3,width2,RANGE=[buttom_level,top_level],MODE=MODE
;
;	; get_star_pos inline
;END



PRO get_star_pos,image,top_level,buttom_level,xpos,ypos,xposout,yposout,i,win,win2,win3,width,RANGE=range,MODE=MODE
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

on_error,2 

;catch,error_status
;if error_status NE 0 then begin
;	print,'The following error happened, and recovered.'
;	print,!ERR_STRING
;endif

a=fltarr(7)

;;; Fit 1

	wset,win

	s=size(image)
	xmax=s(1)
	ymax=s(2)

click_retry:
	IF xpos LT 0 then begin
		CURSOR,xpos,ypos,/device
		xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset
	ENDIF

	if (xpos-width LT 0) or (xpos+width GT xmax) or (ypos-width LT 0) or (ypos+width GT ymax) then begin
		print,'Your Clicked Position was out of range. Try again'
		goto, click_retry
	end

	image3=image[xpos-width > width:xpos+width < xmax,ypos-width > 0:ypos+width < ymax]
	image3 = image3 < top_level > buttom_level
	image4=filter_image(image3,median=5,/all_pixels)
	image3=image4;-median(image4[*,0:3])

	wset,win3
	imdisp,image3,margin=0

;	if MODE EQ 'HOLE' then begin
;		cenx=fltarr(width*2+1) & weightx=fltarr(width*2+1) 
;		for j=0,width*2 do cenx[j]=total(image3[*,j]*findgen(width*2+1))/total(image3[*,j])
;		for j=0,width*2 do weightx[j]=total(image3[*,j])
;		a[4]=meanw(cenx,weightx)
;
;		ceny=fltarr(width*2+1) & weighty=fltarr(width*2+1) 
;		for j=0,width*2 do ceny[j]=total(image3[j,*]*findgen(width*2+1))/total(image3[j,*])
;		for j=0,width*2 do weighty[j]=total(image3[j,*])
;		a[5]=meanw(ceny,weighty)
;	ENDIF ELSE BEGIN
		result=gauss2dfit2(image3,a,/tilt)
		print,'Amp ',a[1]
;
;;		if MODE EQ 'HOLE' then myestimates=[0,500,8,8,width,width, 0.00000] else myestimates=[0,max(image3),4,4,width,width, 0.00000]
;		result=mpfit2dpeak(image3,a,/circular)
;	ENDELSE
	
	if a[4] GT 2*width or a[4] LT 0 then begin
		print,'Wrong Fit'
		flag=dialog_message('Fit Result Out-of-bound! (X)')
;		a[4]=width
		xposout=xpos
		yposout=ypos
		return; of procedure
	END

	if a[5] GT 2*width OR a[5] LT 0 then begin
		print,'Wrong Fit'
		flag=dialog_message('Fit Result Out-of-bound! (Y)')
;		a[5]=width
		xposout=xpos
		yposout=ypos
		return; of procedure
	END

	xpos2=a[4]-width+xpos
	ypos2=a[5]-width+ypos

;;; Fit 2
if MODE EQ "SINGLE" then begin
	buttom_level2=buttom_level
	goto,no_refit
end


;	width=width/1.5
	image3=image[xpos2-width:xpos2+width,ypos2-width:ypos2+width]
	buttom_level2=(buttom_level+a[1]/2.) < (top_level - 100)
	image3 = image3 < top_level > buttom_level2
	image4=filter_image(image3,median=5,/all_pixels)
	image3=image4;-median(image4[*,0:3])

	wset,win3
	imdisp,image3,margin=0

;	if MODE EQ 'HOLE' then begin
;		cenx=fltarr(width*2+1) & weightx=fltarr(width*2+1) 
;		for j=0,width*2 do cenx[j]=total(image3[*,j]*findgen(width*2+1))/total(image3[*,j])
;;		for j=0,width*2 do weightx[j]=total(image3[*,j])
;		a[4]=mean(cenx)

;		ceny=fltarr(width*2+1) & weighty=fltarr(width*2+1) 
;		for j=0,width*2 do ceny[j]=total(image3[j,*]*findgen(width*2+1))/total(image3[j,*])
;;		for j=0,width*2 do weighty[j]=total(image3[j,*])
;		a[5]=mean(ceny)
;	print,a[4],a[5]
;	ENDIF ELSE BEGIN
		result=gauss2dfit2(image3,a)
		olda=a
		olda[4]=width & olda[5]=width
;		result=mpfit2dpeak(image3,a,estimates=olda,/circular)
;	ENDELSE

	if a[4] GT 2*width or a[4] LT 0 then begin
		print,'Wrong Fit'
		flag=dialog_message('Fit Result Out-of-bound! (X)')
;		a[4]=width
		xposout=xpos
		yposout=ypos
		return; of procedure
	END

	if a[5] GT 2*width OR a[5] LT 0 then begin
		print,'Wrong Fit'
		flag=dialog_message('Fit Result Out-of-bound! (Y)')
;		a[5]=width
		xposout=xpos
		yposout=ypos
		return; of procedure

	END

	xpos2=a[4]-width+xpos2
	ypos2=a[5]-width+ypos2

no_refit:

;
; Draw
;
	image3=image[xpos2-width:xpos2+width,ypos2-width:ypos2+width]
	image3 = image3 < top_level > buttom_level2
	image4=filter_image(image3,median=5,/all_pixels)
	image3=image4;-median(image4[*,0:3])

	wset,win2
	show3,image3
	wset,win3
	imdisp,image3,margin=0
	draw_ellipse,100,100,10,10,/device,color=255*255*255
	
	wset,win
	draw_ellipse,(xpos2-xoffset)/samplefac,(ypos2-yoffset)/samplefac,100/samplefac,100/samplefac,/device
	xyouts,(xpos2+10-xoffset)/samplefac,(ypos2+10-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5

;	aper,image,a[4]-width+xpos,a[5]-width+ypos,flux,errap,sky,skyerr,1,[8],[10,15],[-500,30000],/flux

	xposout=xpos2 & yposout=ypos2

;	print,xposout,yposout

END


PRO get_star_pos2,image,top_level,buttom_level,xpos,ypos,xposout,yposout,i,win,win2,win3,width,RANGE=range,MODE=MODE
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

;on_error,2

;image_cut=image < top_level > buttom_level

;catch,error_status
;if error_status NE 0 then begin
;	print,'The following error happened, and recovered.'
;	print,!ERR_STRING
;endif

a=fltarr(7)

;;; Fit 1

	wset,win

	s=size(image)
	xmax=s(1)
	ymax=s(2)

click_retry:
	IF xpos LT 0 then begin
		CURSOR,xpos,ypos,/device
		xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset
	ENDIF

	if (xpos-width LT 0) or (xpos+width GT xmax) or (ypos-width LT 0) or (ypos+width GT ymax) then begin
		print,'Your Clicked Position was out of range. Try again'
		goto, click_retry
	end

	image3=image[xpos-width > width:xpos+width < xmax,ypos-width > 0:ypos+width < ymax]
	image3 = image3 < top_level > buttom_level
	image4=filter_image(image3,median=5,/all_pixels)
	sky=median(image4[*,0:3])
	image3=image4-sky
	print,sky

	wset,win3
	imdisp,image3,margin=0

;	if MODE EQ 'HOLE' then begin
;		cenx=fltarr(width*2+1) & weightx=fltarr(width*2+1) 
;		for j=0,width*2 do cenx[j]=total(image3[*,j]*findgen(width*2+1))/total(image3[*,j])
;		for j=0,width*2 do weightx[j]=total(image3[*,j])
;		a[4]=meanw(cenx,weightx)
;
;		ceny=fltarr(width*2+1) & weighty=fltarr(width*2+1) 
;		for j=0,width*2 do ceny[j]=total(image3[j,*]*findgen(width*2+1))/total(image3[j,*])
;		for j=0,width*2 do weighty[j]=total(image3[j,*])
;		a[5]=meanw(ceny,weighty)
;	ENDIF ELSE BEGIN
		result=gauss2dfit2(image3,a)
;
;;		if MODE EQ 'HOLE' then myestimates=[0,500,8,8,width,width, 0.00000] else myestimates=[0,max(image3),4,4,width,width, 0.00000]
;		result=mpfit2dpeak(image3,a,/circular)
;	ENDELSE
	
	if a[4] GT 2*width or a[4] LT 0 then begin
		print,'Wrong Fit'
		flag=dialog_message('Fit Result Out-of-bound! (X)')
;		a[4]=width
		xposout=xpos
		yposout=ypos
		return; of procedure
	END

	if a[5] GT 2*width OR a[5] LT 0 then begin
		print,'Wrong Fit'
		flag=dialog_message('Fit Result Out-of-bound! (Y)')
;		a[5]=width
		xposout=xpos
		yposout=ypos
		return; of procedure
	END

	xpos2=a[4]-width+xpos
	ypos2=a[5]-width+ypos

;;; Fit 2

;	width=width/2
	width=20; 14=10*sqrt(2)
	image3=image[xpos2-width:xpos2+width,ypos2-width:ypos2+width]
	image4=filter_image(image3,median=5,/all_pixels)
	image3=image4-median(image4[*,0:3])

	wset,win3
	imdisp,image3,margin=0

;	if MODE EQ 'HOLE' then begin
;		cenx=fltarr(width*2+1) & weightx=fltarr(width*2+1) 
;		for j=0,width*2 do cenx[j]=total(image3[*,j]*findgen(width*2+1))/total(image3[*,j])
;;		for j=0,width*2 do weightx[j]=total(image3[*,j])
;		a[4]=mean(cenx)

;		ceny=fltarr(width*2+1) & weighty=fltarr(width*2+1) 
;		for j=0,width*2 do ceny[j]=total(image3[j,*]*findgen(width*2+1))/total(image3[j,*])
;;		for j=0,width*2 do weighty[j]=total(image3[j,*])
;		a[5]=mean(ceny)
;	print,a[4],a[5]
;	ENDIF ELSE BEGIN
		result=gauss2dfit(image3,a,/tilt); was gauss2dfit2
		olda=a
		olda[4]=width & olda[5]=width
;		result=mpfit2dpeak(image3,a,estimates=olda,/circular)
;	ENDELSE

	if a[4] GT 2*width or a[4] LT 0 then begin
		print,'Wrong Fit'
		flag=dialog_message('Fit Result Out-of-bound! (X)')
;		a[4]=width
		xposout=xpos
		yposout=ypos
		return; of procedure
	END

	if a[5] GT 2*width OR a[5] LT 0 then begin
		print,'Wrong Fit'
		flag=dialog_message('Fit Result Out-of-bound! (Y)')
;		a[5]=width
		xposout=xpos
		yposout=ypos
		return; of procedure

	END

	xpos2=a[4]-width+xpos2
	ypos2=a[5]-width+ypos2

;
; Draw
;
	image3=image[xpos2-width:xpos2+width,ypos2-width:ypos2+width]
	image4=filter_image(image3,median=5,/all_pixels)
	image3=image4-median(image4[*,0:3])

	wset,win2
	show3,image3
	wset,win3
	imdisp,image3,margin=0
	draw_ellipse,100,100,10,10,/device,color=255*255*255
	
	wset,win
	draw_ellipse,(xpos2-xoffset)/samplefac,(ypos2-yoffset)/samplefac,100/samplefac,100/samplefac,/device
	xyouts,(xpos2+10-xoffset)/samplefac,(ypos2+10-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5

;	aper,image,a[4]-width+xpos,a[5]-width+ypos,flux,errap,sky,skyerr,1,[8],[10,15],[-500,30000],/flux

	xposout=xpos2 & yposout=ypos2

;	print,xposout,yposout

END



PRO get_star_pos_manual,image,top_level,buttom_level,xpos,ypos,xposout,yposout,i,win,win2,win3,width,RANGE=range,MODE=MODE
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

;on_error,2 

a=fltarr(7)

;;; Fit 1

	wset,win

	s=size(image)
	xmax=s(1)
	ymax=s(2)

click_retry:
	IF xpos LT 0 then begin
		CURSOR,xpos,ypos,/device
		xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset
	ENDIF

	if (xpos-width LT 0) or (xpos+width GT xmax) or (ypos-width LT 0) or (ypos+width GT ymax) then begin
		print,'Your Clicked Position was out of range. Try again'
		goto, click_retry
	end

	image3=image[xpos-width > width:xpos+width < xmax,ypos-width > 0:ypos+width < ymax]
	image3 = image3 < top_level > buttom_level
	image4=filter_image(image3,median=5,/all_pixels)
	image3=image4;-median(image4[*,0:3])

	wset,win3
	imdisp,image3,margin=0

;	result=gauss2dfit2(image3,a,/tilt)
;	print,'Amp ',a[1]

	CURSOR,xpos2,ypos2,/normal
	xpos2=xpos2*(2*WIDTH+1)-width+xpos & ypos2=ypos2*(2*WIDTH+1)-width+ypos
	

;
; Draw
;
	image3=image[xpos2-width:xpos2+width,ypos2-width:ypos2+width]
	image3 = image3 < top_level > buttom_level
	image4=filter_image(image3,median=5,/all_pixels)
	image3=image4;-median(image4[*,0:3])

	wset,win2
	show3,image3
	wset,win3
	imdisp,image3,margin=0
	draw_ellipse,100,100,10,10,/device,color=255*255*255
	
	wset,win
	draw_ellipse,(xpos2-xoffset)/samplefac,(ypos2-yoffset)/samplefac,100/samplefac,100/samplefac,/device
	xyouts,(xpos2+10-xoffset)/samplefac,(ypos2+10-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5

;	aper,image,a[4]-width+xpos,a[5]-width+ypos,flux,errap,sky,skyerr,1,[8],[10,15],[-500,30000],/flux

	xposout=xpos2 & yposout=ypos2

;	print,xposout,yposout

END

PRO file_read,files,image,PA
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

;	widget_control,hourglass=1
;	device,cursor_standard=32513

	image1=MRDFITS(files[0],0,headers1,/silent,/fscale)
	suboverscan,image1,image1_os,1,overscan
	image1=0
	image2=MRDFITS(files[1],0,headers2,/silent,/fscale)
	suboverscan,image2,image2_os,2,overscan
	image2=0
	combine_chip12,image1_os,image2_os,image,headers1
	image1_os=0 & image2_os=0
;	image=filter_image(image,median=3)

;	widget_control,hourglass=0
;	PA=sxpar(headers1,'INST-PA')-0.6
	PA=-0.638-float(sxpar(headers1,'INST-PA'))
END


PRO calc_mosshift,star_x,star_y,hole_x,hole_y,PA,winres1,winres2
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

mag=0.015/beta
;s=size(holeimage)
;maxx=s(1) & maxy=s(2)

nterm=n_elements(star_x)

x_shift=fltarr(nterm) & yy_shift=fltarr(nterm)
ang_star=fltarr(nterm) & ang_hole=fltarr(nterm) & difangle=fltarr(nterm)

; CCD coord -> Sky coord
disttransform_inv,star_x,XDistCenter,star_y,YDistCenter,star_x_trans,star_y_trans,mag,maxx,maxy,coef
disttransform_inv,hole_x,XDistCenter,hole_y,YDistCenter,hole_x_trans,hole_y_trans,mag,maxx,maxy,coef

x_shift=star_x-hole_x
yy_shift=star_y-hole_y

;mean_x_shift=mean(x_shift)
;mean_y_shift=mean(y_shift)

; Shift value (SKY coord)
x_shift_trans=star_x_trans-hole_x_trans
y_shift_trans=star_y_trans-hole_y_trans

hole_x_mean=mean(hole_x_trans)
hole_y_mean=mean(hole_y_trans)

; Mean shift value (SKY coord)
mean_x_shift_trans=mean(x_shift_trans)
mean_y_shift_trans=mean(y_shift_trans)

; Move star positions to mean hole positions (SKY coord)
star_x_shift_trans=star_x_trans-mean(x_shift_trans) 
star_y_shift_trans=star_y_trans-mean(y_shift_trans)

; Rotation calc
ang_star=atan(star_y_shift_trans-YMaskRotCenter,star_x_shift_trans-XMaskRotCenter)
ang_hole=atan(hole_y_trans      -YMaskRotCenter,hole_x_trans      -XMaskRotCenter)
difangle=ang_star-ang_hole
r_star=sqrt((star_y_shift_trans-YMaskRotCenter)^2+(star_x_shift_trans-XMaskRotCenter)^2)
mean_difangle=meanw(difangle,r_star)

ang_star2=atan(star_y_shift_trans-hole_y_mean,star_x_shift_trans-hole_x_mean)
ang_hole2=atan(hole_y_trans      -hole_y_mean,hole_x_trans      -hole_x_mean)
difangle2=ang_star2-ang_hole2
r_star2=sqrt((star_y_shift_trans-hole_y_mean)^2+(star_x_shift_trans-hole_x_mean)^2)
mean_difangle2=meanw(difangle2,r_star2)

print,'new theta',mean_difangle2*180/1.341592

dif=sqrt(x_shift_trans^2+y_shift_trans^2)

;star_x_new=star_x_trans & star_y_new=star_y_trans

; Sky coord -> CCD coord
disttransform,star_x_shift_trans,XDistCenter,star_y_shift_trans,YDistCenter,star_x_shift,star_y_shift,mag,maxx,maxy,0,0,coef_inv

; New position after rotation (SKY coord, NEW coord)
star_x_new_trans= (star_x_shift_trans-XMASKRotCenter)*cos(mean_difangle)+(star_y_shift_trans-YMASKRotCenter)*sin(mean_difangle)+XMASKRotCenter
star_y_new_trans=-(star_x_shift_trans-XMASKRotCenter)*sin(mean_difangle)+(star_y_shift_trans-YMASKRotCenter)*cos(mean_difangle)+YMASKRotCenter

; Sky coord -> CCD coord (NEW coord)
disttransform,star_x_new_trans,XDistCenter,star_y_new_trans,YDistCenter,star_x_new,star_y_new,mag,maxx,maxy,0,0,coef_inv

; CCD coord -> Sky coord (NEW coord)
disttransform_inv,star_x_new,XDistCenter,star_y_new,YDistCenter,star_x_new_trans,star_y_new_trans,mag,maxx,maxy, coef
disttransform_inv,hole_x,    XDistCenter,hole_y,    YDistCenter,hole_x_new_trans,hole_y_new_trans,mag,maxx,maxy, coef

; Mean shift (SKY coord, NEW coord)
x_shift_new=star_x_new_trans-hole_x_new_trans
y_shift_new=star_y_new_trans-hole_y_new_trans

; Rotation angle (New coord)
ang_star_new=atan(star_y_new_trans-YMASKRotCenter,star_x_new_trans-XMASKRotCenter)
difangle_new=ang_star_new-ang_hole
dif_new=sqrt(x_shift_new^2+y_shift_new^2)

; Final shift
true_X_shift=mean_x_shift_trans+mean(x_shift_new)
true_Y_shift=mean_y_shift_trans+mean(y_shift_new)
true_difangle=mean_difangle+meanw(difangle_new,r_star)

; Residual plot (SKY coord)
wset,winres1
;!P.MULTI=[0,1,2]
;!P.MULTI=[0,2,1]
partvelvec,[x_shift,1],[yy_shift,1],[star_x,500],[star_y,500],[0,4000],[0,4000]
draw_ellipse,90,427,10,10,/device
xyouts,80,400,'1pix by 1pix ref. vec.',/device,charsize=1.0
;xyouts,70,960,'Residual offset: '+strtrim(string(mean(dif)),2)+' [pix]',/device,charsize=1.5
wset,winres2
; Residual plot (SKY coord, NEW coord)
partvelvec,[x_shift_new,1],[y_shift_new,1],[star_x,500],[star_y,500],[0,4000],[0,4000]
draw_ellipse,90,77,10,10,/device
xyouts,80,55,'1pix by 1pix ref. vec.',/device,charsize=1.0
;xyouts,70,460,'Residual offset: '+strtrim(string(mean(dif_new)),2)+' [pix]',/device,charsize=1.5
!P.MULTI=0

; Results output
print,mean(x_shift_new),mean(y_shift_new),meanw(difangle_new,r_star)
print,'Shift: X=',true_x_shift,' +-',sigma(x_shift_new),' [pix]; Y=',true_y_shift,' +-',sigma(y_shift_new),' [pix]; angle=',true_difangle*180/3.141592,' +-',mean(difangle_new*180/3.141592),' [deg]'
print,'Residual offset:',mean(dif_new),' +-',sigma(dif_new),' [pix]'

;result=dialog_message('Move MOS angle '+string(-true_difangle*180/3.141592)+ ' deg. relatively.',/information)
;;result=dialog_message('Move TEL PA (= -offset) '+string(-true_difangle*180/3.141592)+ ' deg. relatively.',/information)
;result=dialog_message('Move Telescope '+string(-true_x_shift*0.1)+' arcsec N &'+string(true_y_shift*0.1)+' arcsec E, relatively.',/information)
;result=dialog_message('Move MOS angle '+string(-true_difangle*180/3.141592)+' deg., Move Telescope '+string(-true_x_shift*0.1)+' arcsec N &'+string(true_y_shift*0.1)+' arcsec E, relatively.',/information)

;if PA EQ 0  then result=dialog_message(['delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.','delta Alpha= '+strtrim(string( true_y_shift*0.1),2)+', delta Dec= '+strtrim(string(-true_x_shift*0.1),2),'Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],/information)
;if PA EQ 90 then result=dialog_message(['delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.','delta Alpha= '+strtrim(string(-true_x_shift*0.1),2)+', delta Dec= '+strtrim(string(-true_y_shift*0.1),2),'Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],/information)

pix_scale=0.1038
delta_ra =( (true_y_shift)*cos(pa*3.141592/180)-(true_x_shift)*sin(pa*3.141592/180))*pix_scale
delta_dec=(-(true_y_shift)*sin(pa*3.141592/180)-(true_x_shift)*cos(pa*3.141592/180))*pix_scale

;result=dialog_message(['delta Alpha= '+strtrim(string(delta_ra),2)+', delta Dec= '+strtrim(string(delta_dec),2),'delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.','Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],/information)
;result=dialog_message(['delta Alpha=      '+strtrim(string(delta_ra),2)+' arcsec','delta Dec=        '+strtrim(string(delta_dec),2)+' arcsec','delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.',' ','Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],/information)
;result=dialog_text(['delta Alpha=      '+strtrim(string(delta_ra),2)+' arcsec','delta Dec=        '+strtrim(string(delta_dec),2)+' arcsec','delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.',' ','Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],title='OFFSET')
result=dialog_text(['delta Alpha=      '+strtrim(string(delta_ra),2)+' arcsec','delta Dec=        '+strtrim(string(delta_dec),2)+' arcsec','delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.',' ','Residual','Before: '+strtrim(string(mean(dif)),2)+' [pix]','After: '+strtrim(string(mean(dif_new)),2)+' [pix]'],title='OFFSET',xsize=38,ysize=7)
END
;---



pro mos_pointing2_manual
;
; Hole operation first, then Star operation
;
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan,samplefac,xoffset,yoffset,maxx,maxy

read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

;read_mdp,x1,y1,x2,y2,length,width,priority,object,naxis,type;,dir=dir
read_sbr,x1,y1

x1=x1/0.015*beta;+XDistCenter
y1=y1/0.015*beta;+YDistCenter

x1_offset=x1;-XMaskCenter
;x2_offset=x2-XMaskCenter
y1_offset=y1;-YMaskCenter
;y2_offset=y2-YMaskCenter


r1 = sqrt(x1_offset^2+y1_offset^2)
;r2 = sqrt(x2_offset^2+y2_offset^2)

mag=0.015/beta
;; No transformation, just scaling
r1_trans = r1*(coef_inv[0] + coef_inv[1]*(r1*mag) + coef_inv[2]*(r1*mag)^2 + coef_inv[3]*(r1*mag)^3)
;r2_trans = r2

theta1 = atan(y1_offset,x1_offset)
;theta2 = atan(y2_offset,x2_offset)

mos_rot_offset=-mos_rot;-0.7
;print,mos_rot_offset
offset=mos_rot_offset*3.141592/180; MOS theta offset in radian
;offset=0
x1_focus=r1_trans*cos(theta1+offset)
;x2_focus=r2_trans*cos(theta2+offset)
y1_focus=r1_trans*sin(theta1+offset)
;y2_focus=r2_trans*sin(theta2+offset)

x1=x1_focus+XMaskCenter; was XMaskCenter
;x2=x2_focus+XMaskCenter
y1=y1_focus+YMaskCenter; was YMaskCenter
;y2=y2_focus+YMaskCenter

;holeid=where(type EQ 1)
;x1=x1[holeid]
;x2=x2[holeid]
;y1=y1[holeid]
;y2=y2[holeid]

;window,/free
device,cursor_standard=32
;wdelete,!D.WINDOW


fitsdir=strarr(4)

fitsdir[*]=getenv("FOCASRED_FITS_IN")+'/'
if fitsdir[0] EQ '/' then fitsdir[*]=getenv('PWD')
fitsoutdir=getenv("FOCASRED_FITS_OUT")+'/'
if fitsoutdir EQ '/' then fitsoutdir=getenv('PWD')

nterm=n_elements(x1)

;pa_input_retry:
;;result=dialog_input(prompt=["# of alignment stars","PA (deg)"],title="",nfield=2)
;result=dialog_input(prompt="PA (deg)",title=" ",nfield=1,initial=0)
;;nterm=result[0]
;nterm=n_elements(x1)
;PA=float(result[0])
;if n_elements(nterm) NE 1 then goot,pa_input_retry

;if nterm LT 0 then begin
;	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
;	CASE flag OF
;		'Retry': begin
;				goto,pa_input_retry
;			end
;		'Quit': message,'Finish!'
;	ENDCASE
;endif

;if NOT ((PA EQ 0) OR (PA EQ 90)) then begin
;	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
;	CASE flag OF
;		'Retry': begin
;				goto,pa_input_retry
;			end
;		'Quit': message,'Finish!'
;	ENDCASE
;endif

hole_x=fltarr(nterm) & hole_y=fltarr(nterm) & star_x=fltarr(nterm) & star_y=fltarr(nterm)

;set_intensity_level,holebuttom,holetop,starbuttom,startop
holebuttom=10
holetop=800
starbuttom=900
startop=1500

filenameinitial=['00000','00000','00000','00000']
retry:
;files=dialog_input(prompt=["Mask 1","Mask 2","Star 1", "Star 2"],nfield=4,title='FCSA000XXXXX (last five number)',initial=filenameinitial)
files2=dialog_input(prompt=["Mask 1","Star 1"],nfield=2,title='FCSA000XXXXX (last five number)')
files=strarr(4)
files[0]=files2[0]
files[1]=strtrim(string(files2[0]+1),1)
files[2]=files2[1]
files[3]=strtrim(string(files2[1]+1),1)

filesexp=fitsdir+'FCSA000'+files+'.fits'
print,filesexp

d = FINDFILE (filesexp[0], COUNT = fileExists)
IF (fileExists EQ 0) THEN begin
	print,'File error'

	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
			filenameinitial=files
			goto,retry
			end
		'Quit': message,'Finish!'
	ENDCASE
ENDIF

d = FINDFILE (filesexp[1], COUNT = fileExists)
IF (fileExists EQ 0) THEN begin
	print,'File error'
	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
			goto,retry
			end
		'Quit': message,'Finish!'
	ENDCASE
ENDIF

;widget_control,hourglass=1
device,cursor_standard=68
;wdelete,!D.WINDOW
file_read,filesexp[0:1],holeimage,pa
print,'PA=',pa
;widget_control,hourglass=0
device,cursor_standard=32
;wdelete,!D.WINDOW


s=size(holeimage) & maxx=s(1) & maxy=s(2)
xoffset=0 & xend=maxx-1 & yoffset=0 & yend=maxy-1 & samplefac=get_samplefac_x(maxx)*2.5; was 50, 2.0

width=40

base = WIDGET_BASE (mbar=bar,TITLE = 'MOS Pointing', /row, MAP = 0)
menu1=widget_button(bar, value='Quit',/menu)
button1=widget_button(menu1,value='Quit')

base0 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)
base1 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)
base2 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)
;base3 = WIDGET_BASE (base,TITLE = 'MOS Pointing', /column, MAP = 0,group_leader=base)

label_alignmentstars=widget_label(base0,value='     Alignment Stars     ')
w1 = WIDGET_DRAW (base0, XSIZE = FIX((xend-xoffset)/samplefac), YSIZE = FIX((xend-xoffset)/samplefac), /FRAME)
label_alignmentholes=widget_label(base1,value='     Alignment Holes     ')
w2 = WIDGET_DRAW (base1, XSIZE = FIX((xend-xoffset)/samplefac), YSIZE = FIX((xend-xoffset)/samplefac), /FRAME)
label=widget_label(base2,value='2D')
w3 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200)
label=widget_label(base2,value='3D')
w4 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200)
label=widget_label(base2,value='Before')
w6 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200)
label=widget_label(base2,value='After')
w7 = WIDGET_DRAW (base2, XSIZE = 200, YSIZE = 200)

button1 = widget_button(base0, VALUE = 'Redraw Star',/frame)
button1 = widget_button(base1, VALUE = 'Redraw Hole',/frame)

button1 = widget_button(base0, VALUE = 'Mark Star',/frame)
button1 = widget_button(base1, VALUE = 'Mark Hole',/frame)

button1 = widget_button(base0, VALUE = 'Set Star Position',/frame)
button1 = widget_button(base1, VALUE = 'Set Hole Position',/frame)
button1 = widget_button(base1, VALUE = 'Set Hole Pos (manual)',/frame)


;button1 = widget_button(base0, VALUE = 'File Read',/frame)
;button1 = widget_button(base1, VALUE = 'File Read',/frame)

button1 = widget_button(base0, VALUE = 'Refit Stars',/frame)
button1 = widget_button(base0, VALUE = 'Refit Stars Semiauto',/frame)
button1 = widget_button(base1, VALUE = 'Refit Holes',/frame)

label=widget_label(base0,value='')
button1 = widget_button(base0, VALUE = 'Change Intensity',/frame)
button1 = widget_button(base0, VALUE = 'Change Fit Reg. Size',/frame)
button1 = widget_button(base0, VALUE = 'Copy Hole Pos.',/frame)
button1 = widget_button(base0, VALUE = 'Refit All',/frame)
message=widget_label(base0,value='----- Message Window -----')

label=widget_label(base1,value='')
button1 = widget_button(base1, VALUE = 'CALC',/frame)
label=widget_label(base1,value='')
button1 = widget_button(base1, VALUE = 'Delete Hole',/frame)
button1 = widget_button(base1, VALUE = 'Reuse Hole',/frame)
label=widget_label(base1,value='')
button1 = widget_button(base1, VALUE = 'File Read',/frame)

WIDGET_CONTROL, base, /REALIZE,/UPDATE
WIDGET_CONTROL, w1, GET_VALUE = winid_star
WIDGET_CONTROL, w2, GET_VALUE = winid_hole
WIDGET_CONTROL, w3, GET_VALUE = winobs
WIDGET_CONTROL, w4, GET_VALUE = winfit
;WIDGET_CONTROL, w5, GET_VALUE = winres
WIDGET_CONTROL, w6, GET_VALUE = winres1
WIDGET_CONTROL, w7, GET_VALUE = winres2

WIDGET_CONTROL, base, MAP = 1
WIDGET_CONTROL, base0, MAP = 1
WIDGET_CONTROL, base1, MAP = 1
WIDGET_CONTROL, base2, MAP = 1
;WIDGET_CONTROL, base3, MAP = 1
;
; Mask Operation
;
expand,holeimage,FIX(maxx/samplefac),FIX(maxy/samplefac),holeimage2
wset,winid_hole
;TV,BYTSCL(holeimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=holebuttom,max=holetop)
TV,BYTSCL(holeimage2,min=holebuttom,max=holetop)
widget_control,label_alignmentholes,set_value='Holes: FCSA000'+files[0]+'+'+files[1]

;for i=0,n_elements(x1)-1 do draw_ellipse,((x1[i]+x2[i])/2-xoffset)/samplefac,((y1[i]+y2[i])/2-yoffset)/samplefac,100/samplefac,100/samplefac,/device

for i=0,n_elements(x1)-1 do draw_ellipse,((x1[i])-xoffset)/samplefac,((y1[i])-yoffset)/samplefac,100/samplefac,100/samplefac,/device

widget_control,message,set_value='Click Image for Holes.'

;
; Automatic Clicks (guess from SDR file)
;
for i=0,nterm-1 do begin
	get_pos,holeimage,x1[i],y1[i],X,Y,holebuttom,holetop,i,winid_hole,winfit,winobs,width,mode="HOLE"
	hole_x[i]=X & hole_y[i]=Y
ENDFOR

;;;;;;;;;;;;;;;;;;
; Star operation ;
;;;;;;;;;;;;;;;;;;

width=30; for single fit, was 50 for re-fit
IF filesexp[0] NE filesexp[2] then begin
nofile:
	flag = DIALOG_MENU (["Let's go to object image NOW"], TITLE = 'Click here when object image is ready.')

	d = FINDFILE (filesexp[3], COUNT = fileExists)
	IF (fileExists EQ 0) THEN BEGIN
		print,"The Files are not ready."
		goto,nofile
	END

;	widget_control,hourglass=1
	device,cursor_standard=66
;	wdelete,!D.WINDOW

	file_read,filesexp[2:3],starimage,pa
;	widget_control,hourglass=0
	device,cursor_standard=32
;	wdelete,!D.WINDOW


	expand,starimage,FIX(maxx/samplefac),FIX(maxy/samplefac),starimage2
ENDIF ELSE BEGIN
	starimage=holeimage
	starimage2=holeimage2
	star_x=hole_x & star_y=hole_y; copy hole position

ENDELSE

;
; Countlevel tuning
;
resistant_mean,starimage2,2.5,starbuttom
starbuttom=starbuttom*0.8
startop=2*starbuttom
holetop=starbuttom/0.8*0.6

wset,winid_star
;TV,BYTSCL(starimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=starbuttom,max=startop)
TV,BYTSCL(starimage2,min=starbuttom,max=startop)
widget_control,label_alignmentstars,set_value='Stars: FCSA000'+files[2]+'+'+files[3]
;for i=0,n_elements(x1)-1 do draw_ellipse,((x1[i]+x2[i])/2-xoffset)/samplefac,((y1[i]+y2[i])/2-yoffset)/samplefac,100/samplefac,100/samplefac,/device
for i=0,n_elements(x1)-1 do draw_ellipse,((x1[i])-xoffset)/samplefac,((y1[i])-yoffset)/samplefac,100/samplefac,100/samplefac,/device

star_x=hole_x & star_y=hole_y
get_pos,starimage,-1,-1,X,Y,starbuttom,50000,0,winid_star,winfit,winobs,width,mode="STAR"; 50000 was startop
star_x=star_x-(star_x[0]-X)
star_y=star_y-(star_y[0]-Y)

for i=1,nterm-1 do begin
	get_pos,starimage,star_x[i],star_y[i],X,Y,starbuttom,50000,i,winid_star,winfit,winobs,width,mode="STAR"; 50000 was startop
	star_x[i]=X & star_y[i]=Y
ENDFOR

calc_mosshift,star_x,star_y,hole_x,hole_y,PA,winres1,winres2; calc shift using all data point at first.

use=intarr(nterm)
use[*]=1

NEXT:

usearr=0
for j=1,nterm-1 do if use[j] EQ 1 then usearr=[usearr,j]

if use[0] EQ 0 then Usearr=usearr[1:*]

event = WIDGET_EVENT (base)
WIDGET_CONTROL, event.id, GET_VALUE = value;


; Event Loop

IF (value EQ 'Redraw Star') THEN begin
	wset,winid_star
;	TV,BYTSCL(starimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=starbuttom,max=startop)
	TV,BYTSCL(starimage2,min=starbuttom,max=startop)
	GOTO,NEXT
END

IF (value EQ 'Redraw Hole') THEN begin
	wset,winid_hole
;	TV,BYTSCL(holeimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=holebuttom,max=holetop)
	TV,BYTSCL(holeimage2,min=holebuttom,max=holetop)
	GOTO,NEXT
END

IF (value EQ 'Delete Hole') THEN begin
;	i=dialog_input(prompt=["Hole ID"],title="",nfield=1)
	i=fix(dialog_menu(string(indgen(nterm)),title='Hole ID'))
	use[i]=0
	GOTO,NEXT
ENDIF

IF (value EQ 'Reuse Hole') THEN begin
;	i=dialog_input(prompt=["Hole ID"],title="",nfield=1)
	i=fix(dialog_menu(string(indgen(nterm)),title='Hole ID'))
	use[i]=1
	GOTO,NEXT
ENDIF

IF (value EQ 'Set Star Position') THEN begin
	wset,winid_star
;	i=dialog_input(prompt=["Star ID"],title="",nfield=1)
	i=fix(dialog_menu(string(indgen(nterm)),title='Star ID'))
	get_pos,starimage,-1,-1,X,Y,starbuttom,50000,i,winid_star,winfit,winobs,width,mode="STAR"; 50000 was startop
	star_x[i]=X & star_y[i]=Y
	GOTO,NEXT
END

IF (value EQ 'Set Hole Position') THEN begin
	wset,winid_hole
;	i=dialog_input(prompt=["Hole ID"],title="",nfield=1)
	i=fix(dialog_menu(string(indgen(nterm)),title='Hole ID'))
	get_pos,holeimage,-1,-1,X,Y,holebuttom,holetop,i,winid_hole,winfit,winobs,width,mode="HOLE"
	hole_x[i]=X & hole_y[i]=Y
	GOTO,NEXT
END

IF (value EQ 'Set Hole Pos (manual)') THEN begin
	wset,winid_hole
;	i=dialog_input(prompt=["Hole ID"],title="",nfield=1)
	i=fix(dialog_menu(string(indgen(nterm)),title='Hole ID'))
	get_pos,holeimage,-1,-1,X,Y,holebuttom,holetop,i,winid_hole,winfit,winobs,width,mode="MANUAL"
	hole_x[i]=X & hole_y[i]=Y
	GOTO,NEXT
END

IF (value EQ 'Change Intensity') THEN begin
	set_intensity_level,holebuttom,holetop,starbuttom,startop		
	wset,winid_star
;	TV,BYTSCL(starimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=starbuttom,max=startop)
	TV,BYTSCL(starimage2,min=starbuttom,max=startop)
	wset,winid_hole
;	TV,BYTSCL(holeimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=holebuttom,max=holetop)
	TV,BYTSCL(holeimage2,min=holebuttom,max=holetop)
	GOTO,NEXT
END

IF (value EQ 'CALC') THEN begin
	calc_mosshift,star_x[usearr],star_y[usearr],hole_x[usearr],hole_y[usearr],PA,winres1,winres2
	GOTO,NEXT
END

IF (value EQ 'Mark Star') THEN begin
	mark_position,star_x[usearr],star_y[usearr],winid_star
	GOTO,NEXT
END

IF (value EQ 'Mark Hole') THEN begin
	mark_position,hole_x[usearr],hole_y[usearr],winid_hole
	GOTO,NEXT
END

IF (value EQ 'Change Fit Reg. Size') THEN begin
	result=dialog_input(prompt="Width (pixel)",title=" ",initial=width)
	width=FIX(result)
	GOTO,NEXT
END

IF (value EQ 'Quit') THEN begin
	result=dialog_message('Do you really want to quit?',/question)
	if result EQ 'Yes' then begin
		message,'Finish'	
		WIDGET_CONTROL, base, /DESTROY
		goto,ending
	endif else begin	
		goto,NEXT
	ENDELSE

	GOTO,NEXT
END

IF (value EQ 'Refit All') THEN begin
	refit_holes,holeimage,hole_x,hole_y,holebuttom,holetop,winid_hole,winfit,winobs,width,nterm,use,mode='HOLE'
	refit_stars,starimage,star_x,star_y,starbuttom,50000,winid_star,winfit,winobs,width,nterm,use,mode='STAR2'
	calc_mosshift,star_x[usearr],star_y[usearr],hole_x[usearr],hole_y[usearr],PA,winres1,winres2

	GOTO,NEXT
END

IF (value EQ 'Refit Holes') THEN begin
	refit_holes,holeimage,hole_x,hole_y,holebuttom,holetop,winid_hole,winfit,winobs,width,nterm,use,mode='HOLE'
	GOTO,NEXT
END


IF (value EQ 'Refit Stars') THEN begin
	refit_stars,starimage,star_x,star_y,starbuttom,50000,winid_star,winfit,winobs,width,nterm,use,mode='STAR2'
	GOTO,NEXT
END


IF (value EQ 'Refit Stars Semiauto') THEN begin
	star_x=hole_x & star_y=hole_y
	get_pos,starimage,-1,-1,X,Y,starbuttom,50000,0,winid_star,winfit,winobs,width,mode="STAR"; 50000 was startop
	star_x=star_x-(star_x[0]-X)
	star_y=star_y-(star_y[0]-Y)

	for i=1,nterm-1 do begin
		get_pos,starimage,star_x[i],star_y[i],X,Y,starbuttom,50000,i,winid_star,winfit,winobs,width,mode="STAR"; 50000 was startop
		star_x[i]=X & star_y[i]=Y
	ENDFOR

	GOTO,NEXT
END


IF (value EQ 'Copy Hole Pos.') THEN begin
	star_x=hole_x & star_y=hole_y
	GOTO,NEXT
END


IF (value EQ 'File Read') THEN begin

retry_in_fileread:

;	files=dialog_input(prompt=["Mask 1","Mask 2","Star 1", "Star 2"],nfield=4,title='FCSA000XXXXX (last five number)')
	files2=dialog_input(prompt=["Mask 1","Star 1"],nfield=2,title='FCSA000XXXXX (last five number)')
	files[0]=files2[0]
	files[1]=strtrim(string(files2[0]+1),1)
	files[2]=files2[1]
	files[3]=strtrim(string(files2[1]+1),1)

	filesexp=fitsdir+'FCSA000'+files+'.fits'
	print,files

	d = FINDFILE (filesexp[0], COUNT = fileExists)
	IF (fileExists EQ 0) THEN begin
		print,'File error'

		flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
		CASE flag OF
			'Retry': begin
				goto,retry_in_fileread
				end
			'Quit': goto,NEXT ;message,'Finish!'
		ENDCASE
	ENDIF

	d = FINDFILE (filesexp[1], COUNT = fileExists)
	IF (fileExists EQ 0) THEN begin
		print,'File error'
		flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
		CASE flag OF
			'Retry': begin
				goto,retry_in_fileread
				end
			'Quit': goto,NEXT; message,'Finish!'
		ENDCASE
	ENDIF

;	widget_control,hourglass=1
	device,cursor_standard=66
;	wdelete,!D.WINDOW

	file_read,filesexp[0:1],holeimage,pa
;	widget_control,hourglass=0
	device,cursor_standard=32
;	wdelete,!D.WINDOW

	expand,holeimage,FIX(maxx/samplefac),FIX(maxy/samplefac),holeimage2

	if filesexp[0] EQ filesexp[2] then begin
		starimage=holeimage
		starimage2=holeimage2
		star_x=hole_x & star_y=hole_y; copy hole position
	endif else begin
		widget_control,hourglass=1
		device,cursor_standard=66
;		wdelete,!D.WINDOW
		file_read,filesexp[2:3],starimage,pa
;		widget_control,hourglass=0
		device,cursor_standard=32
;		wdelete,!D.WINDOW


		expand,starimage,FIX(maxx/samplefac),FIX(maxy/samplefac),starimage2
	endelse

	wset,winid_star
	;TV,BYTSCL(starimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=starbuttom,max=startop)
	TV,BYTSCL(starimage2,min=starbuttom,max=startop)
	widget_control,label_alignmentstars,set_value='Stars: FCSA000'+files[2]+'+'+files[3]
	wset,winid_hole
	;TV,BYTSCL(holeimage2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=holebuttom,max=holetop)
	TV,BYTSCL(holeimage2,min=holebuttom,max=holetop)
	widget_control,label_alignmentholes,set_value='Holes: FCSA000'+files[0]+'+'+files[1]

	mark_position,star_x[usearr],star_y[usearr],winid_star
	mark_position,hole_x[usearr],hole_y[usearr],winid_hole

	refit_holes,holeimage,hole_x,hole_y,holebuttom,holetop,winid_hole,winfit,winobs,width,nterm,use,mode='HOLE'
	refit_stars,starimage,star_x,star_y,starbuttom,  50000,winid_star,winfit,winobs,width,nterm,use,mode='STAR2'

	calc_mosshift,star_x[usearr],star_y[usearr],hole_x[usearr],hole_y[usearr],PA,winres1,winres2

	GOTO,NEXT
ENDIF

ENDING:
message,'Finish'
















;
;
;
; Residual plots
;

window
r_hole=sqrt((hole_y-YMASKRotCenter)^2+(hole_x-XMASKRotCenter)^2)
plot,r_star,(r_hole-r_star)/r_star*100,xrange=[0,2000]

;
; Rotation angle
;
plot,star_y,x_shift_new,psym=2
result=poly_fit(star_y,x_shift_new,1)
;print,-result[1]*180/3.141592

plot,star_x,y_shift_new,psym=2
result=poly_fit(star_x_shift,y_shift_new,1)
;print,result[1]*180/3.141592

;
; Distortion (radial) error
;
plot,r_star,(r_star-r_hole)/r_hole*100,psym=1,yrange=[-1,1]
plot,star_x,(r_star-r_hole),psym=1,yrange=[-10,10]
plot,r_star,r_star/r_hole,psym=1,yrange=[0.98,1.02]
plot,r_star,dif_new,psym=2
;
; Chip 1, 2 gap offset error
;
plot,star_x_shift,x_shift_new,psym=2
;
; Chip 1, 2 Y offset
;
plot,star_x_shift,y_shift_new,psym=2
;
; Rot center error
;
plot,ang_star*180/3.14,difangle_new*180/3.14,psym=2

;print,sqrt((x_shift_new-mean(x_shift_new))^2+(y_shift_new-mean(y_shift_new))^2)

message,'FINISH'


;
; write shift and rot star image
;
shiftstarimage=shift(starimage_med,-true_x_shift,-true_y_shift)
shiftrotstarimage=rot(shiftstarimage,true_difangle*180/3.141592,1,XMaskRotCenter,YMaskRotCenter,/pivot,/interp)
;write_fits,shiftrotstarimage,header
write_fits,shiftrotstarimage-holeimage_med ,header
;
;  Write rotated hole image
;
rotholeimage=rot(holeimage,true_difangle*180/3.141592,1,XMASKRotCenter,YMASKRotCenter,/pivot,/interp)
write_fits,rotholeimage ,header,dir=fitsoutdir

END
