pro mos_pointing
;
; Hole operation first, then Star operation
;
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

fitsdir=strarr(4)

;if checkfocana() then begin
;	fitsdir[*]='/home/falcon/FITS/'
;;	fitsdir[*]='/data2/ohyama/M82/MOSPOINT/'
;	outfitdir=fitsdir
;endif else begin
;	fitsdir[*]='/data/o99004/'
;	outfitdir='/work/o99004/'
;endelse

fitsdir[*]=getenv("FOCASRED_FITS_IN")+'/'
if fitsdir[0] EQ '/' then fitsdir[*]=getenv('PWD')
fitsoutdir=getenv("FOCASRED_FITS_OUT")+'/'
if fitsoutdir EQ '/' then fitsoutdir=getenv('PWD')

retry:
files=dialog_input(prompt=["Mask 1","Mask 2","Star 1", "Star 2"],nfield=4,title='File Number (last four number)')

files=fitsdir+'FCSA0000'+files+'.fits'
print,files

d = FINDFILE (files[0], COUNT = fileExists)
IF (fileExists EQ 0) THEN begin
	print,'File error'
	goto,retry
endif
d = FINDFILE (files[1], COUNT = fileExists)
IF (fileExists EQ 0) THEN begin
	print,'File error'
	goto,retry
endif

;retry_alignment_star:
nterm=dialog_input(prompt="How many alignment stars do you want to use?",title="")
if n_elements(nterm) NE 1 then message,'Finish!'
if nterm LT 0 then begin
	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
				goto,pa_input_retry
			end
		'Quit': message,'Finish!'
	ENDCASE
endif

pa_input_retry:
PA=float(dialog_input(prompt="FOCAS PA (deg) [0, or 90]",nfield=1,title=''))
if NOT ((PA EQ 0) OR (PA EQ 90)) then begin
	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
				goto,pa_input_retry
			end
		'Quit': message,'Finish!'
	ENDCASE
endif
hole_x=fltarr(nterm) & hole_y=fltarr(nterm) & star_x=fltarr(nterm) & star_y=fltarr(nterm) & hole_x2=fltarr(nterm) & hole_y2=fltarr(nterm)

maskimage1=MRDFITS(files[0],0,headerm1,/silent,/fscale)
suboverscan,maskimage1,maskimage1_os,1,overscan
maskiamge1=0
maskimage2=MRDFITS(files[1],0,headerm2,/silent,/fscale)
suboverscan,maskimage2,maskimage2_os,2,overscan
maskimage2=0
;combine_chip12,maskimage1_os,maskimage2_os,holeimage,headerm1
combine_chip12,maskimage1_os,maskimage2_os,holeimage,headerm1
maskimage1_os=0 & maskimage2_os=0
;MWRFITS,holeimage,'/data2/ohyama/holeimage.fits',header
;spawn,'saoimage -fits /data2/ohyama/holeimage.fits &'
print,"Now removing pixel defects...Wait a monent please.'
holeimage_med=filter_image(holeimage,/median)
holeimage=0

window
hist=histogram(holeimage_med,min=0,max=200)
plot,FINDGEN(size(hist,/N_ELEMENTS)),hist,yrange=[0,10000]

countlevel=[10,90,100,5000]
count_input_retry:
countlevel=dialog_input(prompt=["Bottom Count of Alignment Hole",'Top Count of Alignment Hole','Bottom Count of Alignment Star','Top Count of Alignment Hole'],nfield=4,initial=countlevel,title="Input Count Level")
if (n_elements(countlevel) NE 4 ) then begin
	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
				goto,count_input_retry
			end
		'Quit': message,'Finish!'
	ENDCASE
endif
if (FIX(countlevel[0]) GT FIX(countlevel[1])) OR (FIX(countlevel[1]) GT FIX(countlevel[2])) OR FIX((countlevel[2] GT countlevel[3])) then begin
	flag = DIALOG_MENU (['Retry','Quit'], TITLE = 'Your input is wrong. Do you want to retry, or quit?')
	CASE flag OF
		'Retry': begin
				goto,count_input_retry
			end
		'Quit': message,'Finish!'
	ENDCASE
endif

holebottom=float(countlevel[0])
holetop=float(countlevel[1])
starbottom=float(countlevel[2])
startop=float(countlevel[3])

;
; Mask Operation
;


mag=0.015/beta
s=size(holeimage_med)
maxx=s(1) & maxy=s(2)


;get_star_pos_click_multi,holeimage_med,nterm,hole_x,hole_y
;get_star_pos_mean_multi,holeimage_med < skylevel > cutlevel ,nterm,hole_x,hole_y,range=[cutlevel,skylevel]
get_star_pos_multi,holeimage_med < holetop > holebottom,nterm,hole_x,hole_y,range=[holebottom,holetop],seeing=1.0,winid=0,mytitle='Alignment Hole'
;
; Star operation
;
;result=dialog_message('Click here when star image is ready!',/information)
flag = DIALOG_MENU (["Let's go to object image NOW"], TITLE = 'Click here when object image is ready.')
;
starimage1=MRDFITS(files[2],0,headers1,/silent,/fscale)
suboverscan,starimage1,starimage1_os,1,overscan
starimage1=0
starimage2=MRDFITS(files[3],0,headers2,/silent,/fscale)
suboverscan,starimage2,starimage2_os,2,overscan
starimage2=0
;combine_chip12,starimage1_os,starimage2_os,starimage,headers1
combine_chip12,starimage1_os,starimage2_os,starimage,headers1
starimage1_os=0 & starimage2_os=0
;MWRFITS,starimage,'/data2/ohyama/starimage.fits',header
;spawn,'saoimage -fits /data2/ohyama/starimage.fits &'
starimage_med=filter_image(starimage,/median)
starimage=0

get_star_pos_multi,starimage_med < startop > starbottom,nterm,star_x,star_y,range=[starbottom,startop],winid=1,mytitle='Alignment Star'
;get_star_pos_multi,starimage_med > cutlevel,nterm,star_x,star_y,range=[cutlevel,range[1]]

;
; Calcularion Start
;
x_shift=fltarr(nterm) & y_shift=fltarr(nterm)
ang_star=fltarr(nterm) & ang_hole=fltarr(nterm) & difangle=fltarr(nterm)

disttransform_inv,star_x,XDistCenter,star_y,YDistCenter,star_x_trans,star_y_trans,mag,maxx,maxy,coef
disttransform_inv,hole_x,XDistCenter,hole_y,YDistCenter,hole_x_trans,hole_y_trans,mag,maxx,maxy,coef

;print,star_x,star_x_trans,star_y,star_y_trans
;print,hole_x,hole_x_trans,hole_y,hole_y_trans

x_shift=star_x-hole_x
y_shift=star_y-hole_y

mean_x_shift=mean(x_shift)
mean_y_shift=mean(y_shift)

x_shift_trans=star_x_trans-hole_x_trans
y_shift_trans=star_y_trans-hole_y_trans

mean_x_shift_trans=mean(x_shift_trans)
mean_y_shift_trans=mean(y_shift_trans)

star_x_shift_trans=star_x_trans-mean(x_shift_trans) 
star_y_shift_trans=star_y_trans-mean(y_shift_trans)

disttransform,star_x_shift_trans,XDistCenter,star_y_shift_trans,YDistCenter,star_x_shift,star_y_shift,mag,maxx,maxy,0,0,coef_inv
;star_x_shift=star_x-mean_x_shift_trans
;star_y_shift=star_y-mean_y_shift_trans

;ang_star=atan(star_y_shift-YMosRotCenter,star_x_shift-XMosRotCenter)
ang_star=atan(star_y_shift_trans-YMaskRotCenter,star_x_shift_trans-XMaskRotCenter)
ang_hole=atan(hole_y_trans-YMaskRotCenter,hole_x_trans-XMaskRotCenter)
difangle=ang_star-ang_hole
r_star=sqrt((star_y_shift_trans-YMASKRotCenter)^2+(star_x_shift_trans-XMASKRotCenter)^2)

mean_difangle=meanw(difangle,r_star)
dif=sqrt(x_shift_trans^2+y_shift_trans^2)

star_x_new=star_x_trans & star_y_new=star_y_trans

;star_x_new= (star_x_shift-XMASKRotCen)*cos(mean_difangle)+(star_y_shift-YMASKRotCen)*sin(mean_difangle)+XMASKRotCen
;star_y_new=-(star_x_shift-XMASKRotCen)*sin(mean_difangle)+(star_y_shift-YMASKRotCen)*cos(mean_difangle)+YMASKRotCen

star_x_new_trans= (star_x_shift_trans-XMASKRotCenter)*cos(mean_difangle)+(star_y_shift_trans-YMASKRotCenter)*sin(mean_difangle)+XMASKRotCenter
star_y_new_trans=-(star_x_shift_trans-XMASKRotCenter)*sin(mean_difangle)+(star_y_shift_trans-YMASKRotCenter)*cos(mean_difangle)+YMASKRotCenter

disttransform,star_x_new_trans,XDistCenter,star_y_new_trans,YDistCenter,star_x_new,star_y_new,mag,maxx,maxy,0,0,coef_inv

;
;star_x_new_trans= (star_x_shift_trans-XMosRotCenter)*cos(mean_difangle)+(star_y_shift_trans-YMosRotCenter)*sin(mean_difangle)+XMosRotCenter
;star_y_new_trans=-(star_x_shift_trans-XMosRotCenter)*sin(mean_difangle)+(star_y_shift_trans-YMosRotCenter)*cos(mean_difangle)+YMosRotCenter

disttransform_inv,star_x_new,XDistCenter,star_y_new,YDistCenter,star_x_new_trans,star_y_new_trans,mag,maxx,maxy, coef
disttransform_inv,hole_x,    XDistCenter,hole_y,    YDistCenter,hole_x_new_trans,hole_y_new_trans,mag,maxx,maxy, coef

x_shift_new=x_shift & y_shift_new=y_shift
x_shift_new=star_x_new_trans-hole_x_new_trans
y_shift_new=star_y_new_trans-hole_y_new_trans

ang_star_new=atan(star_y_new_trans-YMASKRotCenter,star_x_new_trans-XMASKRotCenter)
difangle_new=ang_star_new-ang_hole
dif_new=sqrt(x_shift_new^2+y_shift_new^2)
;
; Final shift
;
true_X_shift=mean_x_shift_trans+mean(x_shift_new)
true_Y_shift=mean_y_shift_trans+mean(y_shift_new)
true_difangle=mean_difangle+meanw(difangle_new,r_star)

print,mean(x_shift_new),mean(y_shift_new),meanw(difangle_new,r_star)
;
; Results display
;
print,'Shift: X=',true_x_shift,' +-',sigma(x_shift_new),' [pix]; Y=',true_y_shift,' +-',sigma(y_shift_new),' [pix]; angle=',true_difangle*180/3.141592,' +-',mean(difangle_new*180/3.141592),' [deg]'
print,'Residual offset:',mean(dif_new),' +-',sigma(dif_new),' [pix]'

;result=dialog_message('Move MOS angle '+string(-true_difangle*180/3.141592)+ ' deg. relatively.',/information)
;;result=dialog_message('Move TEL PA (= -offset) '+string(-true_difangle*180/3.141592)+ ' deg. relatively.',/information)
;result=dialog_message('Move Telescope '+string(-true_x_shift*0.1)+' arcsec N &'+string(true_y_shift*0.1)+' arcsec E, relatively.',/information)
;result=dialog_message('Move MOS angle '+string(-true_difangle*180/3.141592)+' deg., Move Telescope '+string(-true_x_shift*0.1)+' arcsec N &'+string(true_y_shift*0.1)+' arcsec E, relatively.',/information)


;
; rotation vector
;
window,/free,xsize=500,ysize=1000,title='Residual Vectors'
!P.MULTI=[0,1,2]
partvelvec,[x_shift,1],[y_shift,1],[star_x,500],[star_y,500],[0,4000],[0,4000],title='Before'
draw_ellipse,113,595,20,20,/device
xyouts,70,560,'1pix by 1pix ref. vec.',/device,charsize=1.5
xyouts,70,960,'Residual offset: '+strtrim(string(mean(dif)),2)+' [pix]',/device,charsize=1.5

partvelvec,[x_shift_new,1],[y_shift_new,1],[star_x,500],[star_y,500],[0,4000],[0,4000],title='After'
draw_ellipse,113,95,20,20,/device
xyouts,70,60,'1pix by 1pix ref. vec.',/device,charsize=1.5
xyouts,70,460,'Residual offset: '+strtrim(string(mean(dif_new)),2)+' [pix]',/device,charsize=1.5
!P.MULTI=0

if PA EQ 0 then result=dialog_message(['delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.','delta Alpha= '+strtrim(string(true_y_shift*0.1),2)+', delta Dec= '+strtrim(string(-true_x_shift*0.1),2)],/information)
if PA EQ 90 then result=dialog_message(['delta MOS angle = '+strtrim(string(-true_difangle*180/3.141592),2)+' deg.','delta Alpha= '+strtrim(string(-true_x_shift*0.1),2)+', delta Dec= '+strtrim(string(-true_y_shift*0.1),2)],/information)

result=dialog_message('Mos Pointing Finished',/information)
;
message,'Finish'
;
;
;
; Residual plots
;

window
r_hole=sqrt((hole_y-YMASKRotCenter)^2+(hole_x-XMASKRotCenter)^2)
plot,r_star,(r_hole-r_star)/r_star*100,xrange=[0,2000]

;
; Rotation angle
;
plot,star_y,x_shift_new,psym=2
result=poly_fit(star_y,x_shift_new,1)
;print,-result[1]*180/3.141592

plot,star_x,y_shift_new,psym=2
result=poly_fit(star_x_shift,y_shift_new,1)
;print,result[1]*180/3.141592

;
; Distortion (radial) error
;
plot,r_star,(r_star-r_hole)/r_hole*100,psym=1,yrange=[-1,1]
plot,star_x,(r_star-r_hole),psym=1,yrange=[-10,10]
plot,r_star,r_star/r_hole,psym=1,yrange=[0.98,1.02]
plot,r_star,dif_new,psym=2
;
; Chip 1, 2 gap offset error
;
plot,star_x_shift,x_shift_new,psym=2
;
; Chip 1, 2 Y offset
;
plot,star_x_shift,y_shift_new,psym=2
;
; Rot center error
;
plot,ang_star*180/3.14,difangle_new*180/3.14,psym=2

;print,sqrt((x_shift_new-mean(x_shift_new))^2+(y_shift_new-mean(y_shift_new))^2)

message,'FINISH'


;
; write shift and rot star image
;
shiftstarimage=shift(starimage_med,-true_x_shift,-true_y_shift)
shiftrotstarimage=rot(shiftstarimage,true_difangle*180/3.141592,1,XMaskRotCenter,YMaskRotCenter,/pivot,/interp)
;write_fits,shiftrotstarimage,header
write_fits,shiftrotstarimage-holeimage_med ,header
;
;  Write rotated hole image
;
rotholeimage=rot(holeimage,true_difangle*180/3.141592,1,XMASKRotCenter,YMASKRotCenter,/pivot,/interp)
write_fits,rotholeimage ,header,dir=fitsoutdir

END
