pro calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xoffset,yoffset
common share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default,waveoffset_default,length_default,width_default
	length=(x2-x1)/bin[0]/samplefac
;	length=(y2-y1)/bin[0]/samplefac; for trans image
	width=(y2-y1)/bin[1]/samplefac
;	width=(x2-x1)/bin[1]/samplefac; for trans image

	xcen=((x1+x2)/2-xoffset)/bin[0]/samplefac
	ycen=((y1+y2)/2-yoffset)/bin[1]/samplefac
	waveoffset=waveoffset_default/bin[1]/samplefac
	ycen2=ycen+waveoffset
	wavecoveradge[*]=wavecoveradge_default/bin[1]/samplefac
end

pro draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
common share8,samplefac,bin,wavecoveradge,waveoffset,length_default,width_default
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xoffset,yoffset
	wset,0
	tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid],[255,255,255]
	tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],[255,255,255]
end

pro show_spectrum,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image,id,range
;
; Display a spectrum for a slit
; This task is for the specturm image
;
common share8,samplefac,bin,wavecoveradge,waveoffset,length_default,width_default
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xoffset,yoffset
	window,2,xsize=length[id],ysize=wavecoveradge[id]
	wset,2
;	image3=image[xcen[id]-length[id]/2:xcen[id]+length[id]/2,ycen2[id]-wavecoveradge[id]/2:ycen2[id]+wavecoveradge[id]/2)]
	image3=extrac(image,xcen[id]-length[id]/2,ycen2[id]-wavecoveradge[id]/2,length[id],wavecoveradge[id])

	tv,bytscl(image3,min=range[0],max=range[1])
	print,length[id],wavecoveradge[id]
end

pro reduce_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image,id,range,naxis,yohaku
;
;
;
common share8,samplefac,bin,wavecoveradge,waveoffset,length_default,width_default
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xoffset,yoffset
	window,2,xsize=length[id]*samplefac,ysize=wavecoveradge[id]*samplefac
	wset,2
;	image3=image[xcen[id]-length[id]/2:xcen[id]+length[id]/2,ycen2[id]-wavecoveradge[id]/2:ycen2[id]+wavecoveradge[id]/2)]
	image3=extrac(image,(xcen[id]-length[id]/2)*samplefac,(ycen2[id]-wavecoveradge[id]/2)*samplefac,length[id]*samplefac,wavecoveradge[id]*samplefac)
	tv,bytscl(image3,min=range[0],max=range[1])
	fspecred_engine,image,header,2,(xcen[id]-length[id]/2)*samplefac+yohaku,(xcen[id]+length[id]/2)*samplefac-yohaku,(ycen2[id]-wavecoveradge[id]/2)*samplefac+yohaku > 0,(ycen2[id]+wavecoveradge[id]/2)*samplefac-yohaku < naxis[1]-1, image_ff,compimage_ff,grismrotflag=0; chip=2 for bigimage
	write_fits,image_ff,header,dir=workdir
	write_fits,compimage_ff,header,dir=workdir
end

pro show_spectra_all,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image,range
common share8,samplefac,bin,wavecoveradge,waveoffset,length_default,width_default
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xoffset,yoffset
	x_size=0
	newimage=fltarr(1,wavecoveradge[0]*samplefac)
	for id=0,n_elements(x1)-2 do begin
	;	image3=image[xcen[id]-length[id]/2:xcen[id]+length[id]/2,ycen2[id]-wavecoveradge[id]/2:ycen2[id]+wavecoveradge[id]/2)]
		image3=extrac(image,(xcen[id]-length[id]/2)*samplefac,(ycen2[id]-wavecoveradge[id]/2)*samplefac,length[id]*samplefac,wavecoveradge[id]*samplefac)
		newimage=[newimage,image3]
		x_size=x_size+length[id]*samplefac
	end
	window,2,xsize=x_size,ysize=wavecoveradge[id]
	imdisp,bytscl(newimage,min=range[0],max=range[1]),margin=0
	write_fits,newimage,header
	wset,0
end

pro draw_slit_id,length,width,xcen,ycen,id
tvbox2,length[id]/2,width[id]/2,xcen[id],ycen[id]
end

pro draw_fov,xFOVcen,yFOVcen,r
common share8,samplefac,bin,wavecoveradge,waveoffset,length_default,width_default
draw_ellipse,xFOVcen/samplefac,yFOVcen/samplefac,r/samplefac,r/samplefac,resolution=100,/device
end

pro get_nearest_slit,xcen,ycen,id
	wset,0
	click=fltarr(2)
	CURSOR,tmp_x,tmp_y,/device
	click[0]=tmp_x & click[1]=tmp_y
	r=sqrt((xcen-click[0])^2+(ycen-click[1])^2)
	id=where(r EQ min(r))
	if n_elements(id) NE 1 then id=id[0]
end

pro make_id,delid,goodid,x1
goodid=indgen(n_elements(x1))
if size(delid,/n_dimensions) NE 0 then remove,delid,goodid
end

pro add_delid,delid,id
if size(delid,/n_dimensions) EQ 0 then delid=[id] else delid=[delid,id]
end

pro pro_overlap,j,i,length,width,xcen,ycen,priority,delid
	print,'Overlap',j, i
	tvbox2,length[j]/2,width[j]/2,xcen[j],ycen[j]
	tvbox2,length[i]/2,width[i]/2,xcen[i],ycen[i]
	if priority[j] LT priority[i] then begin
		add_delid,delid,i
		print,'Deleted ',i
		end
	if priority[i] LT priority[j] then begin
		add_delid,delid,j
		print,'Deleted ',j
	end
end

pro set_params,pickupbox_size,holesize,slit_space,xoffset,yoffset,num,yohaku
common share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default

	params=dialog_input(prompt=["Pickup Box Size","Aperture Size (diameter)",'Space between slits (in Pix: for Autoexpanding slits)','Xoffset','Yoffset','Yohaku','Default Slit Length (Pixel)','Default Slit Width (Pixel)'],nfields=8,initial=[pickupbox_size,20,slit_space,xoffset,yoffset,yohaku,length_default*bin[0]*samplefac,width_default*bin[1]*samplefac],title='Parameter Setting')
	IF(n_elements(params) NE 8) THEN return
	pickupbox_size=fix(params[0])
	holesize=float(params[1]/bin[1]/samplefac)/2.
	slit_space=float(params[2])
	xoffset=float(params[3])
	yoffset=float(params[4])
	yohaku=fix(params[5])
	length_default=float(params[6])/bin[0]/samplefac
	width_default=float(params[7])/bin[1]/samplefac
	window,1,xsize=pickupbox_size*2,ysize=pickupbox_size*2,title='Pickup Box'
end

pro set_grism,num
common share8,samplefac,bin, wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default

	params=dialog_menu(['75','150','300B','300R'],title='Grism Selection')
	IF(n_elements(params) EQ 0) THEN return

case params of

'75': begin
	directwave=6500; ang
	wavestart=4700
	waveend=9500
	disp=5.46
end

'150': begin
	directwave=6500; ang
	wavestart=4700
	waveend=9500
	disp=2.72
end

'300B': begin
	directwave=5500; ang
	wavestart=4700
	waveend=9500
	disp=1.34
end

'300R': begin
	directwave=7500; ang
	wavestart=4700
	waveend=9500
	disp=1.34
end

endcase

	wavecoveradge_default=(waveend-wavestart)/disp
	waveoffset_default=(directwave-(waveend+wavestart)/2)/disp

	wavecoveradge=fltarr(num)
	wavecoveradge[*]=wavecoveradge_default/bin[1]/samplefac
	waveoffset=waveoffset_default/bin[1]/samplefac
end

pro input_mdp,x1,y1,x2,y2,length,width,priority,object,naxis,type,dir;,width_default,length_default
common share8,samplefac,bin, wavecoveradge,waveoffset,wavecoveradge_default, waveoffset_default,length_default,width_default
	read_mdp,x1,y1,x2,y2,length,width,priority,object,naxis,type,dir=dir
	width[*]=width[*]/bin[1]/samplefac
	width_default=width[0]
	length[*]=length[*]/bin[0]/samplefac
	length_default=length[0]
end
;
; Main
;
pro mdp
common share8,samplefac,bin,wavecoveradge,waveoffset,wavecoveradge_default,waveoffset_default,length_default,width_default

;if checkfocana() then fitsdir='.' else fitsdir='/work/o99004'
fitsdir=getenv("FOCASRED_FITS_IN")+'/'
if fitsdir EQ '/' then fitsdir=getenv('PWD')

read_fits,image,header,dir=fitsdir,myfilter='*fits',mytitle='Input BigImage',MYGETPATH=mygetpath
bin=SXPAR(header,'BIN-FCT*')
objectname=SXPAR(header,'OBJECT')
exptime=SXPAR(header,'EXPTIME')
naxis=SXPAR(header,'NAXIS*')
samplefac=get_samplefac(naxis[1])

input_mdp,x1,y1,x2,y2,length,width,priority,object,naxis,type,mygetpath;idth_default,length_default

result=dialog_message('Transposed?',/question)
;result=dialog_checklist('Transposed?',/nonexclusive)
;if result[0] EQ 1 then begin
	if result EQ 'Yes' then begin
;	image=rotate(image,3)
	hrotate, image, header,imagerot, header_new,3,ERRMSG = errmsg
	image=imagerot
	header=header_new
endif

num=n_elements(x1)

;type=intarr(num)
;type[*]=0; 0 means slit

s=size(image)
maxx=s(1) & maxy=s(2)
xoffset=0 & xend=maxx & yoffset=0 & yend=maxy
delid=-1
goodid=indgen(num)
slit_space=0
pickupbox_size=100
yohaku=5
;
; Paramter Initialize
;

set_params,pickupbox_size,holesize,slit_space,xoffset,yoffset,num,yohaku
set_grism,num

r=3.25*60/0.1; 3 arcmin FOV in pix
read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

xFOVcen=XRotatorCenter
yFOVcen=YRotatorCenter

expand,image,FIX(maxx/samplefac),FIX(maxy/samplefac),image2
WINDOW,0,xsize=FIX((xend-0)/samplefac),ysize=FIX((yend-0)/samplefac),TITLE=objectname
imdisp,sigrange(image2,fraction=0.95,range=range),margin=0
draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset

;window,1,xsize=pickupbox_size*2,ysize=pickupbox_size*2
wset,0

;catch,error_status
;if error_status NE 0 then begin
;		print,'The following error happened, and recovered.'
;		print,!ERR_STRING
;endif

REPEAT BEGIN

flag = DIALOG_MENU (['Read MDP file','Redraw','Auto Intensity Scale','Change Intensity Scale','Mark RA DEC','Mark RA DEC List',$
	'Draw Slit','Draw FOV','Show Nearest Slit','Show Slit(ID)','Show Spectrum','Show All Spectra','Reduce Spectrum(ID)','Del Nearest Slit',$
	'Add Nearest Slit','Add Alignment Hole','Change Slit Length','Zoom Around Clicked Position','Automatic Slit Width Expantion',$
	'Slit Overlap Check','Show Slit List','Display Slit ID',$
	'Change Default Parameters','Grism Select','Change Color Table',$
	'Save SBR (For Distortion Corrected Image)','Save SBR (For Distortion UN-Corrected Image)','Save SBR (CCD)','Save Ascii Extension','END'], TITLE = 'MDP menu',xposition=100,yposition=100)

	CASE flag OF

'Redraw': begin
	wset,0
	imdisp,bytscl(image2,min=range[0],max=range[1]),margin=0
 	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
 	draw_fov,xFOVcen,yFOVcen,r
	END

'Change Intensity Scale': begin
	wset,0
	range=dialog_input(prompt=["MIN","MAX"],nfields=2,initial=range)
	IF(n_elements(range) NE 2) THEN break
	imdisp,bytscl(image2,min=range[0],max=range[1]),margin=0
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
	end

'Auto Intensity Scale': begin
	wset,0
	imdisp,sigrange(image2,fraction=0.95,range=range),margin=0
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
	end

'Draw Slit': begin
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
	end

'Show Spectrum': begin
	id=fix(dialog_input(prompt='Input Slit ID (Count from Zero)',title='User Input'))
	if (id LT 0) OR (id GE n_elements(xcen)) then begin
		id=0
		print,'Your input is out or range... Showing ID=0'
	endif
	show_spectrum,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image2,id,range
	end

'Show All Spectra': begin
		show_spectra_all,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image,range
	end

'Reduce Spectrum(ID)': begin
	id=fix(dialog_input(prompt='Input Slit ID (Count from Zero)',title='User Input'))
	if (id LT 0) OR (id GE n_elements(xcen)) then begin
		id=0
		print,'Your input is out or range... Showing ID=0'
	endif
	reduce_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset,image,id,range,naxis,yohaku
	end

'Show Nearest Slit': BEGIN
	wset,0
	get_nearest_slit,xcen,ycen,id
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
	draw_slit_id,length,width,xcen,ycen,id
	xnear=xcen[id] & ynear=ycen[id]
	print,'Slit ID= ',id
	wset,1

	start_x=xnear[0]*samplefac-pickupbox_size & start_y=ynear[0]*samplefac-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[xnear[0]*samplefac-pickupbox_size > 0:xnear[0]*samplefac+pickupbox_size,ynear[0]*samplefac-pickupbox_size > 0:ynear[0]*samplefac+pickupbox_size],min=range[0],max=range[1]),margin=0
	samplefac_old=samplefac
	samplefac=1
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xnear[0]*samplefac_old*bin[0]-pickupbox_size*bin[0]+xoffset,ynear[0]*samplefac_old*bin[1]-pickupbox_size*bin[1]+yoffset
	tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid],[255,255,255]
	tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],[255,255,255]
	samplefac=samplefac_old
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xoffset,yoffset
	wset,0
	print,x1[id],x2[id],format='("Left, Right=",2F10.2)'

	xyad, header, (x1+y1)[id]/2, (y1+y2)[id]/2, a, d, /print
	END

'Show Slit(ID)': BEGIN
	id=fix(dialog_input(prompt='Input Slit ID (Count from Zero)',title='User Input'))
	if (id LT 0) OR (id GE n_elements(xcen)) then begin
		id=0
		print,'Your input is out or range... Showing ID=0'
	endif
	xnear=xcen[id] & ynear=ycen[id]
	print,'Slit ID= ',id
	wset,1
	start_x=xnear[0]*samplefac-pickupbox_size & start_y=ynear[0]*samplefac-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[xnear[0]*samplefac-pickupbox_size:xnear[0]*samplefac+pickupbox_size,ynear[0]*samplefac-pickupbox_size:ynear[0]*samplefac+pickupbox_size],min=range[0],max=range[1]),margin=0
	samplefac_old=samplefac
	samplefac=1
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xnear[0]*samplefac_old*bin[0]-pickupbox_size*bin[0]+xoffset,ynear[0]*samplefac_old*bin[1]-pickupbox_size*bin[1]+yoffset
	samplefac=samplefac_old
	tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid],[255,255,255]
	tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],[255,255,255]
	samplefac=samplefac_old
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xoffset,yoffset
	wset,0
	print,x1[id],x2[id],format='("Left, Right=",2F10.2)'

	xyad, header, (x1+y1)[id]/2, (y1+y2)[id]/2, a, d, /print
	END

'Del Nearest Slit': BEGIN
	wset,0
	get_nearest_slit,xcen,ycen,id
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
	draw_slit_id,length,width,xcen,ycen,id
	add_delid,delid,id
	make_id,delid,goodid,x1
	END

'Add Nearest Slit': BEGIN
	wset,0
	CURSOR,tmp_x,tmp_y,/device
	click2=fltarr(2)
	click2[0]=tmp_x*samplefac & click2[1]=tmp_y*samplefac
	wset,1
	start_x=click2[0]-pickupbox_size & start_y=click2[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click2[0]-pickupbox_size:click2[0]+pickupbox_size,click2[1]-pickupbox_size:click2[1]+pickupbox_size],min=range[0],max=range[1]),margin=0

	flag2=dialog_menu(['Pick Object','Click Point'],title='How to select the object?')
	case flag2 of
		'Click Point': begin
		CURSOR,tmp_x,tmp_y,/device
		click3=fltarr(2)
		click3[0]=tmp_x & click3[1]=tmp_y
		click3[0]=click3[0]-pickupbox_size+click2[0]
		click3[1]=click3[1]-pickupbox_size+click2[1]

		start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,start_x,start_y,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;		imdisp,bytscl(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],min=range[0],max=range[1]),margin=0
		end
		'Pick Object': begin
		CURSOR,tmp_x,tmp_y,/device
		click3=fltarr(2)
		click3[0]=tmp_x-pickupbox_size+click2[0] & click3[1]=tmp_y-pickupbox_size+click2[1]

		start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,start_x,start_y,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;		imdisp,bytscl(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],min=range[0],max=range[1]),margin=0
		result=gauss2dfit(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],a)
		click3[0]=a[4]-pickupbox_size+click3[0] & click3[1]=a[5]-pickupbox_size+click3[1]

		start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
		width_x=2*pickupbox_size+1 & width_y=width_x
		image_cut=extrac(image,start_x,start_y,width_x,width_y)
		imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

		end
	endcase

	tvbox2,length_default*samplefac/2,width_default*samplefac/2,pickupbox_size,pickupbox_size,[255,255,255]
	ycen3=click3[1]+waveoffset
	tvbox2,length_default/2*samplefac,wavecoveradge*samplefac/2,pickupbox_size,pickupbox_size,[255,255,255]

	wset,0

	x1=[x1,click3[0]*bin[0]-length_default/2*bin[0]*samplefac]
	x2=[x2,click3[0]*bin[0]+length_default/2*bin[0]*samplefac]
	y1=[y1,click3[1]*bin[1]-width_default/2*bin[1]*samplefac]
	y2=[y2,click3[1]*bin[1]+width_default/2*bin[1]*samplefac]
	width=[width,width_default]
	length=[length,length_default]
	wavecoveradge=[wavecoveradge,wavecoveradge_default]
	priority=[priority,3]
	type=[type,0]; 0 mean slit
	object=[object,'Newly Added Slit']
	make_id,delid,goodid,x1
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
end

'Zoom Around Clicked Position': BEGIN
	wset,0
	CURSOR,tmp_x,tmp_y,/device
	click2=fltarr(2)
	click2[0]=tmp_x*samplefac & click2[1]=tmp_y*samplefac
	xnear=click2[0] & ynear=click2[1]
	wset,1

	start_x=click2[0]-pickupbox_size & start_y=click2[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click2[0]-pickupbox_size:click2[0]+pickupbox_size,click2[1]-pickupbox_size:click2[1]+pickupbox_size],min=range[0],max=range[1]),margin=0
	samplefac_old=samplefac
	samplefac=1
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xnear[0]*samplefac_old*bin[0]-pickupbox_size*bin[0]+xoffset,ynear[0]*samplefac_old*bin[1]-pickupbox_size*bin[1]+yoffset
	samplefac=samplefac_old
	tvbox2,length[goodid]/2,width[goodid]/2,xcen[goodid],ycen[goodid],[255,255,255]
	tvbox2,length[goodid]/2,wavecoveradge[goodid]/2,xcen[goodid],ycen2[goodid],[255,255,255]
	samplefac=samplefac_old
	calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xoffset,yoffset
	wset,0
END

'Add Alignment Hole': BEGIN
	wset,0
	CURSOR,tmp_x,tmp_y,/device
	click2=fltarr(2)
	click2[0]=tmp_x*samplefac & click2[1]=tmp_y*samplefac
	wset,1

	start_x=click2[0]-pickupbox_size & start_y=click2[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click2[0]-pickupbox_size:click2[0]+pickupbox_size,click2[1]-pickupbox_size:click2[1]+pickupbox_size],min=range[0],max=range[1]),margin=0

	CURSOR,tmp_x,tmp_y,/device
	click3=fltarr(2)
	click3[0]=tmp_x-pickupbox_size+click2[0] & click3[1]=tmp_y-pickupbox_size+click2[1]

	start_x=click3[0]-pickupbox_size & start_y=click3[1]-pickupbox_size
	width_x=2*pickupbox_size+1 & width_y=width_x
	image_cut=extrac(image,start_x,start_y,width_x,width_y)
	imdisp,bytscl(image_cut,min=range[0],max=range[1]),margin=0

;	imdisp,bytscl(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],min=range[0],max=range[1]),margin=0
	result=gauss2dfit(image[click3[0]-pickupbox_size:click3[0]+pickupbox_size,click3[1]-pickupbox_size:click3[1]+pickupbox_size],a)
	click3[0]=a[4]-pickupbox_size+click3[0] & click3[1]=a[5]-pickupbox_size+click3[1]

	print,'Exposure Time',exptime
	print,'Sky Level, Sky Count Rate',a[0],a[0]/exptime
	print,'Peak Count, Peak Count Rate',a[1],a[1]/exptime
	print,'Seeing (arcsec in FWHM for X & Y)',a[2]*2.355,a[3]*2.355

	tvbox2,holesize*samplefac/2,holesize*samplefac/2,pickupbox_size,pickupbox_size,[255,255,255]
	ycen3=click3[1]+waveoffset*samplefac
	tvbox2,holesize*samplefac/2,wavecoveradge*samplefac/2,pickupbox_size,pickupbox_size,[255,255,255]

	wset,0

	x1=[x1,click3[0]*bin[0]-holesize*samplefac/2*bin[0]]
	x2=[x2,click3[0]*bin[0]+holesize*samplefac/2*bin[0]]
	y1=[y1,click3[1]*bin[1]-holesize*samplefac/2*bin[0]]
	y2=[y2,click3[1]*bin[1]+holesize*samplefac/2*bin[0]]
	width=[width,width_default]
	length=[length,length_default]
	wavecoveradge=[wavecoveradge,wavecoveradge_default]
	priority=[priority,0]
	make_id,delid,goodid,x1
	id=n_elements(x1)-1
	length[id]=holesize
	width[id]=length[id]
	type=[type,1]; 1 means hole
	object=[object,'Alignment Hole']
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
end

'Change Slit Length': begin
	get_nearest_slit,xcen,ycen,id
	wset,0
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
	draw_slit_id,length,width,xcen,ycen,id
	newx12=dialog_input(prompt=["Left","Right"],nfields=2,initial=[x1[id],x2[id]])
	if n_elements(newx12) NE 2 then	break
	x1[id]=newx12[0] & x2[id]=newx12[1]
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
	END

'Save SBR (For Distortion Corrected Image)': begin
	write_sbr,      x1,y1,x2,y2,xFOVcent,yFOVcent,width*bin[1]*samplefac,holesize*bin[1]*samplefac,type,delid
	END

'Save SBR (CCD)': begin
	write_sbr_ccd,x1,y1,x2,y2,xFOVcent,yFOVcent,     width*bin[1]*samplefac,holesize*bin[1]*samplefac,type,delid
	END

'Save SBR (For Distortion UN-Corrected Image)': begin
	write_sbr_trans,x1,y1,x2,y2,                      width*bin[1]*samplefac,holesize*bin[1]*samplefac,type,delid
	END

'Save Ascii Extension': begin
	write_aext,x1,y1,x2,y2,type,object,delid,header
	END

;'Change Window Size': begin
;	pickupbox_size=float(dialog_input(prompt='Pickup Box Size',nfields=1,initial=pickupbox_size))
;	window,1,xsize=pickupbox_size*2,ysize=pickupbox_size*2
;end

'Automatic Slit Width Expantion': begin
	newx2=x2
	for j=0,n_elements(x1)-1 do begin
		newid=where(x1 GT x2[j])
		if min(newid) NE -1 then newx2[j]=min(x1[newid]) else newx2[j]=x2[j]
		if type[j] EQ 1 then newx2[j]=x2[j]
	endfor
	x2=newx2-(slit_space+1)
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
	end

'Slit Overlap Check': begin
calc_slit_pos,x1,x2,y1,y2,length,width,xcen,ycen,ycen2,xoffset,yoffset
flag3=0
for j=0,n_elements(x1)-1 do begin
	if max(delid EQ j) EQ 1 then goto,skiploop_j
	for i=0,n_elements(x1)-1 do begin
		if max(delid EQ i) EQ 1 then goto,skiploop_i
		if (x1[j] GT x1[i]) and (x1[j] LT x2[i]) and ((ycen2-wavecoveradge/2)[j] GT (ycen2-wavecoveradge/2)[i]) and ((ycen2-wavecoveradge/2)[j] LT (ycen2+wavecoveradge/2)[i]) then begin
			pro_overlap,j,i,length,width,xcen,ycen,priority,delid & flag3=1 & end
		if (x2[j] GT x1[i]) and (x2[j] LT x2[i]) and ((ycen2-wavecoveradge/2)[j] GT (ycen2-wavecoveradge/2)[i]) and ((ycen2-wavecoveradge/2)[j] LT (ycen2+wavecoveradge/2)[i]) then begin
			pro_overlap,j,i,length,width,xcen,ycen,priority,delid & flag3=1 & end
		if (x1[j] GT x1[i]) and (x1[j] LT x2[i]) and ((ycen2+wavecoveradge/2)[j] GT (ycen2-wavecoveradge/2)[i]) and ((ycen2+wavecoveradge/2)[j] LT (ycen2+wavecoveradge/2)[i]) then begin
			pro_overlap,j,i,length,width,xcen,ycen,priority,delid & flag3=1 & end
		if (x2[j] GT x1[i]) and (x2[j] LT x2[i]) and ((ycen2+wavecoveradge/2)[j] GT (ycen2-wavecoveradge/2)[i]) and ((ycen2+wavecoveradge/2)[j] LT (ycen2+wavecoveradge/2)[i]) then begin
			pro_overlap,j,i,length,width,xcen,ycen,priority,delid & flag3=1 & end
		skiploop_i:
	endfor
	skiploop_j:
endfor
make_id,delid,goodid,x1
if flag3 EQ 0 then print,'OK'
end

'Show Slit List': begin
	make_id,delid,goodid,x1
	num=n_elements(x1)
	list=string(indgen(num))
	types=strarr(num)
	types[*]='S'
	holeid=where(type EQ 1)
	if size(holeid,/n_dimensions) NE 0 then types[holeid]='H'
	list2=strtrim(list,2) + ' ' + types + ' ' + object
	result=dialog_checklist(list2,/nonexclusive,initial=goodid,/scroll,y_scroll_size=800,x_scroll_size=500,xposition=100,yposition=100)
	if total(result) EQ 0 then goto,jump_cancel
	delid=where(fix(result) EQ 0)
	make_id,delid,goodid,x1
	draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
	jump_cancel:
end

'Draw FOV': begin
	xyr=dialog_input(prompt=["Xcen","Ycen","Radius"],nfields=3,initial=[xFOVcen,yFOVcen,r])
	IF n_elements(xyr) NE 3 THEN break
	xFOVcen=float(xyr[0])
	yFOVcen=float(xyr[1])
	r=float(xyr[2])
	wset,0
	draw_fov,xFOVcen,yFOVcen,r
end
'Change Default Parameters': begin
set_params,pickupbox_size,holesize,slit_space,xoffset,yoffset,n_elements(x1),yohaku
end

'Grism Select': begin
set_grism,n_elements(x1)
draw_slit,x1,x2,y1,y2,goodid,delid,length,width,xcen,ycen,ycen2,xoffset,yoffset
end

'Read MDP file': begin
input_mdp,x1,y1,x2,y2,length,width,priority,object,naxis,type;,width_default,length_default
end

'Mark RA DEC': begin
result=dialog_input(prompt=["Hour",'Min','Sec','Deg','Min','Sec'],nfield=6)
if n_elements(result) NE 6 then break
hh=float(result[0])
mm=float(result[1])
ss=float(result[2])
dhh=float(result[3])
dmm=float(result[4])
dss=float(result[5])

dec=ten(dhh,dmm,dss)
ra=ten(hh,mm,ss)*15.

adxy,header,ra,dec,x,y,/print
draw_ellipse,x/samplefac,y/samplefac,100/samplefac,100/samplefac,resolution=10,/device
end

'Mark RA DEC List': begin
read_radec,ra,dec
if n_element(ra) EQ 0 then break
adxy,header,ra,dec,x,y,/print
for j=0,n_elements(ra)-1 do draw_ellipse,x[j]/samplefac,y[j]/samplefac,100/samplefac,100/samplefac,resolution=10,/device
end
;
; End
;
'Change Color Table': begin
table=fix(dialog_input(prompt=["Color table number (1-40)"]))
if n_elements(table) NE 1 then break
loadct,table
end

'Display Slit ID': begin
xyouts,(x2/samplefac/bin[0])[goodid],(y1/samplefac/bin[1])[goodid],(strtrim(string(indgen(n_elements(x1))),2))[goodid],/device,charsize=1.5
end

'END': BEGIN & END ; do nothing
''   : BEGIN & END ; do nothing
'---': BEGIN & END ; do nothing, separator


ENDCASE

ENDREP UNTIL ((flag EQ 'END') OR (flag EQ ''))

message,'FINISH'

end
