pro lineimage

samplefac=2
nstar=float(dialog_input(prompt=['# of stars']))
width=40
filename=STRARR(2)

xpos=FLTARR(nstar)
ypos=FLTARR(nstar)
xpos2=FLTARR(nstar)
ypos2=FLTARR(nstar)
mags1=FLTARR(nstar)
mags2=FLTARR(nstar)
FWHM1=FLTARR(nstar)
FWHM2=FLTARR(nstar)
sky1=FLTARR(nstar)
sky2=FLTARR(nstar)
rotangle1=FLTARR(nstar)
rotangle2=FLTARR(nstar)

;fitsdir='/data2/ohyama/MisawaQSO/'
fitsdir='/home/ohyama/'


filename[0]=DIALOG_PICKFILE(PATH=fitsdir,filter='*.fits',title='On image')
IF(STRLEN(filename[0]) EQ 0) THEN stop

filename[1]=DIALOG_PICKFILE(PATH=fitsdir,filter='*.fits',title='Off image')
IF(STRLEN(filename[1]) EQ 0) THEN stop

onimage = MRDFITS(filename[0], 0, header,/fscale,/silent)
naxison= SXPAR(header,'NAXIS*')
offimage= MRDFITS(filename[1], 0, header,/fscale,/silent)
naxisoff= SXPAR(header,'NAXIS*')


window,0,xsize=naxison[0]/samplefac,ysize=naxison[1]/samplefac,title='On image'
imdisp,sigrange(onimage),margin=0
window,1,xsize=naxisoff[0]/samplefac,ysize=naxisoff[1]/samplefac,title='Off image'
imdisp,sigrange(offimage),margin=0
window,2,xsize=naxisoff[0]/samplefac,ysize=naxisoff[0]/samplefac

for i=0,nstar-1 do begin
	wset,0
	cursor,xpos_tmp,ypos_tmp,/normal
	xpos[i]=xpos_tmp*naxison[0] & ypos[i]=ypos_tmp*naxison[1] & print,xpos[i],ypos[i]
	result =gauss2dfit( onimage[ xpos[i]-width: xpos[i]+width, ypos[i]-width: ypos[i]+width],a)
	wset,2
	show3,result
	xpos[i]=a[4]+xpos[i]-width & ypos[i]=a[5]+ypos[i]-width & print,xpos[i],ypos[i]
	FWHM1[i]=(a[2]+a[3])/2*2.355
	aper,onimage,xpos[i],ypos[i],mags1_tmp,errap,sky_tmp,skyerr,1,[fwhm1[i]*5],[fwhm1[i]*5,fwhm1[i]*8],[-500,30000],/flux
	mags1[i]=mags1_tmp
	sky1[i]=sky_tmp

	wset,1
	cursor,xpos_tmp,ypos_tmp,/normal
	xpos2[i]=xpos_tmp*naxisoff[0] & ypos2[i]=ypos_tmp*naxisoff[1] & print,xpos2[i],ypos2[i]
	result2=gauss2dfit(offimage[xpos2[i]-width:xpos2[i]+width,ypos2[i]-width:ypos2[i]+width],a)
	wset,2
	show3,result2
	xpos2[i]=a[4]+xpos2[i]-width & ypos2[i]=a[5]+ypos2[i]-width & print,xpos2[i],ypos2[i]
	FWHM2[i]=(a[2]+a[3])/2*2.355
	aper,offimage,xpos2[i],ypos2[i],mags2_tmp,errap,sky_tmp,skyerr,1,[fwhm2[i]*5],[fwhm2[i]*5,fwhm2[i]*8],[-500,30000],/flux
	mags2[i]=mags2_tmp
	sky2[i]=sky_tmp
endfor
wdelete,2
print,''
print,mags1,mags2,mags1/mags2
print,''

s=size(offimage)
xcen=s[1]/2 & ycen=s[2]/2

xshift=mean(xpos)-mean(xpos2)
yshift=mean(ypos)-mean(ypos2)

for i=0,nstar-1 do begin
	xpos[i]=xpos[i]-xshift
	ypos[i]=ypos[i]-yshift
	rotangle1[i]=atan(( ypos[i]-ycen)/( xpos[i]-xcen))*180/3.141592
	rotangle2[i]=atan((ypos2[i]-ycen)/(xpos2[i]-xcen))*180/3.141592
	print,rotangle1[i],rotangle2[i],rotangle2[i]-rotangle1[i]
endfor

difangle=mean(rotangle2-rotangle1)
print,difangle
offimager=rot(offimage,difangle,/interp)
;offimage=extrac(offimager,0,0,naxisoff[0],naxisoff[1])

maxdim_x=max([naxison[0],naxisoff[0]])
maxdim_y=max([naxison[1],naxisoff[1]])

onimagee  =extrac(onimage,  0,0,maxdim_x,maxdim_y)
offimagee=extrac(offimager,0,0,maxdim_x,maxdim_y)
offimagees=shift (offimagee,FIX(xshift),FIX(yshift))
xamari=xshift-FIX(xshift)
yamari=yshift-FIX(yshift)
offimagees=interpolate(offimagees,findgen(maxdim_x)-xamari,findgen(maxdim_y)-yamari,/grid)

max_fwhm=max([fwhm1,fwhm2])
if mean(fwhm1) GT mean(fwhm2) then begin
psf=psf_gaussian(npixel=mean(fwhm1)*2,FWHM=[mean(fwhm1),mean(fwhm1)],/normal)
convonimage=convolve(onimagee.psf)
convoffimage=convolve(offimagees,psf)
end else begin
psf=psf_gaussian(npixel=mean(fwhm2)*2,FWHM=[mean(fwhm2),mean(fwhm2)],/normal)
convonimage=convolve(onimagee,psf)
convoffimage=convolve(offimagees,psf)
endelse

sconvonimage=convonimage*mean(mags2[0]/mags1[0])
image=sconvonimage-convoffimage
imdisp,sigrange(image),margin=0
write_fits,image,header

message,'Finish'

do_nothing:

end
