pro linear2

samplefac=2
readxs2,nfilename,nfilename2,exp,nfiles,getfilename=chiplistfilename

linear_max=10000; 0212a, even
;linear_max=25000; 0212a, odd
;linear_max=6000; 0212b, odd
;linear_max=15000; 0211, 1st
;linear_max=10000; 0211, 2nd
;linear_max=5000; 0212c, odd

linear_max=40000; MIT
linear_max=25000; MV new CDS

linear_max=13000; 25
linear_max=12000; 50


linear_min=100
linear_min=300; for 0212a, odd, 0212a, even
linear_min=300; for MIT

width=45; was 15

filename=nfilename[nfiles-1]

image= MRDFITS(filename, 0, header,/fscale,/silent)
name = SXPAR( header ,'OBJECT')
naxis= SXPAR( header,'NAXIS*')

;WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
;imdisp,sigrange(image),margin=0

;CURSOR,line,column,/normal
;line=line*naxis[0] & column=column*naxis[1]
;startx=FIX(line) & starty=FIX(column)
;startx=1156 & starty=477

;startx=1430 & starty=1; 0212a even
;startx=1720 & starty=1; 0212a odd
;startx=1900 & starty=1; 0212b odd
;startx=1770 & starty=1; 0211 chip 1
;startx=1600 & starty=1; 0211 chip 2
;startx=2000 & starty=1; 0212c odd

;startx=3500 & starty=200; 35 right
;startx=2500 & starty=200; 70 right

startx=1000 & starty=50; left 35, 70
startx=1000 & starty=100; left 50
;startx=3000 & starty=100; left 50

;startx=1800 & starty=500; MIT chip 2
;startx=550 & starty=1900; MIT chip 1
;wait,0.5
;CURSOR,line,column,/normal
;line=line*naxis[0] & column=column*naxis[1]
;endx=FIX(line) & endy=FIX(column)

endx=startx+width & endy=starty+width
;print,startx,endx,starty,endy
;endx=startx & endy=starty

; read bias image array
;
	bfilename=DIALOG_PICKFILE(PATH='~/grpscr/LINEARITY/',filter='*.fits')
	IF(STRLEN(bfilename) EQ 0) THEN stop
;
; read main image array
;
	biasimage= MRDFITS(bfilename, 0, header,/fscale,/silent)
;

;
; Bias region selection
;
;wait,0.5
;CURSOR,line,column,/normal
;line=line*naxis[0] & column=column*naxis[1]
;bstartx=FIX(line) & bstarty=FIX(column)
;wait,0.5
;CURSOR,line,column,/normal
;line=line*naxis[0] & column=column*naxis[1]
;bendx=FIX(line) & bendy=FIX(column)
;print,bstartx,bendx,bstarty,bendy

;biasvalue=dblarr(nfiles)
;time=dblarr(nfiles)
;exptime=[5,10,25,50,75,100]
;FOR fileid=0,nfiles-1 DO BEGIN
;;	print,nfilename[fileid]
;	image= MRDFITS(nfilename[fileid], 0, header,/fscale,/silent)
;	exptime[fileid] = SXPAR( header ,'EXPTIME')
;	time[fileid] = SXPAR( header ,'MJD')
;;	endx=startx & endy=starty
;	pixvalue[fileid]=MEAN(image[startx:endx,starty:endy]-biasimage[startx:endx,starty:endy])
;;	pixvalue[fileid]=MEAN(image[startx:endx,starty:endy])
;;	biasvalue[fileid]=MEDIAN(image[2000:2040,50:3950]); for chip 1
;;	biasvalue[fileid]=MEDIAN(biasimage[startx:endx,starty:endy])
;;	biasvalue[fileid]=MEDIAN(image[bstartx:bendx,bstarty:bendy])
;;	pixvalue[fileid]=pixvalue[fileid]-biasvalue[fileid]
;	print,nfilename[fileid],exptime[fileid],pixvalue[fileid];,biasvalue[fileid]
;ENDFOR ; fileid loop

difpixvalue=dblarr(nfiles)
;biasvalue=dblarr(nfiles)

npix=(endx-startx+1)*(endy-starty+1)

exptime=dblarr(nfiles*npix)
pixvalue=dblarr(nfiles*npix)
pixvaluebs=dblarr(nfiles*npix)
fittedvalue1d=dblarr(nfiles*npix)

meanexptime=dblarr(nfiles)
meanpixvalue=dblarr(nfiles)
rmspixvalue=dblarr(nfiles)

eachexptime=dblarr(nfiles)
eachpixvalue=dblarr(nfiles)

;pixvaluesum=dblarr(nfiles*npix)
;fittedvaluesum=dblarr(nfiles*npix)
res=dblarr(nfiles*npix)

pixvalue3d=dblarr(nfiles,endx-startx+1,endy-starty+1)
exptime3d=dblarr(nfiles,endx-startx+1,endy-starty+1)
pixvalue3dbs=dblarr(nfiles,endx-startx+1,endy-starty+1)


k=0
FOR fileid=0,nfiles-1 DO BEGIN
	image= MRDFITS(nfilename[fileid], 0, header,/fscale,/silent)
	image2= MRDFITS(nfilename2[fileid], 0, header,/fscale,/silent)
	image=image-biasimage
;	bsimage=image-mean(image[4040:4092,*])
;	overscan=mean(image[4040:4090,150:300])
;	overscan=mean(image[1990:2030,150:300])

	bsimage=image-image2
	print,nfilename[fileid]
	FOR j=0,endy-starty do begin
		FOR i=0,endx-startx do begin
;		exptime[k]=SXPAR( header ,'EXPTIME')
		exptime[k]=EXP[fileid]

		pixvalue[k]=bsimage[i+startx,j+starty]
		pixvaluebs[k]=bsimage[i+startx,j+starty]
		pixvalue[k]=image[i+startx,j+starty];-overscan
;		print,pixvalue[k],image[i+startx,j+starty],biasimage[i+startx,j+starty]
		pixvalue3d[fileid,i,j]=pixvalue[k]
		pixvalue3dbs[fileid,i,j]=pixvaluebs[k]
		exptime3d[fileid,i,j]=exptime[k]
		k=k+1
		ENDFOR
	ENDFOR
;meanexptime[fileid] = SXPAR( header ,'EXPTIME')
meanexptime[fileid] = EXP[fileid]
meanpixvalue[fileid]=mean(pixvalue3d[fileid,*,*])
;aho=moment(pixvalue3d[fileid,*,*])
rmspixvalue[fileid]=sqrt(variance(pixvalue3dbs[fileid,*,*])/2.)
ENDFOR



gamma=dblarr(npix)
eachres=dblarr(nfiles*npix)

!P.MULTI=[0,2,2]
window,1,xsize=800,ysize=600,title='Linearity'
k=0
FOR j=0,endy-starty do begin
	FOR i=0,endx-startx do begin
	eachpixvalue[*]=pixvalue3d[*,i,j]
	eachexptime[*]=exptime3d[*,i,j]

	weight=dblarr(nfiles)
;	weight[*]=sqrt(eachpixvalue)
	weight[*]=1.0
	;exptime=[5,10,25,50,75,100]
	A=dblarr(3)
	A[0]=(eachpixvalue[4]-eachpixvalue[1])/(eachexptime[4]-eachexptime[1])
	A[1]=1.0 & A[2]=0
;	weight[*]=0.0 & weight[where(eachpixvalue LT linear_max)]=sqrt(eachpixvalue[where(eachpixvalue LT linear_max)] * 2.5); & weight[where(eachpixvalue LT linear_min)]=0
	weight[*]=1.0
	result=COMFIT(eachexptime,eachpixvalue,A,yfit=eachfittedvalue,/GEOMETRIC,sigma=sigmaresult,weight=weight)
	result2=POLYFITW(eachexptime,eachpixvalue,weight,1,eachfittedvalue1d)

	eachfittedvalue1d=meanclip_func(eachpixvalue/eachexptime,3)*eachexptime
	gamma[k]=result[1]
;	print,"Gamma=",gamma[fileid],"+-",sigmaresult[1]
;	print,"Zero point=",result[2],"+-",sigmaresult[2]
	eachres=dblarr(nfiles)
	eachres=(eachpixvalue-eachfittedvalue1d)/eachfittedvalue1d*100
	for l=0,nfiles-1 do begin
		res[nfiles*k+l]=eachres[l]
;		pixvaluedif[nfiles*k+l]=eachpixvalue[l]-eachfittedvalue1d[l]
		fittedvalue1d[nfiles*k+l]=eachfittedvalue1d[l]
	endfor

	plot,eachexptime, eachpixvalue,psym=2,yrange=[0,40000],xrange=[0,30]             & oplot,eachexptime,eachfittedvalue & oplot,eachexptime,eachfittedvalue1d,linestyle=2
	plot,eachexptime, eachpixvalue,yrange=[1,40000],xrange=[1,30],psym=2,/ylog,/xlog & oplot,eachexptime,eachfittedvalue & oplot,eachexptime,eachfittedvalue1d,linestyle=2
	plot,eachpixvalue,eachres,/ynozero,psym=2,/xlog,yrange=[-10,10],xrange=[1,40000]
	plot,eachexptime, eachpixvalue/eachexptime,/ynozero,/xlog
	k=k+1
	ENDFOR
ENDFOR

print,meanclip_func(gamma,3),robust_sigma(gamma)
plot,fittedvalue1d,res,psym=2,/xlog,yrange=[-20,20]
print,robust_sigma(res)
plothist,gamma,bin=0.001

;bsimage=image-bsimage
;eachpixvaluemax=dblarr(npix)
;l=0
;fileid=nfiles-1-1
;image= MRDFITS(nfilename[fileid], 0, header,/fscale,/silent)
;print,nfilename[fileid]
;FOR j=0,endy-starty do begin
;	FOR i=0,endx-startx do begin
;	eachpixvaluemax[l]=bsimage[i+startx,j+starty]
;;	print,eachexptime[k],eachpixvalue[k]
;	l=l+1
;	ENDFOR ; fileid loop
;ENDFOR

;FOR fileid=1,nfiles-1 DO difpixvalue[fileid]=(pixvalue[fileid]-pixvalue[fileid-1])/(exptime[fileid]-exptime[fileid-1])


; Indivi.
;

exptime=exptime
A=dblarr(3)
A[0]=(pixvalue[4*npix]-pixvalue[1*npix])/(exptime[4*npix]-exptime[0*npix])
A[1]=1.0 & A[2]=0

linear_min=1300

weight=dblarr(npix*nfiles) & weight[*]=0 & weight[where(pixvalue LT linear_max)]=sqrt(pixvalue[where(pixvalue LT linear_max)] * 2.5) & weight[where(pixvalue LT linear_min)]=0
;weight[*]=1.0

result=COMFIT(exptime,pixvalue,A,yfit=fittedvalueall,weight=weight,/GEOMETRIC,sigma=sigmaresult)
result2=POLYFITW(exptime,pixvalue,weight,1,fittedvalue1dall)
print,"Gamma=",result[1],"+-",sigmaresult[1]
print,"Zero point=",result[2],"+-",sigmaresult[2]

;fittedvalue1dall=meanclip_func(pixvalue/exptime,3)*exptime
;resall=(pixvalue-fittedvalueall)/fittedvalueall*100
;result2=POLYFITW(exptime,pixvalue,weight,1,eachfittedvalue1dall)
resall=(pixvalue-fittedvalue1dall)/fittedvalue1dall*100

!P.MULTI=[0,2,2]
window,1,xsize=800,ysize=600,title='Linearity'
plot,exptime,pixvalue,yrange=[0,40000],xrange=[0,30],psym=1,xtitle='Exptime (s)',ytitle='Counts (ADU)',title=chiplistfilename & oplot,exptime,fittedvalueall & oplot,exptime,fittedvalue1dall,linestyle=1
plot,exptime,pixvalue,yrange=[1,40000],psym=1,xtitle='Exptime (s)',ytitle='Counts (ADU)',title=string(result[1])+' '+string(result2[0]),/ylog,/xlog & oplot,exptime,fittedvalueall & oplot,exptime,fittedvalue1dall,linestyle=1
plot,fittedvalue1dall,resall,xtitle='Counts (ADU)',ytitle='Linearity Residual (%)',title=string(linear_max),psym=1,xrange=[0,40000],/ynozero,yrange=[-10,10]
plot,exptime,pixvalue/exptime,xtitle='Exptime (s)',ytitle='Counts (ADU)/Exptime (s)',yrange=[median(pixvalue/exptime)-300,median(pixvalue/exptime)+300],ystyle=1,/xlog,psym=1,xrange=[0.5,100]
!P.MULTI=0

;
; MEAN
;
;exptime=[2.,4.,8.,16.,32.]
;exptime=[5,10,25,50,75,100]
linear_min=600
myweight=dblarr(nfiles)
myweight[*]=0 & myweight[where(meanpixvalue LT linear_max)]=sqrt(meanpixvalue[where(meanpixvalue LT linear_max)]*2.5) & myweight[where(meanpixvalue LT linear_min)]=0
;myweight[*]=1.0

A=dblarr(3)
A[0]=(meanpixvalue[3]-meanpixvalue[1])/(meanexptime[3]-meanexptime[1])
A[1]=1.0
A[2]=0

result=COMFIT(meanexptime,meanpixvalue,A,yfit=meanfittedvalue,/GEOMETRIC,sigma=sigmaresult,weight=myweight)
fresult2=POLYFITW(meanexptime,meanpixvalue,myweight,1,meanfittedvalue1d)
meanfittedvalue1d=meanclip_func(meanpixvalue/meanexptime)*meanexptime
print,"Gamma=",result[1],"+-",sigmaresult[1]
print,"Zero point=",result[2],"+-",sigmaresult[2]
meanres=(meanpixvalue-meanfittedvalue1d)/meanfittedvalue1d*100

!P.MULTI=[0,2,2]
window,1,xsize=800,ysize=600,title='Linearity'
plot,meanexptime, meanpixvalue,/ynozero,psym=2,xtitle='Exptime (s)',ytitle='Counts (ADU)',title=chiplistfilename & oplot,meanexptime,meanfittedvalue & oplot,meanexptime,meanfittedvalue1d,linestyle=3
plot,meanexptime, meanpixvalue,/ynozero,psym=2,/ylog,/xlog,xtitle='Exptime (s)',ytitle='Counts (ADU)',title=string(result[1])+' '+string(result2[0]) & oplot,meanexptime,meanfittedvalue & oplot,meanexptime,meanfittedvalue1d,linestyle=3
plot,meanpixvalue,meanres,/ynozero,/xlog,psym=2,xtitle='Counts (ADU)',ytitle='Linearity Residual (%)',title=string(linear_max)
plot,meanpixvalue, meanpixvalue/meanexptime,/ynozero,/xlog,psym=2,xtitle='Exptime (s)',ytitle='Counts (ADU)/Exptime (s)'
!P.MULTI=0

;plot,exptime,difpixvalue,/xlog,psym=2
;

message,"Finish"
; signal - variance curve
plot,eachpixvalue,rmspixvalue^2,psym=2
myweight=eachpixvalue
myweight[*]=1.
aho=POLYFITW(eachpixvalue[0:6],rmspixvalue[0:6]^2,myweight,1,varpixvaluefit)
oplot,eachpixvalue,varpixvaluefit
print,'gain=',1./aho[1],'e/ADU'

;exptime=[5,10,25,50,75,100,125,150]
;aho=dialog_plot2(xdata=pixvalue,ydata=res,/ynozero,psym=2,yrange=[-5,5],xrange=[0,20000],/ps_option)

formInfo = cmps_form(Cancel=canceled, Create=create)

IF NOT canceled THEN BEGIN
	IF create THEN BEGIN
        	thisDevice = !D.Name & Set_Plot, "PS" & Device, filename='aho.ps';,_Extra=formInfo
!P.MULTI=[0,2,2]
;window,1,xsize=800,ysize=600,title='Linearity'
plot,exptime,pixvalue,yrange=[0,25000],psym=1,xtitle='Exptime (s)',ytitle='Counts (ADU)',title=chiplistfilename & oplot,exptime,fittedvalueall & oplot,exptime,fittedvalue1dall,linestyle=3
plot,exptime,pixvalue,yrange=[0.1,25000],psym=1,xtitle='Exptime (s)',ytitle='Counts (ADU)',title=string(result[1])+' '+string(result[2]),/ylog,/xlog & oplot,exptime,fittedvalueall & oplot,exptime,fittedvalue1dall,linestyle=3
plot,fittedvalue1dall,resall,xtitle='Counts (ADU)',ytitle='Linearity Residual (%)',title=string(linear_max),xrange=[0,25000],psym=1,/ynozero,yrange=[-10,10]
plot,exptime,pixvalue/exptime,xtitle='Exptime (s)',ytitle='Counts (ADU)/Exptime (s)',yrange=[median(pixvalue/exptime)-300,median(pixvalue/exptime)+300],ystyle=1,/xlog,psym=1
!P.MULTI=0
		Device, /Close & Set_Plot, thisDevice

	ENDIF
ENDIF

message,'Finish'
;
; Conversion factor plot
;
result=DIALOG_PLOT2(XDATA=alog10(meanpixvalue),YDATA=meanpixvalue/rmspixvalue^2,/YNOZERO,yrange=[0,4],xtitle='Counts (ADU)',ytitle='Counts(ADU) / RMS(ADU)^2',title="Conversion Factor for Chip 2",/PS_OPTION)

do_nothing:

END
