pro imcombine,MYFITSDIR=fitsdir

IF (not keyword_set(myfitsdir)) THEN myfitsdir = '/data2/ohyama/IRAS/'

bnfiles=dialog_input(prompt="How many files to combine?")
bfilename=STRARR(bnfiles)

for i=0,bnfiles-1 do begin
	bfilename[i]=DIALOG_PICKFILE(PATH=myfitsdir,filter='*.fits',title='Bias filename')
	IF(STRLEN(bfilename[i]) EQ 0) THEN stop
endfor

bias1= MRDFITS(bfilename[1], 0, header,/fscale,/silent)
naxis= SXPAR( header,'NAXIS*')

bias=FLTARR(naxis[0],naxis[1],bnfiles,/nozero)
bias[*,*,0]=bias1

for i=1,bnfiles-1 do begin
	print,bfilename[i]
	bias[*,*,i]= float(MRDFITS(bfilename[i], 0, header,/silent))
endfor

outarr = make_array( dimen = naxis, /NOZERO, /float )

;outtarr=total(bias,3)/bnfiles
sigclipavgarr,bias,outarr

write_fits,outarr,header,dir=fitsdir

end
