PRO identify_engine,spec,compwave,fit_result_guess,fit_result,fit_result_linear,lpos2,WIDTH=width

if N_elements(width) EQ 0 then width=1
delay=1
fit_order=2
compwidth=18; =8 for B300 Blue
ncomplines=n_elements(compwave)


x=FINDGEN(N_elements(spec))

fit_result=FLTARR(fit_order)
new_fit_result=FLTARR(fit_order)
lpos2=FLTARR(ncomplines)
wave2=FLTARR(ncomplines)

window,0,xsize=600,ysize=400
window,1,xsize=600,ysize=400
window,2,xsize=600,ysize=400

new_fit_result=fit_result_guess

wset,0
FOR i=0,ncomplines-1 DO BEGIN
	cen=compwave[i]

;	lposnew=(cen-compwidth-new_fit_result[0])/new_fit_result[1]
	tmp=cen-compwidth
	lposnew=(-new_fit_result[1]-sqrt(new_fit_result[1]^2-4*new_fit_result[2]*(new_fit_result[0]-tmp)))/(2*new_fit_result[2])
	Xnew=FIX(lposnew)

	tmp=cen+compwidth
	lposnew=(-new_fit_result[1]-sqrt(new_fit_result[1]^2-4*new_fit_result[2]*(new_fit_result[0]-tmp)))/(2*new_fit_result[2])
;	lposnew=(cen+compwidth-new_fit_result[0])/new_fit_result[1]
	X2new=FIX(lposnew)

	IF Xnew GT X2new then begin tmp=X2new & X2new = Xnew & Xnew = tmp & ENDIF

	XX=X(XNew:X2new) & YY=spec(Xnew:X2new) & XCEN=(XNew+X2new)/2
	YY=YY-MIN(YY) & YY=YY/MAX(YY)
	plot,XX,YY,/YNOZERO,yrange=[-0.1,1.1],xrange=[lposnew,lposnew+compwidth*2],xstyle=1

	lposnew=XX##transpose(YY/total(YY))
;	lposnew=(-new_fit_result[1]-sqrt(new_fit_result[1]^2-4*new_fit_result[2]*(new_fit_result[0]-cen)))/(2*new_fit_result[2])
;	lposnew=(cen-new_fit_result[0])/new_fit_result[1]
	maxvalue=max(YY)
	lposnew=where(YY EQ maxvalue)

;	lposnew=(max(XX)-min(XX))/2+min(XX)

	if N_ELEMENTS(lposnew) GE 2 then lposnew=mean(lposnew)
	est=[1,xx[FIX(lposnew)],width,0]
;	est=[1,lposnew,width,0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)

	est=[1,coef[1],coef[2],0]
	XXmin=XX[where ((XX GT coef[1]-10) AND (XX LT coef[1]+10))]
	YYmin=YY[where ((XX GT coef[1]-10) AND (XX LT coef[1]+10))]

	result=GAUSSFIT(XXmin,YYmin,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	oplot,XXmin,result,psym=10

;	XXX=X[FIX(XCEN-2*5):FIX(XCEN+2*5)] & YYY=spec[FIX(XCEN-2*5):FIX(XCEN+2*5)]
;	YYY=YYY-MIN(YYY) & YYY=YYY/MAX(YYY)
;	est=[1,XCEN,width,0]
;	result=GAUSSFIT(XXX,YYY,coef,NTERMS=4,ESTIMATE=est)
;	PRINT,'Amp., Cen., FWHM, Cont', coef

;	plot,XXX,YYY,/YNOZERO
;	oplot,XXX,result,psym=10

	wait,delay

	wave2[i]=cen
	lpos2[i]=coef[1]

ENDFOR ; end of i loop

;
; wavecalib at one column
;
;fit_result=POLY_FIT(lpos2,wave2,fit_order,wavefit)
fit_result=robust_POLY_FIT(lpos2,wave2,fit_order,wavefit,3)
print,fit_result
;fit_result_linear=POLY_FIT(lpos2,wave2,1,wavefit_linear)
;fit_result_linear=POLY_FIT(lpos2,wave2,2,wavefit_linear)
fit_result_linear=robust_POLY_FIT(lpos2,wave2,2,wavefit_linear,3)
fit_result_1storder=robust_POLY_FIT(lpos2,wave2,1,wavefit_1storder,3)
fit_result_highorder=robust_poly_fit(lpos2,wave2,3,wavefit_highorder,3)
wset,1
plot,lpos2,wave2,/YNOZERO
oplot,lpos2,wave2,psym=2
oplot,lpos2,wavefit

wset,2
plot,lpos2,wave2-wavefit
oplot,lpos2,wave2-wavefit,psym=2
oplot,lpos2,wave2-wavefit_highorder,psym=3
wait,delay

print,fit_result_1storder

FINISH:
END
