pro hartmann2,FITSDIR=fitsdir

; Hartmann2 with range setting

;
; Task for Hartmann test
; Read two images, mark line positions, measure the line positions of two images,
; find the difference of the two lines, and, finally, plot the difference with the position.
;
;if checkfocana() then fitsdir='/home/falcon/FITS/' else fitsdir='/data/o99004/'
fitsdir=getenv("FOCASRED_FITS_IN")+'/'
if fitsdir EQ '/' then fitsdir=getenv('PWD')

nsum=20
estwidth=3

IF (N_ELEMENTS(fitsdir) EQ 0) THEN $
   fitsdir = '~'

;fitsdir='/data/FITS'
;;;
;;; main program
;;;
;
; Read a pair of Haltman images
;
	filename1=DIALOG_PICKFILE(PATH=fitsdir,filter='FCSA*.fits',title='Select 1st image file',get_path=mygetpath)
	IF(STRLEN(filename1) EQ 0) THEN goto,do_nothing
;
; read 1st main image array
;
	image= MRDFITS(filename1, 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')
	samplefac=get_samplefac(naxis[1])

	filename2=DIALOG_PICKFILE(PATH=mygetpath,filter='FCSA*.fits',title='Select 2nd image file')
	IF(STRLEN(filename2) EQ 0) THEN goto,do_nothing
;
; read 2nd main image array
;
	image2nd= MRDFITS(filename2, 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')
;
; read ascii extension
;
;	asciiext= MRDFITS(nfilename[0], 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;
        xmin=50 & xmax=naxis[0]-xmin & ymin=50 & ymax = naxis[1]-ymin

        image=image-MIN(image)
        image=trimarray(image,xmin,xmax,ymin,ymax)
        naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1

        image2nd=image2nd-MIN(image2nd)
        image2nd=trimarray(image2nd,xmin,xmax,ymin,ymax)
        naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1

;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE='Click to select a line for Hartmann measuerement'

	range=[0,10000]
;	dummy=sigrange(image2,fraction=0.999,range=range)
	range=[median(image2)-200,median(image2)+200]
retry:
	TV,BYTSCL(image2,min=range[0],max=range[1]),/device


flag = DIALOG_MENU (['Yes','No'], TITLE = 'Do you want to change the intensity range?')
        CASE flag OF
                'Yes': begin
                                range=dialog_input(prompt=["MIN Count Level","MAX Count Level"],nfields=2,initial=range,title="Changing Display Count Level")
                                goto,retry
                        end
                'No': goto,ok
        ENDCASE
ok:


	; window id 0 reserved for TV display
	nposition=dialog_input(prompt="How many Hartmann pairs?")

	WINDOW,1,xsize=1250,ysize=500,TITLE='Click two times to select an emission line'
	; window id 1 reserved for plot display
;
; main loop
;
pos1=FLTARR(nposition)
pos2=FLTARR(nposition)
dif=FLTARR(nposition)
POSX=FLTARR(nposition)
POSY=FLTARR(nposition)
fwhm1=fltarr(nposition)
fwhm2=fltarr(nposition)

FOR posid=0,nposition-1 DO BEGIN

; Find aperture position

	wset,0
	CURSOR,line,column,/device
	column=column*samplefac
	line=line*samplefac & POSX[posid]=line

; Extract line profile

	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 DO BEGIN
		X[i]=i
		Y[i]=total(image(FIX(line)-FIX(nsum/2):FIX(line)+FIX(nsum/2),i),1)
	ENDFOR

	wset,1
	PLOT,X,Y,/ynozero

; Set useful data region

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=YY-MIN(YY) & YY = YY/MAX(YY)

	ERASE
	PLOT,XX,YY,/ynozero

; do the fit

	estpos=XX ## TRANSPOSE(YY/total(YY))
	est=[1,estpos,estwidth,0]
        result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	OPLOT,XX,result,PSYM=10
	fwhm1[posid]=coef[2]*2.355
	pos1[posid]=coef[1]
	POSY[posid]=pos1[posid]
;
; 2nd file
;
	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 do begin
		X[i]=i
		Y[i]=total(image2nd(FIX(line)-FIX(nsum/2):FIX(line)+FIX(nsum/2),i),1)
	ENDFOR

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=YY-MIN(YY) & YY=YY/MAX(YY)
	OPLOT,XX,YY,linestyle=1

	estpos=XX ## TRANSPOSE (YY/total(YY))
        est=[1,estpos,estwidth,0]
        result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	OPLOT,XX,result,PSYM=10

	pos2[posid]=coef[1]
	fwhm2[posid]=coef[2]*2.355

	dif[posid]=pos1[posid]-pos2[posid]
	print,filename1,filename2,'Peak offset',dif[posid],'line width (FWHM pix)', fwhm1[posid],fwhm2[posid]

ENDFOR

;
; Results output
;

	IF (nposition=1) then begin
	print,'Move Z stage by ',dif[0]*0.84/3.02,' mm'; equation derived on 2000/1/30
	goto, finish
	endif

	difstat=moment(dif)
	mean_dif=difstat(0)
	mean_var=difstat(1)

	tilt_result_x=poly_fit(POSX,dif,1)
	tiltx=tilt_result_x(1)*180/3.141593

	tilt_result_y=POLY_FIT(POSy,dif,1)
	tilty=tilt_result_y(1)*180/3.141593

	print,"mean shift =",mean_dif,"(+-",mean_var,") tilt (x, y)=(",tiltx,tilty,") (deg)"

; Older version
;	z_shift=mean_dif*0.84/3.02
; New version by KBT. No longer multiply 2/3
	z_shift=mean_dif/3.834

	result=dialog_message('Move Z stage by '+string(z_shift)+' mm.')

print,'Move Z stage by ',z_shift,' mm.'
print,'Do not multiply 2/3 any more!!'

	WINDOW,3,xsize=500,ysize=250,TITLE=name
	PLOT,posx,dif,/ynozero,psym=2,xtitle="X pos.",ytitle="Shift"
	WINDOW,4,xsize=500,ysize=250,TITLE=name
	PLOT,posy,dif,/ynozero,psym=2,xtitle="Y pos.",ytitle="Shift"

;message,'Finish!'

do_nothing:
finish:

END
