PRO grismrot_engine,image,outimage,a0,a1,xstart,xend,ystart,yend,xbin,ybin
;
; region in binned ccd pixel numbers
;
IF (not keyword_set(suboverscanflag)) THEN suboverscanflag = 0
IF (not keyword_set(fluxconserveflag)) THEN fluxconserveflag = 0
IF (not keyword_set(convolveflag)) THEN convolveflag = 0

;read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
mag=0.015/beta
;;;
;;; main program
;;;
s=size(image)
naxis=intarr(2)
naxis[0]=s[1]
naxis[1]=s[2]

if suboverscanflag EQ 1 then begin
	suboverscan,image,osimage,chip,overscan
	image=osimage
	undefine,osimage
endif else begin
	endelse

xFOVcenter=xDISTcenter
yFOVcenter=yDISTcenter

;if chip EQ 0 then begin; chip=0 means chip1
;	X_CEN=xFOVcenter-2047-gapsize-75*2; 75 correct the overscan
;	Y_CEN=yFOVcenter
;endif else if chip EQ 1 then begin
;	X_CEN=xFOVcenter
;	Y_CEN=yFOVcenter-y_shift
;endif else if chip EQ 2 then begin
;	X_CEN=xFOVcenter
;	Y_CEN=yFOVcenter
;end

;if not keyword_set(xstart) then xstart=0
;if not keyword_set(xend) then xend=naxis[0]-1
;if not keyword_set(ystart) then ystart=0
;if not keyword_set(yend) then yend=naxis[1]-1

outimage=fltarr(xend-xstart+1,yend-ystart+1,/nozero)

;if not keyword_set(XBIN) then XBIN=1
;if not keyword_set(YBIN) then YBIN=1

xdim=(naxis[0]+xstart-1)*XBIN
ydim=(naxis[1]+ystart-1)*YBIN
xmin=xstart*XBIN
ymin=ystart*YBIN

;xdim=naxis[0]*XBIN
;ydim=naxis[1]*YBIN
;xmin=0
;ymin=0

newtransx=FLTARR(xend-xstart+1)
newtransy=FLTARR(xend-xstart+1)

Y_NEW=0
dim=max([xend-xstart+1,yend-ystart+1])
xarray=(findgen(dim)+xstart+0.5)*XBIN
yarray=fltarr(dim,/nozero)

n=yend-ystart+1
yarray[*]=(y_new+ystart+0.5)*YBIN

grismrottransform,xarray,yarray,a0,a1,TransX4,TransY4,xdim,ydim,xmin,ymin

newtransx=TransX4/XBIN
newtransy=TransY4/YBIN

oldtransx=newtransx
oldtransy=newtransy

progress = OBJ_NEW ('widget_progress', CANCEL_LABEL = 'Interrupt',title='Grism Rotation Progress')

for i=0,yend-ystart do begin

fraction = float(i) / float(yend-ystart+1)
progress->update, fraction
IF (progress->cancel ()) THEN GOTO, done

;Y_NEW_05=i+0.5
grismrottransform,(xstart-0.5)*XBIN  ,(i+ystart-0.5)*YBIN  ,a0,a1,jj11,ii11,xdim,ydim,xmin,ymin
grismrottransform,(xstart-0.5)*XBIN  ,(i+ystart+0.5)*YBIN  ,a0,a1,jj33,ii33,xdim,ydim,xmin,ymin

;jj11=jj11/XBIN & ii11=ii11/YBIN
jj22=jj11/XBIN & ii22=ii11/YBIN
;jj33=jj33/XBIN & ii33=ii33/YBIN
jj44=jj33/XBIN & ii44=ii33/YBIN

;jj111=round(jj11) & ii111=round(ii11)
jj222=round(jj22) & ii222=round(ii22)
;jj333=round(jj33) & ii333=round(ii33)
jj444=round(jj44) & ii444=round(ii44)

;jj1=FLOOR(jj111) & ii1=FLOOR(ii111)
jj2=FLOOR(jj222) & ii2=FLOOR(ii222)
;jj3=FLOOR(jj333) & ii3=FLOOR(ii333)
jj4=FLOOR(jj444) & ii4=FLOOR(ii444)

NewTransX=OldTransX & NewTransY=OldTransY

dim=max([xend-xstart+1,yend-ystart+1])
xarray=(findgen(dim)+xstart+0.5)*XBIN
yarray=fltarr(dim,/nozero)
yarray[*]=(i+0.5+ystart)*YBIN

grismrottransform,xarray,yarray,a0,a1,TransX4,TransY4,xdim,ydim,xmin,ymin

TransX4=TransX4/XBIN & TransY4=TransY4/YBIN

OldTransX=TransX4 & OldTransY=TransY4

R_TransX4=round(TransX4) & R_TransY4=round(TransY4)
F_TransX4=FLOOR(TransX4) & F_TransY4=FLOOR(TransY4)

R_NewTransX=round(NewTransX) & R_NewTransY=round(NewTransY)
F_NewTransX=FLOOR(NewTransX) & F_NewTransY=FLOOR(NewTransY)

jj22_jj222=NewTransX-R_NewTransX
ii22_ii222=NewTransY-R_NewTransY
jj44_jj444=TransX4-R_TransX4
ii44_ii444=TransY4-R_TransY4

jj11_jj111=shift(jj22_jj222,1)
ii11_ii111=shift(ii22_ii222,1)
jj33_jj333=shift(jj44_jj444,1)
ii33_ii333=shift(ii44_ii444,1)

fac1a= (0.5-(jj11_jj111))* (0.5- (ii11_ii111))
fac2a= (0.5+(jj22_jj222))* (0.5- (ii22_ii222))
fac3a= (0.5-(jj33_jj333))* (0.5+ (ii33_ii333))
fac4a= (0.5+(jj44_jj444))* (0.5+ (ii44_ii444))

;jj2a=F_NewTransX & ii2a=F_NewTransY
;jj4a=F_TransX4 & ii4a=F_TransY4
jj2a=R_NewTransX & ii2a=R_NewTransY
jj4a=R_TransX4 & ii4a=R_TransY4
jj1a=shift(jj2a,1) & ii1a=shift(ii2a,1)
jj3a=shift(jj4a,1) & ii3a=shift(ii4a,1)

outimage[*,i]=    (image[jj1a,ii1a]*fac1a)[0:xend-xstart] $
	+(image[jj2a,ii2a]*fac2a)[0:xend-xstart] $
      	+(image[jj3a,ii3a]*fac3a)[0:xend-xstart] $
	+(image[jj4a,ii4a]*fac4a)[0:xend-xstart] 

outimagearea=    fac1a+fac2a+fac3a+fac4a

	for j=0,xend-xstart do begin
; 		jj11=jj22 & ii11=ii22
;		jj33=jj44 & ii33=ii44

            jj1=jj2 & jj3=jj4
		ii1=ii2 & ii3=ii4   

;  	      jj111=jj222 & jj333=jj444
;	     	ii111=ii222 & ii333=ii444

;		jj44=TransX4[j] & ii44=TransY4[j]
;		jj22=NewTransX[j] & ii22=NewTransY[j]

;		jj222=R_NewTransX[j] & ii222=R_NewTransY[j]
;		jj444=R_TransX4[j] & ii444=R_TransY4[j]

;		jj2=F_NewTransX[j] & ii2=F_NewTransY[j]
;		jj4=F_TransX4[j] & ii4=F_TransY4[j]
		jj2=R_NewTransX[j] & ii2=R_NewTransY[j]
		jj4=R_TransX4[j] & ii4=R_TransY4[j]

;		fac1= (0.5-(jj11-jj111))* (0.5- (ii11-ii111))
;		fac2= (0.5+(jj22-jj222))* (0.5- (ii22-ii222))
;		fac3= (0.5-(jj33-jj333))* (0.5+ (ii33-ii333))
;		fac4= (0.5+(jj44-jj444))* (0.5+ (ii44-ii444))

;		outimageadd=    image[jj1,ii1] * fac1 $
;		      	   +image[jj2,ii2] * fac2 $
;      		     	   +image[jj3,ii3] * fac3 $
;	             	   +image[jj4,ii4] * fac4

;		outimagearea=    fac1+fac2+fac3+fac4

	IF (NOT ( (jj2 EQ (jj1+1)) AND (ii2 EQ ii1) AND (jj3 EQ jj1) AND (ii3 EQ (ii1+1)) AND (jj4 EQ (jj1 +1)) AND (ii4 EQ (ii1 +1)) )) then begin

	flag=0
	flagx=0

		IF ((jj2 - jj1) GT 1) then begin
			IF (ii2 EQ ii1) then begin
				outimage[j,i]=outimage[j,i]+image[jj2-1,ii1] * (0.5- (ii11_ii111[j]))
				outimagearea[j]=outimagearea[j]+(0.5- (ii11_ii111[j]))
				goto,jump1
			endif

			IF (ii2 EQ (ii1 -1)) then begin
				outimage[j,i]=outimage[j,i]+image[jj2-1,ii1]
				outimagearea[j]=outimagearea[j]+1.0
				goto,jump1
			endif

			IF (ii2 EQ (ii1 +1)) then begin
				outimage[j,i]=outimage[j,i]+image[jj2-1,ii1+1]
				outimagearea[j]=outimagearea[j]+1.0
				flagx=1
			endif
		endif
jump1:

		IF ((ii3 - ii1) GT 1) then begin
			IF (jj3 EQ jj1) then begin
				outimage[j,i]=outimage[j,i]+image[jj1,ii3-1] * (0.5-(jj11_jj111[j]))
				outimagearea[j]=outimagearea[j]+(0.5-(jj11_jj111[j]))
				goto,jump2
			endif
			IF (jj3 EQ (jj1 -1)) then begin
				outimage[j,i]=outimage[j,i]+image[jj1,ii3-1]
				outimagearea[j]=outimagearea[j]+1.0
				goto,jump2
			endif
			IF (jj3 EQ (jj1+1)) AND (flagx EQ 0) then begin
				outimage[j,i]=outimage[j,i]+image[jj1+1,ii3-1]
				outimagearea[j]=outimagearea[j]+1.0
				flag=1
			endif
		ENDIF
jump2:

		IF ((jj4 - jj3) GT 1) then begin
			IF (ii3 EQ ii4) then begin
				outimage[j,i]=outimage[j,i]+image[jj4-1,ii3] * (0.5+ (ii33_ii333[j]))
				outimagearea[j]=outimagearea[j]+(0.5+ (ii33_ii333[j]))
				goto,jump3
			endif
			IF (ii3 EQ (ii4-1)) then begin
				outimage[j,i]=outimage[j,i]+image[jj4-1,ii3]
				outimagearea[j]=outimagearea[j]+1.0
				goto,jump3
			endif
			IF (ii3 EQ (ii4+1)) AND (jj1 EQ jj3) then begin
				outimage[j,i]=outimage[j,i]+image[jj4-1,ii3-1]
				outimagearea[j]=outimagearea[j]+1.0 
			endif
		ENDIF
jump3:

		IF ((ii4 - ii2) GT 1) then begin
			IF (jj4 EQ jj2) then begin
				outimage[j,i]=outimage[j,i]+image[jj2,ii2+1] * (0.5+ (jj22_jj222[j]))
				outimagearea[j]=outimagearea[j] + (0.5+ (jj22_jj222[j]))
				goto,jump4
			endif
			IF (jj4 EQ (jj2-1)) AND (ii2 EQ ii1) then begin
				outimage[j,i]=outimage[j,i]+image[jj2-1,ii2+1]
				outimagearea[j]=outimagearea[j]+1.0
				goto,jump4
			endif
			IF (jj4 EQ (jj2+1)) AND (ii2 EQ ii1) AND (ii3 EQ ii4) then begin
				outimage[j,i]=outimage[j,i]+image[jj2,ii2+1]
				outimagearea[j]=outimagearea[j]+1.0
			endif
		ENDIF
jump4:
		IF ((jj4 - jj1) GT 1) AND ((ii4 - ii1) GT 1) AND ((jj2 - jj3) GT 1) AND ((ii3 - ii2) GT 1) then begin
			outimage[j,i]=outimage[j,i]+image[jj4-1,ii4-1]
			outimagearea[j]=outimagearea[j]+1.0
		endif

ENDIF

;           outimageadd=outimageadd/(1.+ (fluxconserveflag EQ 0) * (outimagearea-1.))
;		outimage[j,i]=outimageadd
;		outimage[j,i]=outimageadd/(1.+ (fluxconserveflag EQ 0) * (outimagearea-1.))
;
; Debug only
;

;		if outimage[j,i] GT 10000 then print,jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4,outimage[j,i],flagx,flag
;		if outimage[j,i] LT 300 then print,jj1,jcj2,jj3,jj4,ii1,ii2,ii3,ii4,outimage[j,i],flagx,flag

;		if outimagearea GT 1.2 then begin
;			if (min([jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4]) GT 1) AND (max([jj1,jj2,jj3,jj4]) LT xend) then print,jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4,outimagearea,flagx,flag
;		endif
;		if outimagearea LT 1.00 then begin
;			if min(([jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4]) GT 1)  AND (max([jj1,jj2,jj3,jj4]) LT xend) then print,jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4,outimagearea,flagx,flag
;		endif


;	ENDIF
;skip1:

;	j_loop_end:
	endfor
;	print,i
outimage[*,i]=outimage[*,i]/(1.+ (fluxconserveflag EQ 0) * (outimagearea-1.))
endfor


if convolveflag EQ 1 then begin
psf=psf_gaussian(npixel=3,FWHM=[2,2],/normal)
convoutimage=convolve(outimage,psf)
endif else begin
convoutimage=outimage
endelse

;message,'Finish'
FINISH:
done:
     OBJ_DESTROY, progress
END
