pro grismrot,image,refimage,outimage,bin,chip,xstart,xend,ystart,yend,xstart_ref,xend_ref,X_CEN,Y_CEN,maxx,maxy,AFTERCCDFORMATCHANGE=afterccdformatchange

common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
mag=0.015/beta

naxis=intarr(2)
s=size(image)
naxis[0]=s[1]
naxis[1]=s[2]

naxis_ref=intarr(2)
sr=size(refimage)
naxis_ref[0]=sr[1]
naxis_ref[1]=sr[2]

trace_slit_gap,refimage,naxis_ref,x1,y1

;gap=206*3/bin[0]
;disttransform_spec,(y1+gap-20)*BIN[0],X_CEN,x1*BIN[1],Y_CEN,0.,0.,y1_trans,x1_trans,mag,maxx*bin[0],maxy*bin[1],0,0,coef_inv
;x1=x1_trans/bin[1]
;y1=y1_trans/bin[0]

midpt=median(y1)
window,/free,title='Grism Rotation Trace (Obs vs. Fit)'
winid_gaptrace=!D.WINDOW
plot,x1,y1,yrange=[midpt-0.5*bin[0],midpt+0.5*bin[0]],psym=2

result=robust_poly_fit(x1,y1,1,fit)
oplot,x1,fit

a0=0.
a1=result[1]*float(bin[0])/float(bin[1])
print,'Rotation angle (before)',a1

distcalib_engine_spec,image,outimage,chip,a0,a1,xstart,xend,ystart,yend,bin[0],bin[1],AFTERCCDFORMATCHANGE=afterccdformatchange
return
distcalib_engine_spec,image,refoutimage,chip,a0,a1,xstart_ref,xend_ref,ystart,yend,bin[0],bin[1],AFTERCCDFORMATCHANGE=afterccdformatchange

trace_slit_gap,refoutimage,[xend_ref-xstart_ref+1,yend-ystart+1],x1,y1

midpt=median(y1)

plot,x1,y1,yrange=[midpt-0.5*bin[0],midpt+0.5*bin[0]]
result=robust_poly_fit(x1,y1,1,fit)
oplot,x1,fit

a0=0.
a1=result[1]*float(bin[0])/float(bin[1])
print,'Rotation angle (after)',a1

END
