pro gridrot,FITSDIR=fitsdir

	samplefac=4
	width=40

;IF (N_ELEMENTS(fitsdir) EQ 0) THEN $
;   fitsdir = '~'
fitsdir=getenv("FOCASRED_FITS_IN")+'/'
if fitsdir EQ '/' then fitsdir=getenv('PWD')


;;;
;;; main program
;;;

	filename=DIALOG_PICKFILE(PATH=fitsdir,filter='*.fits')
	IF(STRLEN(filename) EQ 0) THEN goto,do_nothing
;	nfiles=size(nfilename,/N_ELEMENTS)
;	filename=nfilename[0]
;
; read main image array
;
	image= MRDFITS(filename, 0, header,/fscale,/silent)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=filename
;TV,BYTSCL(sigrange(image2,fraction=0.995))
autorangeset,image,range
WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=filename
imdisp,bytscl(image2,max=range[1],min=range[0]),margin=0
retry:
wset,0

nposition=dialog_input(prompt="How many pairs?")
angle=FLTARR(nposition)

;
; Set origin
;
dx=fltarr(nposition)
dy=fltarr(nposition)

CURSOR,xpos,ypos,/device
xpos=xpos*samplefac & ypos=ypos*samplefac

image3=image[xpos-width:xpos+width,ypos-width:ypos+width]
result=gauss2dfit(image3,a)
x1=a[4]-width+xpos
y1=a[5]-width+ypos
print,'Center position is found at ',x1,y1

WINDOW,1,xsize=500,ysize=500,TITLE=filename
wset,1 & erase & show3,image3

print,'This is the origin.'

FOR i=1,nposition-1 do begin
	WSET,0
	CURSOR,xpos,ypos,/device
	xpos=xpos*samplefac & ypos=ypos*samplefac

	image3=image[xpos-width:xpos+width,ypos-width:ypos+width]
	result=gauss2dfit(image3,a)
	x2=a[4]-width+xpos
	y2=a[5]-width+ypos
	print,'Center position is found at ',x2,y2

	wset,1 & erase & show3,image3

	dx[i]=x2-x1 & dy[i]=y2-y1
	angle[i]=atan(dy[i]/dx[i])*180/3.141592
;	print,angle[i]

ENDFOR

meanangle=mean(angle[1:nposition-1])
print,meanangle
result=dialog_message(["Move MOS angle "+string(meanangle)+" deg., relatively.","Set PA offset angle "+string(meanangle)+" deg., relatively"],/information)
if (meanangle) then print,'Move MOS angle +' else  print,'Move MOS angle -'
plot,dx[1:*],angle[1:*],/ynozero
;message,'Finish'

flag=dialog_message('Retry?',/question)
;flag = DIALOG_MENU (['Yes','No'], TITLE = 'Are you satisfied with this range of plot?')
	CASE flag OF
		'Yes': begin
			goto,retry
		end
		'No': begin
			goto,do_nothing
		end
	endcase

do_nothing:
END
