PRO get_star_pos_multi,image,num,xpos,ypos,RANGE=range,SEEING=seeing,WINID=winid,MYTITLE=mytitle

if N_elements(seeing) EQ 0 then fwhm=dialog_input(prompt="Seeing size",initial=1.0) else fwhm=seeing

width=fwhm/0.1*4

s=size(image)
maxx=s(1) & maxy=s(2)
samplefac=get_samplefac(maxy)

xoffset=50 & xend=maxx-50 & yoffset=50 & yend=maxy-50

expand,image,FIX(maxx/samplefac),FIX(maxy/samplefac),image2

;if N_elements(range EQ 0) then begin
;	result=sigrange(image2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],fraction=0.99,range=range)
;	range=range
;ENDIF

WINDOW,winid,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=mytitle
retry:
TV,BYTSCL(image2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=range[0],max=range[1])

flag=dialog_message('Are you satisfied with this range of plot?',/question)
;flag = DIALOG_MENU (['Yes','No'], TITLE = 'Are you satisfied with this range of plot?')
	CASE flag OF
		'No': begin
				range=dialog_input(prompt=["MIN","MAX"],nfields=2,initial=range)
				goto,retry
			end
		'Yes': goto,ok
	ENDCASE
ok:

WINDOW,2,xsize=FIX((maxx-xoffset)/samplefac/2),ysize=FIX((maxy-yoffset)/samplefac/2)*2,TITLE=name


!P.MULTI=[0,1,2]

for i=0,num-1 do begin
	wset,winid
	CURSOR,tmp_x,tmp_y,/device
	xpos[i]=tmp_x*samplefac+xoffset & ypos[i]=tmp_y*samplefac+yoffset
	image3=image[xpos[i]-width:xpos[i]+width,ypos[i]-width:ypos[i]+width]

	image32=filter_image(image3)

	result=gauss2dfit(image32,a)

	!P.MULTI=[0,1,2]
	WSET, 2 & ERASE
	show3,image32
	show3,result

	xpos[i]=a[4]-width+xpos[i]
	ypos[i]=a[5]-width+ypos[i]

	print,'xpos, ypos=',xpos[i],ypos[i]

	wset,winid
	draw_ellipse,(xpos[i]-xoffset)/samplefac,(ypos[i]-yoffset)/samplefac,100/samplefac,100/samplefac,/device
	xyouts,(xpos[i]-xoffset)/samplefac,(ypos[i]-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5


	result=dialog_checklist('Transposed?',/nonexclusive)

;aper,image,a[4]-width+xpos[i],a[5]-width+ypos[i],flux,errap,sky,skyerr,1,[8],[10,15],[-500,30000],/flux
endfor

END
