PRO get_star_pos_multi,image,num,xpos,ypos,RANGE=range,SEEING=seeing,WINID=winid,MYTITLE=mytitle

if N_elements(seeing) EQ 0 then fwhm=dialog_input(prompt="Seeing size",initial=1.0,title='') else fwhm=seeing

width=fwhm/0.1*4; Gaussian fitting Window Size
width2=7; 1 arcsec (= 10 pix) radius aperture * 0.7; only for sky-level calcularion by median

s=size(image)
maxx=s(1) & maxy=s(2)
samplefac=get_samplefac_x(maxx)

;xoffset=50 & xend=maxx-50 & yoffset=50 & yend=maxy-50
xoffset=10 & xend=maxx-10 & yoffset=10 & yend=maxy-10

expand,image,FIX(maxx/samplefac),FIX(maxy/samplefac),image2

;if N_elements(range EQ 0) then begin
;	result=sigrange(image2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],fraction=0.99,range=range)
;	range=range
;ENDIF

WINDOW,/free,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=mytitle
winid_wholeimage=!D.WINDOW
retry:
TV,BYTSCL(image2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=range[0],max=range[1])

;flag=dialog_message('Are you satisfied with this range of plot?',/question,/default_no)
flag = DIALOG_MENU (['Yes','No'], TITLE = 'Do you want to change the intensity range?')
	CASE flag OF
		'Yes': begin
				range=dialog_input(prompt=["MIN Count Level","MAX Count Level"],nfields=2,initial=range,title="Changing Display Count Level")
				goto,retry
			end
		'No': goto,ok
	ENDCASE
ok:

;WINDOW,/free,xsize=FIX((maxx-xoffset)/samplefac/2),ysize=FIX((maxy-yoffset)/samplefac/2)*2,TITLE=name
WINDOW,/free,xsize=200,ysize=200*2,TITLE=name
winid_clickimage=!D.WINDOW


!P.MULTI=[0,1,2]

for i=0,num-1 do begin

retry2:

	wset,winid_wholeimage
	CURSOR,tmp_x,tmp_y,/device
	xpos[i]=tmp_x*samplefac+xoffset & ypos[i]=tmp_y*samplefac+yoffset
	image3=image[xpos[i]-width:xpos[i]+width,ypos[i]-width:ypos[i]+width]

	image32=filter_image(image3)

	result=gauss2dfit(image32,a)

	!P.MULTI=[0,1,2]
	WSET, winid_clickimage & ERASE
	show3,image32
	show3,result

	xpos[i]=a[4]-width+xpos[i]
	ypos[i]=a[5]-width+ypos[i]

	print,'xpos, ypos=',xpos[i],ypos[i]

	wset,winid_wholeimage
	draw_ellipse,(xpos[i]-xoffset)/samplefac,(ypos[i]-yoffset)/samplefac,40/samplefac,40/samplefac,/device
	xyouts,(xpos[i]-xoffset)/samplefac,(ypos[i]-yoffset)/samplefac,strtrim(string(i),2),/device,charsize=1.5

;	result=dialog_message('Do you want to retry?',/question)
	result = DIALOG_MENU (['Yes','No'], TITLE = 'Do you want to retry?')
	if result EQ 'Yes' then begin
	width=dialog_input(prompt="Fit Box Size",initial=width)
	goto,retry2
	endif


	image33=image[xpos[i]-width2:xpos[i]+width2,ypos[i]-width2:ypos[i]+width2]
	print,'Sky value = median value = ',median(image33)

;aper,image,a[4]-width+xpos[i],a[5]-width+ypos[i],flux,errap,sky,skyerr,1,[8],[10,15],[-500,30000],/flux
endfor


wdelete,winid_clickimage

END
