PRO get_star_pos,image,xpos,ypos,flux,sky,RANGE=range

width=40

s=size(image)

maxx=s(1)
maxy=s(2)

samplefac=get_samplefac(maxy)

xoffset=50
xend=maxx-50
yoffset=50
yend=maxy-50

expand,image,FIX(maxx/samplefac),FIX(maxy/samplefac),image2

if N_elements(range EQ 0) then begin
	result=sigrange(image2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],fraction=0.99,range=range)
	range=range
ENDIF


WINDOW,0,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
;TV,BYTSCL(sigrange(image2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],fraction=0.99))
TV,BYTSCL(image2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],min=range[0],max=range[1])
WINDOW,2,xsize=FIX((maxx-xoffset)/samplefac),ysize=FIX((maxy-yoffset)/samplefac),TITLE=name
wset,0

click_retry:
CURSOR,xpos,ypos,/device
xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset

print,xpos,ypos

if (xpos-width LT 0) or (xpos+width GT xend) or (ypos-width LT 0) or (ypos+width GT yend) then begin
	print,'Your Clicked Position was out of range. Try again'
	goto, click_retry
end


image3=image[xpos-width:xpos+width,ypos-width:ypos+width]
result=gauss2dfit(image3,a)


WSET,2 & ERASE
show3,image3

aper,image,a[4]-width+xpos,a[5]-width+ypos,flux,errap,sky,skyerr,1,[8],[10,15],[-500,30000],/flux
END
