PRO fspecred_engine,image,header,flatimage,compimage,chip,startx,endx,starty,endy, image_slt, compimage_rot, $
	GRISMROTFLAG=grismrotflag,AFTERCCDFORMATCHANGE=afterccdformatchange

;IF not keyword_set(grismrotflag) then grismrotflag=0
;IF not keyword_set(afterccdformatchange) THEN afterccdformatchange = 1

;result=dialog_checklist(['Grism Rotation'],/nonexclusive,title='Select Image-processing Action(s)')
;if result[0] EQ 1 then GRISMROTFLAG = 1 else GRISMROTFLAG = 0

common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
mag=0.015/beta

;LOGGER = OBJ_NEW ('widget_LOGGER', MAP = 0, TITLE = 'FSPECRED LOG')
;LOGGER->setClearButton, 'Clear Log Text'
;LOGGER->show

name = SXPAR( header ,'OBJECT')
naxis= SXPAR( header,'NAXIS*')
bin= SXPAR( header,'BIN-FCT*')
;det_id= SXPAR( header,'DET-ID')
;chip=0 means chip=1; chip=1 means chip2; chip=2 means bigiamge
;if det_id EQ 1 then chip=0 else chip=1
;chip=2

samplefac=get_samplefac(naxis[1])

xFOVcenter=xDISTcenter
yFOVcenter=yDISTcenter

if chip EQ 0 then begin; chip=0 means chip1
;	X_CEN=xFOVcenter-2047-gapsize-75*2;-96
	if afterccdformatchange then X_CEN=xFOVcenter-2047-gapsize else X_CEN=xFOVcenter-2047-gapsize-overscan*2; was 75*2
	Y_CEN=yFOVcenter;2003
endif else if chip EQ 1 then begin
	X_CEN=xFOVcenter;2022
	Y_CEN=yFOVcenter-y_shift;2006
endif else begin
	X_CEN=xFOVcenter;2022
	Y_CEN=yFOVcenter-y_shift;2006
endelse

print, chip, x_cen, y_cen

s=size(image)
maxx=s(1) & maxy=s(2)
;
; NEW
;

disttransform_spec,startx*BIN[0],X_CEN,starty*BIN[1],Y_CEN,0,0,startx_trans,starty_trans,mag,maxx*bin[0],maxy*bin[1],0,0,coef
disttransform_spec,endx*BIN[0],X_CEN,endy*BIN[1],Y_CEN,0,0,endx_trans,endy_trans,mag,maxx*bin[0],maxy*bin[1],0,0,coef
;disttransform_inv,startx*BIN[0],X_CEN,starty*BIN[1],Y_CEN,startx_trans,starty_trans,mag,maxx*bin[0],maxy*bin[1],coef
;disttransform_inv,endx*BIN[0],X_CEN,endy*BIN[1],Y_CEN,endx_trans,endy_trans,mag,maxx*bin[0],maxy*bin[1],coef

startx_tr=startx_trans/bin[0] & starty_tr=starty_trans/bin[1]
endx_tr=endx_trans/bin[0] & endy_tr=endy_trans/bin[1]

;startx_tr=startx
;endx_tr=endx
;starty_tr=starty
;endy_tr=endy

;disttransform,startx*BIN[0],X_CEN,starty*BIN[1],Y_CEN,startx_trans,starty_trans,mag,maxx*bin[0],maxy*bin[1],0, 0, coef_inv
;disttransform,endx*BIN[0],X_CEN,endy*BIN[1],Y_CEN,endx_trans,endy_trans,mag,maxx*bin[0],maxy*bin[1],0, 0, coef_inv

;startx=startx_trans/bin[0] & starty=starty_trans/bin[1]
;endx=endx_trans/bin[0] & endy=endy_trans/bin[1]

image_tr=trimarray(image,startx,endx,starty,endy)
flatimage_tr=trimarray(flatimage,startx,endx,starty,endy)
compimage_tr=trimarray(compimage,startx,endx,starty,endy)

if afterccdformatchange then gap=413*3/bin[0] else gap=206*3/bin[0]; was 255
startx_gap=gap-50
endx_gap=gap+50

image_gap_tr=trimarray(image,startx_gap,endx_gap,starty,endy)
flatimage_gap_tr=trimarray(flatimage,startx_gap,endx_gap,starty,endy)
compimage_gap_tr=trimarray(compimage,startx_gap,endx_gap,starty,endy)

window_ysize=FIX((get_screen_size())[1]*0.9)
window_xsize=FIX(float(window_ysize)/(endy-starty+1)*(endx-startx+1)*3.)
;print,window_xsize,window_ysize

;window,/free,xsize=(endx-startx+1)*3,ysize=(endy-starty+1),title='Obj., Flat., Comp.'
window,/free,xsize=window_xsize,ysize=window_ysize,title='Obj., Flat., Comp.'

winid_threeimages=!D.WINDOW
!P.MULTI=[0,3,1]
imdisp,sigrange(image_tr),margin=0
imdisp,sigrange(flatimage_tr),margin=0
imdisp,sigrange(compimage_tr),margin=0
;imdisp,sigrange(image_gap_tr),margin=0
;imdisp,sigrange(flatimage_gap_tr),margin=0
;imdisp,sigrange(compimage_gap_tr),margin=0
!P.MULTI=0
;
; Make flatfield images
;
;LOGGER->append, ['Flat fielding']
specflat_engine,flatimage_tr,flatimage,flatimage_gap_tr,flatimage,chip,ptpimage,flatpattern,image_ptp,FIX(startx),FIX(endx),FIX(starty),FIX(endy),FIX(startx_tr),FIX(endx_tr),FIX(starty_tr),FIX(endy_tr),bin[0],bin[1],X_CEN,Y_CEN,maxx,maxy,$
	GRISMROTFLAG=grismrotflag,AFTERCCDFORMATCHANGE=afterccdformatchange
;
; PTP flatfield
;
;image_ptp=(image > 1)/ptpimage
image_ptp=image/ptpimage
compimage_ptp=compimage/ptpimage
;
; CR removeal
;
;LOGGER->append, ['Cosmic Ray Removal','	3 iterative procedure. Please wait.']
image_cr=image_ptp
image_ptp_min=image_ptp[startx:endx,starty:endy]
;image_ptp_min_cr=point_remover(image_ptp_min,5,7,3);was 5,10,3; was 5,7,5
image_ptp_min_cr=image_ptp_min
skysub,image_ptp_min_cr,image_cr_skysub
image_cr_min_skysub=point_remover(image_cr_skysub,5,5,3);was 5,10,3; was 5,7,5
crimage=image_cr_skysub-image_cr_min_skysub
image_cr_min=image_ptp_min-crimage
for j=0,endx-startx do image_cr[j+startx,starty:endy]=image_cr_min[j,*]
;image_cr=image_ptp

suboverscanflag=0 & fluxconserveflag=0 & convolveflag=0
if GRISMROTFLAG then begin
	;
	; Grism rotation
	;
;	LOGGER->append, ['Grism rotation']
	distcalib_engine_spec,compimage,compimage_gap_dc,chip,0.,0.,FIX(startx_gap),FIX(endx_gap),FIX(starty_tr),FIX(endy_tr),bin[0],bin[1], $; was FIX(starty_tr),FIX(endy_tr)
		SUBOVERSCANFLAG=suboverscanflag,FLUXCONSERVEFLAG=fluxconservflag,CONVOLVEFLAG=convolveflag,AFTERCCDFORMATCHANGE=afterccdformatchange
;	LOGGER->append, ['	Object']
;	grismrot,    image,compimage_gap_dc,    image_rot,bin,chip,FIX(startx_tr),FIX(endx_tr),FIX(starty_tr),FIX(endy_tr),FIX(startx_gap),FIX(endx_gap),X_CEN,Y_CEN,maxx,maxy
	grismrot,    image_cr,compimage_gap_dc,    image_rot,bin,chip,FIX(startx_tr),FIX(endx_tr),FIX(starty_tr),FIX(endy_tr),FIX(startx_gap),FIX(endx_gap),X_CEN,Y_CEN,maxx,maxy,$; was FIX(startx_tr),FIX(endx_tr),FIX(starty_tr),FIX(endy_tr)
		AFTERCCDFORMATCHANGE=afterccdformatchange
;	LOGGER->append, ['	Comparison']
	grismrot,compimage_ptp,compimage_gap_dc,compimage_rot,bin,chip,FIX(startx_tr),FIX(endx_tr),FIX(starty_tr),FIX(endy_tr),FIX(startx_gap),FIX(endx_gap),X_CEN,Y_CEN,maxx,maxy,$; was FIX(startx_tr),FIX(endx_tr),FIX(starty_tr),FIX(endy_tr),
		AFTERCCDFORMATCHANGE=afterccdformatchange
END ELSE BEGIN
	;
	; Distortion correction
	;
;	LOGGER->append, ['Object Distortion Correction']
	distcalib_engine_spec,  image_cr,    image_rot    ,chip,0.,0.,FIX(startx_tr),FIX(endx_tr),FIX(starty_tr),FIX(endy_tr),bin[0],bin[1],$; was FIX(startx_tr),FIX(endx_tr),FIX(starty_tr),FIX(endy_tr)
		SUBOVERSCANFLAG=suboverscanflag,FLUXCONSERVEFLAG=fluxconservflag,CONVOLVEFLAG=convolveflag,AFTERCCDFORMATCHANGE=afterccdformatchange
;	distcalib_engine_spec, image_gap_tr,image_gap_dc,chip,0.,0.,FIX(startx_gap),FIX(endx_gap),FIX(starty_tr),FIX(endy_tr),bin[0],bin[1],$
;		SUBOVERSCANFLAG=suboverscanflag,FLUXCONSERVEFLAG=fluxconservflag,CONVOLVEFLAG=convolveflag
;	LOGGER->append, ['Comparison Distortion Correction']
	distcalib_engine_spec,compimage_ptp,compimage_rot   ,chip,0.,0.,FIX(startx_tr),FIX(endx_tr),FIX(starty_tr),FIX(endy_tr),bin[0],bin[1],$; was FIX(startx_tr),FIX(endx_tr),FIX(starty_tr),FIX(endy_tr)
		SUBOVERSCANFLAG=suboverscanflag,FLUXCONSERVEFLAG=fluxconservflag,CONVOLVEFLAG=convolveflag,AFTERCCDFORMATCHANGE=afterccdformatchange
ENDELSE
;
; Slit pattern measurement
;
;LOGGER->append, ['Slit pattern shift calculation']
get_slitpattern,compimage_rot[*,FIX((endy-starty+1.)/5.):FIX((endy-starty+1.)*4./5.)],comppattern,medianmod=1

;plot,comppattern,yrange=[0.95,1.05]
;oplot,flatpattern

calc_optimum_slit,flatpattern,comppattern,slitpattern

window,/free,xsize=800,ysize=800,title='Slit Pattern Comparison'
!P.MULTI=[0,1,2]
plot,comppattern,/ynozero,title='Slitpattern in Comparison',yrange=[0.9,1.1]
plot,slitpattern,/ynozero,title='Slitpattern in Flats after relative shift and scaling',yrange=[0.9,1.1]
;plot,slitpattern/comppattern,/ynozero,title='Ratio',yrange=[0.9,1.1]
!P.MULTI=0
;
; Slit pattern correction
;
;LOGGER->append, ['Slit pattern correction']
image_slt=image_rot
for i=0,n_elements(image_rot[1,*])-1 do image_slt[*,i]=image_rot[*,i]/slitpattern

RETURN

message,'Use IRAF for identify -> transform'
;
; Sky sub
;
read_fits,image_slt,header,dir=workdir

skysub,image_slt,image_ss

window,0,ysize=1000,xsize=(endx-startx+1)
imdisp,sigrange(image_ss)

write_fits,image_ss,header,dir=localdir

;OBJ_DESTROY, LOGGER

message,'Finish'
;FINISH:

END
