PRO fspecred,flatimagefile,compimagefile,imagefile,outimagefile,compoutimagefile,startx,endx,starty,endy
;
; Usage: fspecred <CR>
;		-> Interactive FITS file name input
;        fspecred,'FLAT.fits','COMP.fits','OBJECT.fits','OBJECT_iFF_OUT.fits','COMP_FF_OUT.fits' <CR>
;		-> Non-interactive FITS file name input, e.g., for DASH
;			'' (semi-colon) required to specify the filename)

common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

device,pseudo_color=8

dash_mode=keyword_set(flatimagefile)

if dash_mode then begin
	biassubflag=0
	overscanflag=0
	grismrotflag=0
	afterccdformatchange=1
	usemouse=0
end else begin
	result=dialog_checklist(['Bias Subtraction','Overscan Subtraction','Grism Rotation','Data Taken Before Fall 2000','Select Regions by MOUSE'],/nonexclusive,title='Select Image-processing Action(s)')
	if result[0] EQ 0 then biassubflag=0 else biassubflag=1
	if result[1] EQ 0 then overscanflag=0 else overscanflag=1
	if result[2] EQ 0 then grismrotflag=0 else grismrotflag=1
	if result[3] EQ 1 then afterccdformatchange=0 else afterccdformatchange=1
	if result[4] EQ 0 then usemouse=0 else usemouse=1
endelse

read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
mag=0.015/beta

;LOGGER = OBJ_NEW ('widget_LOGGER', MAP = 0, TITLE = 'FSPECRED LOG')
;LOGGER->setClearButton, 'Clear Log Text'
;LOGGER->show

;
; Data Read
;
if dash_mode then begin
	; In case of 'with argument' for DASH'
	flatimage=MRDFITS(flatimagefile,0,header,/silent,/fscale)
	compimage=MRDFITS(compimagefile,0,header,/silent,/fscale)
	image=MRDFITS(imagefile,0,header,/silent,/fscale)
end else begin
	; in case of 'no argument' for interactive FITS input
	fitsindir=getenv("FOCASRED_FITS_IN")+'/'
	if fitsindir EQ '/' then fitsindir=getenv('PWD')
	fitsoutdir=getenv("FOCASRED_FITS_OUT")+'/'
	if fitsoutdir EQ '/' then fitsoutdir=getenv('PWD')

;	LOGGER->append, ['FLAT.fits data read']
	read_fits,flatimage,header,dir=fitsindir,mytitle='FLAT',myfilter='*.fits',mygetpath=workdir
;	LOGGER->append, ['COMP.fits data read']
	read_fits,compimage,header,mytitle='Comparison',myfilter='*.fits',dir=workdir
;	LOGGER->append, ['OBJECT.fits data read']
	read_fits,image,header,dir=workdir,mytitle='Object',myfilter='*fits'
endelse

det_id= SXPAR( header,'DET-ID')
;chip=0 means chip=1; chip=1 means chip2; chip=2 means bigiamge
if det_id EQ 1 then chip=0 else chip=1

print,det_id,chip
name = SXPAR( header ,'OBJECT')
naxis= SXPAR( header,'NAXIS*')
bin= SXPAR( header,'BIN-FCT*')

samplefac=get_samplefac(naxis[1])

if biassubflag then begin
	LOGGER->append, ['Bias subtraction']
	biassub_menu,image,image_bs,stdbias,chip,overscan,fitsdir=workdir
	suboverscan,flatimage,flatimage_os,chip,overscan,xbin=bin[0]
	suboverscan,compimage,compimage_os,chip,overscan,xbin=bin[0]
	biassub,flatimage_os,stdbias,flatimage_bs
	biassub,compimage_os,stdbias,compimage_bs
endif else begin
	image_bs=image
	flatimage_bs=flatimage
	compimage_bs=compimage
endelse

if overscanflag then begin
;	LOGGER->append, ['Overscan subtraction']
	suboverscan,image_bs,image_os,chip,overscan,xbin=bin[0]
	suboverscan,flatimage_bs,flatimage_os,chip,overscan,xbin=bin[0]
	suboverscan,compimage_bs,compimage_os,chip,overscan,xbin=bin[0]
endif else begin
	image_os=image_bs
	flatimage_os=flatimage_bs
	compimage_os=compimage_bs
endelse
;
; Trimming
;
if not dash_mode then begin
;	LOGGER->append, ['Data trimming']
	if usemouse then begin
		autorangeset,image_os,range
		WINDOW,/free,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
		winid_regionselect=!D.WINDOW
		imdisp,bytscl(image_os,min=range[0],max=range[1]),margin=0
;		LOGGER->append, ['	Click lower-left and upper-right edges of your interest region.']
		CURSOR,line,column,/normal
		startx=line*naxis[0] & starty=column*naxis[1]
		wait,1
		CURSOR,line,column,/normal
		endx=line*naxis[0] & endy=column*naxis[1]
		wdelete,winid_regionselect
	endif else begin
		regions=dialog_input(prompt=[["Lower Left X","Lower Left Y"],["Upper Right X", "Upper Right Y"]],nfield=4,title='Input Regions')
		startx=FIX(regions[0])
		starty=FIX(regions[1])
		endx=FIX(regions[2])
		endy=FIX(regions[3])
	endelse
endif
;OBJ_DESTROY, LOGGER

print,startx,starty,endx,endy

fspecred_engine,image_os,header,flatimage_os,compimage_os,chip,startx,endx,starty,endy,image_ff,compimage_ff,$
	grismrotflag=grismrotflag,AFTERCCDFORMATCHANGE=afterccdformatchange
;
; Output data
;
s=size(image_ff)
naxis1_out=s(1)
naxis2_out=s(2)
specheader,header,header1,starty
if dash_mode then begin
	MWRFITS,image_ff[1:naxis1_out-2,*] ,outimagefile,header1
	MWRFITS,compimage_ff[1:naxis1_out-2,*] ,compoutimagefile,header1
endif else begin
	write_fits,image_ff[1:naxis1_out-2,*],header1,dir=workdir
	write_fits,compimage_ff[1:naxis1_out-2,*],header1,dir=workdir
endelse

if dash_mode then return else message,'Use IRAF for identify -> transform'

;
; --- END ---
;

;
; Sky sub
;
read_fits,image_slt,header,dir=workdir

skysub,image_slt,image_ss

window,0,ysize=1000,xsize=(endx-startx+1)
imdisp,sigrange(image_ss)

write_fits,image_ss,header1,dir=fitsoutdir

OBJ_DESTROY, LOGGER

message,'Finish'
;FINISH:

END
