pro fit_one_line,x,y,linelist2,wavelength,lposition

	window,xsize=900,ysize=400
	PLOT,X,Y,/ynozero

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center (top)'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0] & y1=XY[1]

	PRINT,'Click FWHM (left)'
	CURSOR,x1,tmp,3,/device
	XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
	x1=XY[0]
	PRINT,'Click FWHM (right)'
	CURSOR,x2,tmp,3,/device
	XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
	x2=XY[0]

	width=abs(x1-x2) > 4
	est=[1,cen,width,0]

	XXmin=XX[where ((XX GT cen-width*2) AND (XX LT cen+width*2))]
	YYmin=YY[where ((XX GT cen-width*2) AND (XX LT cen+width*2))]

	result=GAUSSFIT(XXmin,YYmin,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10 & OPLOT,XXmin,result

	wavelength=DIALOG_MENU(linelist2, TITLE = 'Select Wavelength')
	lposition=coef[1]
end
