pro filelisttmp

numfiles=100
filename=getenv("FOCASRED_FITS_IN")+'/F*.fits'
filename='/data/FITS/F*.fits'
file_list = findfile( filename, COUNT = nfiles)
if nfiles EQ 0 then message,'No files found'
;print,nfiles-numfiles > 0,nfiles-1
file_list_tail=file_list[nfiles-numfiles > 0:nfiles-1]

nfiles= nfiles < numfiles

object=strarr(nfiles)
data_typ=strarr(nfiles)
filter01=strarr(nfiles)
filter02=strarr(nfiles)
filter03=strarr(nfiles)
filter01=strarr(nfiles)
bin_fct0=strarr(nfiles)
bin_fct1=strarr(nfiles)
inst_pa=fltarr(nfiles)
altitude=fltarr(nfiles)
azimuth=fltarr(nfiles)
exptime=fltarr(nfiles)
inst_pa=fltarr(nfiles)
filename=strarr(nfiles)
ra=strarr(nfiles)
dec=strarr(nfiles)
hst_str=strarr(nfiles)
slit=strarr(nfiles)
det_id=strarr(nfiles)
UT=strarr(nfiles)
date_obs=strarr(nfiles)
mjd=strarr(nfiles)

fmt1='(A20, A4, A20, A5, A7, A13, 3A13, 3A12, A10, 2A4)'

;print,"Filename","DetID","Object","Slit","Exp","HST","RA","DEC","DataType","Filter1","Filter2","Filter3","Ins PA","BinX","BinY", $
;		format=fmt1

fmt='(14A15)'
print,"filename","date_obs","data_typ","UT","det_id","object","ra","dec",format=fmt

;fmt='(A20, A4, A20, A5, I7, A13, 3A13, 3A12, F8.2, 2I4)'


for i = 0, nfiles-1 do begin
	header=headfits(file_list_tail[i])
;	bin_fct=SXPAR( header,'BIN-FCT*')
;	bin_fct0[i]=bin_fct[0]
;	bin_fct1[i]=bin_fct[1]

	det_id[i]=strtrim(SXPAR( header,'DET-ID'),2)
	data_typ[i] = SXPAR( header ,'DATA-TYP')
	object[i]=SXPAR( header ,'OBJECT')

	filename_split=strsplit(file_list_tail[i],'/',/extract)
	filename[i]=filename_split[n_elements(filename_split)-1]

;	filter01[i]=SXPAR( header ,'FILTER01')
;	filter02[i]=SXPAR( header ,'FILTER02')
;	filter03[i]=SXPAR( header ,'FILTER03')

;	inst_pa[i]=SXPAR(header,'INST-PA')
	altitude[i]=SXPAR(header,'ALTITUDE')
	azimuth[i]=SXPAR(header,'AZIMUTH')

;	exptime[i]=SXPAR(header,'EXPTIME')

	date_obs[i]=SXPAR(header,'DATE-OBS')

	hst_str[i]=SXPAR(header,'HST-STR')
;	slit[i]=strtrim(SXPAR(header,'SLIT'))
	ra[i]=SXPAR(header,'RA')
	dec[i]=SXPAR(header,'DEC')
	UT[i]=SXPAR(header,'UT')
	MJD[i]=FXPAR(header,'MJD')


if i GT 2 then $
;if ((AZIMUTH[i] EQ AZIMUTH[i-2]) OR (ALTITUDE[i] EQ ALTITUDE[i-2])) AND (det_id[i] EQ 1) AND (data_typ[i] NE "BIAS    ") AND (data_typ[i] NE "DOMEFLAT") then print,filename[i],date_obs[i],data_typ[i],UT[i],object[i],object[i-2],ra[i],ra[i-2],dec[i],dec[i-2],altitude[i],altitude[i-2],azimuth[i],azimuth[i-2],format=fmt
;if ((RA[i] EQ RA[i-2]) OR (DEC[i] EQ DEC[i-2])) AND (det_id[i] EQ 1) then print,filename[i],date_obs[i],data_typ[i],UT[i],object[i],object[i-2],ra[i],ra[i-2],dec[i],dec[i-2],altitude[i],altitude[i-2],azimuth[i],azimuth[i-2],format=fmt
if ((RA[i] EQ RA[i-2]) OR (DEC[i] EQ DEC[i-2])) AND (det_id[i] EQ 1) then print,filename[i],date_obs[i],hst_str[i],data_typ[i],UT[i],object[i],ra[i],ra[i-2],dec[i],dec[i-2],format=fmt
;if (MJD[i] EQ MJD[i-2]) AND (det_id[i] EQ 1) then print,filename[i],date_obs[i],data_typ[i],UT[i],object[i],object[i-2],ra[i],ra[i-2],dec[i],dec[i-2],altitude[i],altitude[i-2],azimuth[i],azimuth[i-2],mjd[i],mjd[i-2]

endfor

;message,'Finish'

end
