pro filelist

numfiles=2
filename=getenv("FOCASRED_FITS_IN")+'/F*.fits'
;filename='/home/falcon/FITS/F*.fits'
file_list = findfile( filename, COUNT = nfiles)
if nfiles EQ 0 then message,'No files found'
;print,nfiles-numfiles > 0,nfiles-1
file_list_tail=file_list[nfiles-numfiles > 0:nfiles-1]

nfiles= nfiles < numfiles

object=strarr(nfiles)
data_typ=strarr(nfiles)
filter01=strarr(nfiles)
filter02=strarr(nfiles)
filter03=strarr(nfiles)
filter01=strarr(nfiles)
bin_fct0=strarr(nfiles)
bin_fct1=strarr(nfiles)
inst_pa=fltarr(nfiles)
altitude=fltarr(nfiles)
exptime=fltarr(nfiles)
inst_pa=fltarr(nfiles)
filename=strarr(nfiles)
ra=strarr(nfiles)
dec=strarr(nfiles)
hst_str=strarr(nfiles)
slit=strarr(nfiles)
det_id=strarr(nfiles)

fmt1='(A20, A4, A20, A5, A7, A13, 3A13, 3A12, A10, 2A4)'

print,"Filename","DetID","Object","Slit","Exp","HST","RA","DEC","DataType","Filter1","Filter2","Filter3","Ins PA","BinX","BinY", $
		format=fmt1
fmt='(A20, A4, A20, A5, I7, A13, 3A13, 3A12, F8.2, 2I4)'

for i = 0, nfiles-1 do begin
	header=headfits(file_list_tail[i])
	bin_fct=SXPAR( header,'BIN-FCT*')
	bin_fct0[i]=bin_fct[0]
	bin_fct1[i]=bin_fct[1]

	det_id[i]=strtrim(SXPAR( header,'DET-ID'),2)
	data_typ[i] = SXPAR( header ,'DATA-TYP')
	object[i]=SXPAR( header ,'OBJECT')

	filename_split=strsplit(file_list_tail[i],'/',/extract)
	filename[i]=filename_split[n_elements(filename_split)-1]

	filter01[i]=SXPAR( header ,'FILTER01')
	filter02[i]=SXPAR( header ,'FILTER02')
	filter03[i]=SXPAR( header ,'FILTER03')

	inst_pa[i]=SXPAR(header,'INST-PA')
	altitude[i]=SXPAR(header,'ALTITUDE')
	exptime[i]=SXPAR(header,'EXPTIME')

	hst_str[i]=SXPAR(header,'HST-STR')
	slit[i]=strtrim(SXPAR(header,'SLIT'))
	ra[i]=SXPAR(header,'RA2000')
	dec[i]=SXPAR(header,'DEC2000')

print,filename[i],det_id[i],object[i],slit[i],exptime[i],hst_str[i],ra[i],dec[i],data_typ[i],filter01[i],filter02[i],filter03[i],inst_pa[i],bin_fct0[i],bin_fct1[i], $
	format=fmt
endfor

end
