pro exposure_calc_spec_line
;
; Emission-line sensitivity per a binned pix
; Input: line flux in units of erg/s/cm^2
; S/N depends on line profile, and detectavility depends on the summation on wavelength direction 
;
grism_selection=dialog_menu(['75','150','300','300 2nd'],TITLE='Select Grism')
slit_selection=dialog_menu(['0.2','0.4','0.6','0.8','1.0'],TITLE='Select Slit')
slit_width=float(slit_selection)


result=dialog_input(prompt=['F_lambda (erg s^-1 cm^-2)','Exposure Time (sec)','Sensitivity','Lambda (A)','Required SN','X bin','Y bin','Line Width (A)'],nfields=8)
flambda=float(result[0])
exptime=float(result[1])
sensitivity=float(result[2])
lambda=float(result[3])
snreq=float(result[4])
xbin=float(result[5])
ybin=float(result[6])
linewidth=float(result[7])


binningfac=xbin*ybin

case grism_selection of
'75': begin
bandwidth=5.46
end
'150': begin
bandwidth=2.72
end
'300': begin
bandwidth=1.34
end
'300 2nd': begin
bandwidth=0.67
end
endcase

backgrrate_U=0.6
backgrrate_B=4.0
backgrrate_V=7.6
backgrrate_R=12.0
backgrrate_I=22.9

bandwidth_U=560
bandwidth_B=1080
bandwidth_V=1000
bandwidth_R=1170
bandwidth_I=1460

if lambda LE 3750 then backgrrate=backgrrate_U*bandwidth/bandwidth_U*ybin
if lambda GT 3750 and lambda LE 5000 then begin
	backgrrate=backgrrate_B*bandwidth/bandwidth_B*ybin
	print,'B'
	end
if lambda GT 5000 and lambda LE 6000 then backgrrate=backgrrate_V*bandwidth/bandwidth_V*ybin
if lambda GT 6000 and lambda LE 7250 then backgrrate=backgrrate_R*bandwidth/bandwidth_R*ybin
if lambda GT 7250 then backgrrate=backgrrate_I/bandwidth_I*bandwidth*bandwidth_I*ybin

lambda=lambda*1e-10

h=6.6260755e-34 * 1e7
c=2.99792458e8

readoutnoise=8
adcfac=2.75
n_pix=(xbin*ybin*2/0.1)^2
flambda_ang=flambda/linewidth;/(linewidth/(bandwidth*ybin))
cps=flambda_ang*sensitivity*(ybin/2)*adcfac

result=dialog_menu(['Point Source','Flux in arcsec^2','Flux on binned pixel','END'],TITLE='Type of operation')
       CASE result OF
                'Point Source': begin
			point_param=dialog_input(prompt=["Seeing (arcsec)"],nfields=1)
			seeing=float(point_param[0])
			cps=cps*(0.1^2/seeing^2)*xbin*ybin
			if slit_width/0.1/ybin LT linewidth/(bandwidth*ybin) then $
				cps=cps*slit_width/0.1/ybin else $
				cps=cps*linewidth/(bandwidth*ybin)
			obj_electron=cps*exptime
			sky_electron=backgrrate*exptime*xbin*ybin
			eff_readout=readoutnoise;*sqrt(xbin*ybin)
			end
                'END': message,'Finish'
		'Flux in arcsec^2': begin
			cps=cps*xbin*ybin/0.1^2
			if slit_width/0.1/ybin LT linewidth/(bandwidth*ybin) then $
				cps=cps*slit_width/0.1/ybin else $
				cps=cps*linewidth/(bandwidth*ybin)
			obj_electron=cps*exptime
			sky_electron=backgrrate*exptime*xbin*ybin
			eff_readout=readoutnoise;*sqrt(xbin*ybin)
			END

		'Flux on binned pixel': begin
			obj_electron=cps*exptime
			sky_electron=backgrrate*exptime*xbin*ybin
			eff_readout=readoutnoise;*sqrt(xbin*ybin)
			end
	      ENDCASE

SN=obj_electron/sqrt(eff_readout^2+sky_electron+obj_electron)

window,title='Expected Counts and SNs'
!P.MULTI=[0,1,2]

obj_electron_plot=fltarr(3600)
for i=0,3599 do obj_electron_plot[i]=cps*i
plot,findgen(3600),obj_electron_plot,ytitle='Object Counts (Electron)'

snplot=fltarr(3600)
for i=0,3599 do snplot[i]=cps*i/sqrt(readoutnoise^2+backgrrate*xbin*ybin+cps*i)
plot,findgen(3600),snplot,ytitle='SN',xtitle='Exposure Time (sec)'

b=-SNreq^2*(cps+backgrrate*binningfac)
a=cps^2
c=-SNreq^2*eff_readout^2
reqexptime=(-b+sqrt(b^2-4*a*c))/(2*a)

print,'Your input:'
print,'Source flux (erg s-1 cm-2) =',flambda,' (erg s-1 cm-2 A-1)'
print,'Exposure time (s) = ',exptime
print,'Required SN = ',snreq
print,'Calculation result'
print,'Expcted electron in electron: OBJ= ',obj_electron,' Sky= ',sky_electron
print,'Expected SN for a given exposure time = ',SN
print,'Exposure time to archive a required SN (s) = ',reqexptime

message,'Finish'

end
