pro exposure_calc_spec_cont
;
; Continuum spectrsocpy sensitivity and SN
; Input: line flux in units of erg/s/cm^2
; In case of readout noise limited
;
grism_selection=dialog_menu(['75','150','300','300 2nd'],TITLE='Select Grism')
slit_selection=dialog_menu(['0.2','0.4','0.6','0.8','1.0'],TITLE='Select Slit')
result=dialog_menu(['Magnitude','erg/s/cm^2'],TITLE='Type of Input')
	CASE result OF
        	'Magnitude': begin
result=dialog_input(prompt=["Magnitude","Exposure Time",'Sensitivity','Lambda (A)','Required SN','X bin','Y bin','Seeing (or source size)'],nfields=8,title='Data Input')
		end
		'erg/s/sm^2': begin
result=dialog_input(prompt=["F_lambda","Exposure Time",'Sensitivity','Lambda (A)','Required SN','X bin','Y bin','Seeing (or source size)'],nfields=8,title='Data Input')
		end
	ENDCASE

flambda=float(result[0])
exptime=float(result[1])
sensitivity=float(result[2])
lambda=float(result[3])*1e-10
snreq=float(result[4])
xbin=float(result[5])
ybin=float(result[6])
seeing=float(result[7])

if flambda GT 1 then mag=flambda
case grism_selection of
'75': begin
bandwidth=5.46
end
'150': begin
bandwidth=2.72
end
'300': begin
bandwidth=1.34
end
'300 2nd': begin
bandwidth=0.67
end
endcase

slit_width=float(slit_selection)
print,slit_width

backgrrate_U=0.6
backgrrate_B=4.0
backgrrate_V=7.6
backgrrate_R=12.0
backgrrate_I=22.9

bandwidth_U=560
bandwidth_B=1080
bandwidth_V=1000
bandwidth_R=1170
bandwidth_I=1460

if lambda LT 3750 then                    backgrrate=backgrrate_U*bandwidth/bandwidth_U
if lambda GT 3750 and lambda LT 5000 then backgrrate=backgrrate_B*bandwidth/bandwidth_B
if lambda GT 5000 and lambda LT 6000 then backgrrate=backgrrate_V*bandwidth/bandwidth_V
if lambda GT 6000 and lambda LT 7250 then backgrrate=backgrrate_R*bandwidth/bandwidth_R
if lambda GT 7250 then backgrrate=backgrrate_I/bandwidth_I*bandwidth*bandwidth_I

h=6.6260755e-34 * 1e7
c=2.99792458e8

readoutnoise=8
adcfac=2.75

if flambda GT 1 then begin
	magnitude=flambda
	fnuzero=3.52e-20 ;ergs/cm2/s/Hz
	freq=c/lambda; Hz
	Fnu = fnuzero * 10. ^(-0.4 * magnitude); ergs/cm^2/s/Hz
	Flambda=Fnu*c/lambda^2*1e-10; ergs/cm^2/s/A
endif

cps=(flambda*0.1^2/seeing^2*xbin*ybin)/(1/(sensitivity*ybin/2)/adcfac)*slit_width/(0.1*ybin)
obj_electron=cps*exptime

sky_electron=backgrrate*exptime*xbin*ybin

SN=obj_electron/sqrt(readoutnoise^2+sky_electron+obj_electron)

window,title='Expected Counts and SNs'
!P.MULTI=[0,1,2]

obj_electron_plot=fltarr(3600)
for i=0,3599 do obj_electron_plot[i]=cps*i
plot,findgen(3600),obj_electron_plot,ytitle='Object Counts (Electron)'

snplot=fltarr(3600)
for i=0,3599 do snplot[i]=cps*i/sqrt(readoutnoise^2+backgrrate*xbin*ybin+cps*i)
plot,findgen(3600),snplot,ytitle='SN',xtitle='Exposure Time (sec)'

b=-SNreq^2*(cps+backgrrate*xbin*ybin)
a=cps^2
c=-SNreq^2*readoutnoise^2
reqexptime=(-b+sqrt(b^2-4*a*c))/(2*a)

print,'Your input:'
print,'Source flux (erg s-1 cm-2) =',flambda
print,'Exposure time (s) = ',exptime
print,'Required SN = ',snreq
print,'Calculation result:'
print,'Expcted electron: OBJ= ',obj_electron,' Sky= ',sky_electron
print,'Expected SN for a given exposure time = ',SN
print,'Exposure time to archive a required SN (s) = ',reqexptime

message,'Finish'

end
