pro exposure_calc_spec
;
; Narrowband imaging sensitivity and SN
; Input: line flux in units of erg/s/cm^2
; In case of readout noise limited
;
grism_selection=dialog_menu(['75','150','300','300 2nd'],TITLE='Select Grism')
slit_selection=dialog_menu(['0.2','0.4','0.6','0.8','1.0'],TITLE='Select Slit')
result=dialog_input(prompt=["F_lambda","Exposure Time",'Sensitivity','Lambda (A)','Required SN','X bin','Y bin','Seeing'],nfields=8)
flambda=float(result[0])
exptime=float(result[1])
sensitivity=float(result[2])
lambda=float(result[3])*1e-10
snreq=float(result[4])
xbin=float(result[5])
ybin=float(result[6])
seeing=float(result[7])

if flambda GT 1 then mag=flambda
case grism_selection of
'75': begin
bandwidth=5.46
end
'150': begin
bandwidth=2.72
end
'300': begin
bandwidth=1.34
end
'300 2nd': begin
bandwidth=0.67
end
endcase

slit_width=float(slit_selection)
print,slit_width

backgrrate_U=0.6
backgrrate_B=4.0
backgrrate_V=7.6
backgrrate_R=12.0
backgrrate_I=22.9

if lambda LT 3750 then backgrrate=backgrrate_U
if lambda GT 3750 and lambda LT 5000 then backgrrate=backgrrate_B
if lambda GT 5000 and lambda LT 6000 then backgrrate=backgrrate_V
if lambda GT 6000 and lambda LT 7250 then backgrrate=backgrrate_R
if lambda GT 7250 then backgrrate=backgrrate_I

h=6.6260755e-34 * 1e7
c=2.99792458e8

readoutnoise=8
adcfac=2.75

backgrrate_B=4.0
backgrrate_V=7.6
backgrrate_R=12.0

bandwidth_B=1080
bandwidth_V=1000
bandwidth_R=1170
if flambda GT 1 then begin
	magnitude=flambda
	fnuzero=3.52e-20 ;ergs/cm2/s/Hz
	freq=c/lambda; Hz
	Fnu = fnuzero * 10. ^(-0.4 * magnitude); ergs/cm^2/s/Hz
	Flambda=Fnu*c/lambda^2*1e-10; ergs/cm^2/s/A
endif

backgrrate=backgrrate_B*bandwidth/bandwidth_B

cps=(flambda*0.1^2*xbin*ybin)/(1/(sensitivity*ybin/2)/adcfac)*slit_width/(0.1*ybin)

N_electron=cps*exptime

obj_electron=N_electron
sky_electron=backgrrate*exptime*xbin*ybin
SN=obj_electron/sqrt(readoutnoise^2+sky_electron+obj_electron)
N_ADU=obj_electron/adcfac
reqexptime=snreq*readoutnoise/cps

print,'Your input:'
print,'Source flux (erg s-1 cm-2) =',flambda
print,'Exposure time (s) = ',exptime
print,'Required SN = ',snreq
print,'Calculation result'
print,'Expcted electron in ADU: OBJ= ',obj_electron,' Sky= ',sky_electron
print,'Expected SN for a given exposure time = ',SN
print,'Exposure time to archive a required SN (s) = ',reqexptime

message,'Finish'

end
