pro exposure_calc_narrowband
;
; Narrowband imaging sensitivity and SN
; Input: line flux in units of erg/s/cm^2
; In case of readout noise limited
;
filter_selection=dialog_menu(['N373','N386','N487','N502','N512','N642','N658','N670'],TITLE='Select filter')
unit_selection=dialog_menu(['uJy','erg/s/cm^2'],TITLE='Flux unit')

if unit_selection EQ 'uJy' then prompt_array=["uJy","Exposure Time",'Required SN','Binning'] else prompt_array=["F_lambda","Exposure Time",'Required SN','Binning','Seeing']

result=dialog_menu(['Mag per Pix','Point Source','END'],TITLE='Type of operation')
       CASE result OF
                'Point Source': begin
			point_source_flag=1
			point_param=dialog_input(prompt=["Seeing (arcsec)"],nfields=1)
			seeing=float(point_param[0])
			end
                'END': message,'Finish'
		'Mag per Pix': point_source_flag=0
       ENDCASE

result=dialog_input(prompt=prompt_array,nfields=4)
flambda=float(result[0])
exptime=float(result[1])
snreq=float(result[2])

h=6.6260755e-34 * 1e7
c=2.99792458e8
M1_EFF=0.90
M2_EFF=0.90
FOCAS_EFF=0.80
readoutnoise=8
adcfac=2.75
backgrrate_B=4.0
backgrrate_V=7.6
backgrrate_R=12.0

bandwidth_B=1080
bandwidth_V=1000
bandwidth_R=1170

case filter_selection of

'N373': begin
filter_eff=0.7
lambda_center=3737e-10
ccd_eff=0.3
bandwidth=58
backgrrate=backgrrate_B*bandwidth/bandwidth_B
end

'N386': begin
filter_eff=0.8
lambda_center=3865e-10
ccd_eff=0.3
bandwidth=110
backgrrate=backgrrate_B*bandwidth/bandwidth_B
end

'N487': begin
filter_eff=0.7
lambda_center=4882e-10
ccd_eff=0.6
bandwidth=33
backgrrate=backgrrate_V*bandwidth/bandwidth_V
end

'N502': begin
filter_eff=0.7
lambda_center=5025e-10
ccd_eff=0.6
bandwidth=127
backgrrate=backgrrate_V*bandwidth/bandwidth_V
end

'N512': begin
filter_eff=0.7
lambda_center=5121e-10
ccd_eff=0.6
bandwidth=60
backgrrate=backgrrate_V*bandwidth/bandwidth_V
end

'N642': begin
filter_eff=0.9
lambda_center=6428e-10
ccd_eff=0.7
bandwidth=127
backgrrate=backgrrate_R*bandwidth/bandwidth_R
end

'N658': begin
filter_eff=0.8
lambda_center=6588e-10
ccd_eff=0.7
bandwidth=73
backgrrate=backgrrate_R*bandwidth/bandwidth_R
end

'N670': begin
filter_eff=0.9
lambda_center=6709e-10
ccd_eff=0.7
bandwidth=85
backgrrate=backgrrate_R*bandwidth/bandwidth_R
end

endcase
;
; uJy -> erg/s/Hz 1Jy=10-26 W/m^2/Hz = 1e-10-26*1e7/10^4 erg/s/cm^2/Hz=1e-23 erg/s/cm^2/Hz
; 1uJy=1e-29 erg/s/cm^2/Hz
if unit_selection EQ 'uJy' then flambda=flambda*1e-29*c/lambda_center^2*bandwidth*1e-10

freq=c/lambda_center ; Hz
area=!PI*(8.2*100/2)^2-!PI*(1.2*100/2)^2 
Flambda_incident=Flambda*area*filter_eff*M1_eff*M2_eff*FOCAS_EFF*CCD_EFF
E_photon=h * freq
cps=Flambda_incident/E_photon

if point_source_flag EQ 1 then objarea=seeing^2/(0.1^2*xbin*ybin) else objarea=1

obj_electron=N_electron/objarea
cps=cps/objarea
sky_electron=backgrrate*exptime*xbin*ybin
SN=obj_electron/sqrt(readoutnoise^2+sky_electron+obj_electron)

window,title='Expected Counts and SNs'
!P.MULTI=[0,1,2]

obj_electron_plot=fltarr(3600)
for i=0,3599 do obj_electron_plot[i]=cps*i
plot,findgen(3600),obj_electron_plot,ytitle='Object Counts (Electron)'

snplot=fltarr(3600)
for i=0,3599 do snplot[i]=cps*i/sqrt(readoutnoise^2+backgrrate*xbin*ybin+cps*i)
plot,findgen(3600),snplot,ytitle='SN',xtitle='Exposure Time (sec)'

b=-SNreq^2*(cts+backgrrate*xbin*ybin)
a=cps^2
c=-SNreq^2*readoutnoise^2
reqexptime=(-b+sqrt(b^2-4*a*c))/(2*a)

print,'Your input:'
print,'Source flux (erg s-1 cm-2) =',flambda
print,'Exposure time (s) = ',exptime
print,'Required SN = ',snreq
print,'Calculation result:'
print,'Expcted electron: OBJ= ',obj_electron,' Sky= ',sky_electron
print,'Expected SN for a given exposure time = ',SN
print,'Exposure time to archive a required SN (s) = ',reqexptime

message,'Finish'

end
