pro exposure_calc_broadband
filter_selection=dialog_menu(['U','B','V','R','I'],TITLE='Select filter')
result=dialog_input(prompt=["Mangnitude","Exposure time","Required SN"],nfields=3,title='Data Input')
magnitude=float(result[0])
exptime=float(result[1])
snreq=float(result[2])

result=dialog_menu(['Mag per Pix','Point Source','END'],TITLE='Type of operation')
       CASE result OF
                'Point Source': begin
			point_source_flag=1
			point_param=dialog_input(prompt=["Seeing (arcsec)"],nfields=1,title='Seeing')
			seeing=float(point_param[0])
			end
                'END': message,'Finish'
		'Mag per Pix': point_source_flag=0
       ENDCASE

bin=dialog_input(prompt=["Binning (input 2 in case of 2X2 binning"],nfields=1,title='Binning')
binfac=float(bin[0])

h=6.6260755e-34 * 1e7
c=2.99792458e8
M1_EFF=0.90
M2_EFF=0.90
FOCAS_EFF=0.80
readoutnoise=10
adcfac=2.75


case filter_selection of
'U': begin
airmasscor=0
lambda_center=3670e-10
lambda_start=3300e-10
lambda_end=4000e-10
zero=25.7
backgrrate=0.6
filter_eff=0.7
ccd_eff=0.3
end

'B':begin
airmasscor=0.174
lambda_center=4360e-10
lambda_start=4000e-10
lambda_end=5000e-10
zero=28.4
backgrrate=4.0
filter_eff=0.8
ccd_eff=0.6
end

'V':begin
airmasscor=0.08
lambda_center=5450e-10
lambda_start=5000e-10
lambda_end=6000e-10
zero=28.3
backgrrate=7.6
filter_eff=0.95
ccd_eff=0.65
end

'R': begin
airmasscor=0.05
lambda_center=6380e-10
lambda_start=6000e-10
lambda_end=7200e-10
zero=28.2
backgrrate=12
filter_eff=0.95
ccd_eff=0.7
end

'I':begin
airmasscor=0.03
lambda_center=7970e-10
lambda_start=7300e-10
lambda_end=9000e-10
zero=27.9
backgrrate=22.9
filter_eff=0.9
ccd_eff=0.6
end

endcase

area=!PI*(8.2*100/2)^2-!PI*(1.2*100/2)^2
fnuzero=3.52e-20 ;ergs/cm2/s/Hz
freq=c/lambda_center; Hz
Fnu = fnuzero * 10. ^(-0.4 * magnitude); ergs/cm^2/s/Hz

bandwidth=c/lambda_start-c/lambda_end; Hz
Fnu_lambda=Fnu*c/lambda_center^2
Fnu_incident=Fnu_lambda * area*filter_eff*M1_eff*M2_eff*FOCAS_EFF*CCD_EFF*(lambda_end-lambda_start); ergs/s
;Flambda_incident=Fnu_incident*c/lambda_center^2
E_photon=h * freq
cps=Fnu_incident/E_photon

obj_electron=cps*exptime

if point_source_flag then n_pix=(seeing*2/0.1)^2 else n_pix=1
sky_electron=backgrrate*exptime*n_pix

total_noise=sqrt(readoutnoise+obj_electron+sky_electron)
SN=obj_electron/total_noise

window,title='Expected Counts and SNs'
!P.MULTI=[0,1,2]

obj_electron_plot=fltarr(3600)
for i=0,3599 do obj_electron_plot[i]=cps*i
plot,findgen(3600),obj_electron_plot,ytitle='Object Counts (Electron)'

snplot=fltarr(3600)
for i=0,3599 do snplot[i]=cps*i/sqrt(readoutnoise^2+backgrrate*xbin*ybin+cps*i)
plot,findgen(3600),snplot,ytitle='SN',xtitle='Exposure Time (sec)'

b=-SNreq^2*(cts+backgrrate*n_pix)
a=cts^2
c=-SNreq^2*readoutnoise^2

reqexptime=(-b+sqrt(b^2-4*a*c))/(2*a)

print,'Your input:'
print,'Source magnitude =',magnitude
print,'Exposure time (s) = ',exptime
print,'Required SN = ',snreq
print,'Calculation result:'
print,'Expected SN for a given exposure time = ',SN
print,'Exposure time to archive a required SN (s) = ',reqexptime

message,"Finish"

end
