pro efficiency_lambda
; star data
magnitude=13.170
count=209181

exposure=1.0

h=6.6260755e-34 * 1e7
c=2.99792458e8

; U
lambda_center=3670e-10
lambda_start=3300e-10
lambda_end=4000e-10
;goto,skip1
; B
lambda_center=4360e-10
lambda_start=4000e-10
lambda_end=5000e-10
;goto,skip1
; V
llambda_center=5450e-10
lambda_start=5000e-10
lambda_end=6000e-10
;goto,skip1
; R
lambda_center=6380e-10
lambda_start=6000e-10
lambda_end=7200e-10
;goto,skip1
; I
lambda_center=7970e-10
lambda_start=7300e-10
lambda_end=9000e-10

skip1:

adcfac=2.5
area=!PI*(8.2*100/2)^2-!PI*(1.2*100/2)^2
fnuzero=3.52e-20 ;ergs/cm2/s/hz.  

Fnu = fnuzero * 10. ^(-0.4 * magnitude); ergs/cm^2/s/Hz
Fnu_incident=Fnu * area; ergs/s/Hz
freq=c/lambda_center ; Hz
Fnu_lambda=Fnu_incident*c/lambda_center^2
bandwidth=c/lambda_start-c/lambda_end
E_photon=h * freq

N_electron=count*adcfac/exposure
Fnu_sum=double(Fnu_lambda)*double((lambda_end-lambda_start))
N_photon=Fnu_sum/E_photon
eff=N_electron/N_photon ; lambda^-1*adcfac^1*bandwidth(A)^-1
zero=2.5 * alog10(count/exposure)+magnitude

print,freq,bandwidth,E_photon,Fnu_sum,N_photon,eff
print,'Throughput=',eff,'Zero point =',zero
;exit

message,'Finish'
end
