pro efficiency

result=dialog_input(prompt=["Zero Point","Band","Airmass"],nfields=3)
magnitude=13; dummy
zero=float(result[0])
airmass=float(result[2])

h=6.6260755e-34 * 1e7
c=2.99792458e5

case result[1] of

'U': begin
airmasscor=0
lambda_center=3670e-10
lambda_start=3300e-10
lambda_end=4000e-10
end

'B':begin
airmasscor=0.174
lambda_center=4360e-10
lambda_start=4000e-10
lambda_end=5000e-10
end

'V':begin
airmasscor=0.08
lambda_center=5450e-10
lambda_start=5000e-10
lambda_end=6000e-10
end

'R': begin
airmasscor=0.05
lambda_center=6380e-10
lambda_start=6000e-10
lambda_end=7200e-10
end

'I':begin
airmasscor=0.03
lambda_center=7970e-10
lambda_start=7300e-10
lambda_end=9000e-10
end

endcase

zero=zero+airmasscor*airmass

adcfac=2.5
area=!PI*(8.2*100/2)^2-!PI*(1.2*100/2)^2
fnuzero=3.52e-20 ;ergs/cm2/s/hz.  

cts=10^((zero-magnitude)/2.5)
;cts=count/exposure

Fnu = fnuzero * 10. ^(-0.4 * magnitude); ergs/cm^2/s/Hz
Fnu_incident=Fnu * area; ergs/s/Hz
freq=c/lambda_center ; Hz
bandwidth=c/lambda_start-c/lambda_end
E_photon=h * freq

N_electron=cts*adcfac

N_photon=Fnu_incident*bandwidth/E_photon
eff=N_electron/N_photon ; lambda^-1*adcfac^1*bandwidth(A)^-1
zero=2.5 * alog10(cts)+magnitude

Fnu_1es=Fnu/cts
mag=-alog10(Fnu_1es/fnuzero)/0.4

print,1/cts
;print,lambda_center,freq,bandwidth,E_photon,fnu_incident,N_photon,eff
print,'Throughput (without air)=',eff,'corrected for mirror',eff/0.81,'Zero point =',zero,'Mag for 1e/s =',mag
;exit
end
