pro distortion_gaussfits,image1,naxis,X_pos_id,Y_pos_id,X_obs,Y_obs,X_pos,Y_pos,x0,y0

common share5,samplefac,beta,X_inc, Y_inc, pix_inc

!P.MULTI=0

width=20; was 25; was 15
fac=1.0125;075
offset=5

ndata=N_ELEMENTS(X_POS_ID)

X_obs=dblARR(ndata)
Y_obs=dblARR(ndata)
X_pos=dblARR(ndata)
Y_pos=dblARR(ndata)

image1=double(temporary(image1))
xoffset=10 & xend=2000 & yoffset=10 & yend=4000
expand,image1,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image12

WINDOW,0,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=filename,colors=128
TV,BYTSCL(sigrange(image12[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],fraction=0.99))
undefine,image12
wset,0
CURSOR,xpos,ypos,/device
xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset

result=mygauss2dfit(image1[xpos-width:xpos+width,ypos-width:ypos+width],a)

X0=a[4]-width+xpos & Y0=a[5]-width+ypos
;WSET,1 & ERASE & show3,image3

print,"This is the Origin."

WINDOW,1,xsize=800,ysize=400,TITLE='Spot'
!P.MULTI=[0,2,1]
FOR i=0,ndata-1 do begin
	X_pos[i]=X_pos_id[i]*X_inc*fac/pix_inc+X0; in units of pixel
	Y_pos[i]=Y_pos_id[i]*Y_inc*fac/pix_inc+Y0

	result=mygauss2dfit(image1[X_pos[i]-width:X_pos[i]+width,Y_pos[i]-width+offset:Y_pos[i]+width+offset] < 10000,a)
;
; Fit results display
;
	contour,image1[X_pos[i]-width:X_pos[i]+width,Y_pos[i]-width+offset:Y_pos[i]+width+offset],title='OBS'
	contour,result,title='FIT'
;	wait,0.05
;	print,x_pos[i],y_pos[i]
	X_obs[i]=a[4]-width+X_pos[i] & Y_obs[i]=a[5]-width+Y_pos[i]+offset
ENDFOR

end
