pro distortion_chipcombine,naxis,X_pos_id,y_pos_id,X_pos_id2,Y_pos_id2,x_obs,y_obs,x_obs2,y_obs2,x_pos,y_pos,x_pos2,y_pos2,x0,y0,x02,y02,rotangle,rotangle2,x_obs12,y_obs12,x_pos12,y_pos12,delta_X12,delta_Y12,x_pos_id12,y_pos_id12,y_shift,gapsize,x_offset
common share5,samplefac,beta,X_inc, Y_inc, pix_inc

n=n_elements(x_obs)
overscan=58; was 38; was 75 for SITE
gap_estimate=52; was 70

ccdxdim=naxis[0]

difrot=rotangle2-rotangle; positive in the current setting
;print,difrot
;difrot=0.0291830697/180*3.141592

X_rotcenter=naxis[0]+overscan+gap_estimate; rotation ceter at right edge of CCD (difrot measured at near FOV center)
Y_rotcenter=FIX(naxis[1]/2)

X_obs2r= (X_obs2-X_rotcenter)*cos(-difrot)+(Y_obs2-Y_rotcenter)*sin(-difrot)+X_rotcenter
Y_obs2r=-(X_obs2-X_rotcenter)*sin(-difrot)+(Y_obs2-Y_rotcenter)*cos(-difrot)+Y_rotcenter

X_pos=X_pos_id*X_inc/pix_inc+X0; in units of pixel
Y_pos=Y_pos_id*Y_inc/pix_inc+Y0

X_rotcenter=0-overscan
Y_rotcenter=FIX(naxis[1]/2)

X_pos= (X_pos-X_rotcenter)*cos(rotangle)+(Y_pos-Y_rotcenter)*sin(rotangle)+X_rotcenter
Y_pos=-(X_pos-X_rotcenter)*sin(rotangle)+(Y_pos-Y_rotcenter)*cos(rotangle)+Y_rotcenter

X_pos2=X_pos_id2*X_inc/pix_inc+X02; in units of pixel
Y_pos2=Y_pos_id2*Y_inc/pix_inc+Y02

X_rotcenter=naxis[0]+overscan+gap_estimate
Y_rotcenter=FIX(naxis[1]/2)

X_pos2= (X_pos2-X_rotcenter)*cos(rotangle)+(Y_pos2-Y_rotcenter)*sin(rotangle)+X_rotcenter
Y_pos2=-(X_pos2-X_rotcenter)*sin(rotangle)+(Y_pos2-Y_rotcenter)*cos(rotangle)+Y_rotcenter

;
; --- JUMP ---
;

GOTO,noscale

; Chip 1 scale

WINDOW,2,xsize=800,ysize=800,TITLE=name

!P.MULTI=[0,2,2]
plot,X_obs,delta_X,/ynozero,title='Chip 1 residual'
fit_result_chip1_X=poly_fit(X_pos,X_obs,1,/double)
plot,Y_obs,delta_Y,/ynozero,title='Chip 1 residual'
fit_result_chip1_Y=poly_fit(Y_pos,Y_obs,1,/double)

; Chip 2 scale

plot,X_obs2,delta_X2,/ynozero,title='Chip 2 residual'
fit_result_chip2_X=poly_fit(X_pos2,X_obs2,1,/double)
plot,Y_obs2,delta_Y2,/ynozero,title='Chip 2 residual'
fit_result_chip2_y=poly_fit(Y_pos2,Y_obs2,1,/double)

!P.MULTI=0

; mean scale of chip 1, 2

print,'#fit_result',fit_result_chip1_X[1],fit_result_chip2_X[1],fit_result_chip1_Y[1],fit_result_chip2_Y[1]

X_inc_factor=(fit_result_chip1_X[1]+fit_result_chip2_X[1]+fit_result_chip1_Y[1]+fit_result_chip2_Y[1])/4.
;
;
;
x_inc_factor=1.
;
;
;
X_inc1=X_inc*X_inc_factor & X_inc2=X_inc*X_inc_factor & Y_inc1=X_inc*X_inc_factor & Y_inc2=X_inc*X_inc_factor

X_pos=X_pos_id*X_inc1/pix_inc+X0; in units of pixel
Y_pos=Y_pos_id*Y_inc1/pix_inc+Y0

X_pos= X_pos*cos(rotangle)+Y_pos*sin(rotangle)
Y_pos=-X_pos*sin(rotangle)+Y_pos*cos(rotangle)

X_pos2=X_pos_id2*X_inc2/pix_inc+X02; in units of pixel
Y_pos2=Y_pos_id2*Y_inc2/pix_inc+Y02

X_pos2= X_pos2*cos(rotangle)+Y_pos2*sin(rotangle)
Y_pos2=-X_pos2*sin(rotangle)+Y_pos2*cos(rotangle)

X_obs2= X_pos2*cos(rotangle)+Y_pos2*sin(rotangle)
Y_pos2=-X_pos2*sin(rotangle)+Y_pos2*cos(rotangle)

;
; --- JUMP ---
;

noscale:

delta_X=X_obs-X_pos
delta_Y=Y_obs-Y_pos

delta_X2=X_obs2r-X_pos2
delta_Y2=Y_obs2r-Y_pos2

;gapsize=-(ccdxdim-mean(X_obs2[14:20]))+X_inc/pix_inc*3-mean(X_obs[14:20])

x1p=x_pos[where(y_obs GT y_obs[17]-50 AND y_obs LT y_obs[17]+50)]
x1=x_obs[where(y_obs GT y_obs[17]-50 AND y_obs LT y_obs[17]+50)]
x2p=x_pos2[where(y_obs2r GT y_obs[17]-50 AND y_obs2r LT y_obs[17]+50)]
x2=x_obs2r[where(y_obs2r GT y_obs[17]-50 AND y_obs2r LT y_obs[17]+50)]
xx=findgen(17); was 16 for SITE
plot,xx,x2,psym=1,/ynozero
fit_result_chip2=poly_fit(xx,x2,3,fitx2,/double)
gap_number=2; gap number expected between chip1 and 2. was 4 for Site (three columns hidden)
x1_predict=fit_result_chip2[1]*(-gap_number)+x2[0]
x1_predict=fit_result_chip2[0]+fit_result_chip2[1]*(-gap_number)+fit_result_chip2[2]*(-gap_number)^2+fit_result_chip2[3]*(-gap_number)^3
plot,xx,x1,psym=1,/ynozero
gapsize=x1_predict-ccdxdim-x1[0]+(overscan-1)*2; was 0; was +1
; subtract -1 for consistency
gapsize=gapsize-1;
print,'gapsize',gapsize
;gapsize=49.352354

;window
;gap=fltarr(35)
;for j=0,34 do gap[j]=-(ccdxdim-X_obs2r[j])+X_inc/pix_inc*4-X_obs[j]
;x=findgen(35)
;plot,x,gap,/ynozero,psym=2
;result=poly_fit(x,gap,2,fit)
;oplot,x,fit
;gapsize=-(result[1]^2-4*result[2]*result[0])/4/result[2]

;
; Y_shift
;
y1=y_obs[where(y_obs GT y_obs[17]-50 AND y_obs LT y_obs[17]+50)]
x1=x_obs[where(y_obs GT y_obs[17]-50 AND y_obs LT y_obs[17]+50)]
x12=x1+gapsize+ccdxdim
y2=y_obs2r[where(y_obs2r GT y_obs[17]-50 AND y_obs2r LT y_obs[17]+50)]
x2=x_obs2r[where(y_obs2r GT y_obs[17]-50 AND y_obs2r LT y_obs[17]+50)]
plot,x12,y1,xrange=[0,4000],yrange=[y_obs[17]-20,y_obs[17]+20]
oplot,x2,y2
fit_result_chip1=poly_fit(x12,y1,1,fity1,/double)
fit_result_chip2=poly_fit(x2,y2,1,fity2,/double)

oplot,x12,fity1
oplot,x2,fity2

xx=x12
fity1_exp=fit_result_chip2[0]+fit_result_chip2[1]*xx
y_shift=mean(fity1-fity1_exp)+1; was +0
print,'#Y_shift',y_shift
;
;y_shift=-1.8051223
;
;y10_fit=fit_result_chip2[0]+fit_result_chip2[1]*(x2[0]+X_inc/pix_inc*3)
;Y_shift=y1[0]-y10_fit

;Y_shift=(mean(Y_obs[14:20])-mean(Y_obs2r[14:20]))/cos(rotangle)
;plot,x_obs[where(y_obs LT 2100 AND y_obs GT 1900)]

; Y_shift must be positive in this definition.
; Chip 1 shows larger Y pos.

;gapsize=-(ccdxdim-mean(X_obs2[0:15]))+X_inc/pix_inc-mean(X_obs[0:15])*cos(rotangle)

naxis[0]=naxis[0]*2+gapsize-overscan*2

X_obs1=X_obs+ccdxdim+cos(rotangle2)*(gapsize-overscan*2);-(delta_X[17]-delta_X2[17]); remove overscan
X_obs12=[X_obs1,X_obs2r]

X_pos1=X_pos+ccdxdim+cos(rotangle)*(-overscan*2+gapsize+mean(delta_X[[17,17+35,17+35*2]]-delta_X2[[17+35,17+35*2]]));remove overscan; was [17]
x_pos11=x_pos1-cos(rotangle)*mean(x_pos1[[17,17+35,17+35*2]]-x_obs1[[17,17+35,17+35*2]])
x_pos2=x_pos2-cos(rotangle)*mean(x_pos2[[17,17+35,17+35*2]]-x_obs2r[[17,17+35,17+35*2]])
X_pos12=[X_pos11,X_pos2]

delta_X12=X_obs12-X_pos12
;X_pos12=X_pos12+mean(delta_X12)
X_obs12=X_obs12-mean(delta_X12); was +
;x_offset=mean(delta_X12)+delta_X[17]-delta_X2[17]; remove overscan
delta_X12=delta_X12-mean(delta_X12)

;X_pos12=X_pos12+mean(X_obs12-X_pos12)
print,'Check Exp-obs gap size',x_pos2[17]-x_pos12[17]+x_inc/pix_inc*gap_number

delta_Y=Y_obs-Y_pos
delta_Y2=Y_obs2r-Y_pos2

y_pos1=Y_pos+mean(delta_Y)
y_pos1=y_pos1+mean(y_pos1[16:18]-y_obs[16:18])
Y_pos2=Y_pos2+mean(delta_Y2)
y_pos2=y_pos2+mean(y_pos1[16:18]-y_pos2[16:18])
y_pos2=y_pos2+mean(y_pos2[16:18]-y_pos1[16:18]);+y_shift

Y_pos12=[Y_pos1,y_pos2]

y_obs1=y_obs
Y_obs2r=Y_obs2r+mean(y_pos1[16:18]-y_pos2[16:18])
y_obs2r=y_obs2r+mean(y_obs1[16:18]-y_obs2r[16:18]);+y_shift

Y_obs12=[Y_obs1,y_obs2r]
print,'Diff of chip1, 2 height in obs',y_obs1[17]-y_obs2r[17]
print,'Diff of chip1, 2 height in pos',y_pos1[17]-y_pos2[17]
;print,mean(delta_Y),mean(delta_Y2)

delta_Y=Y_obs1-Y_pos1
delta_Y2=Y_obs2r-Y_pos2

y_pos12=y_pos12+mean(y_obs12[16:18]-y_pos12[16:18])

;delta_Y=delta_Y-mean(delta_Y)
;delta_Y2=delta_Y2-mean(delta_Y2)
delta_Y12=[delta_Y,delta_Y2]
;delta_Y12=delta_Y12-mean(delta_y12)

end
