pro distortion
common share5,samplefac,beta,X_inc, Y_inc, pix_inc

beta=0.29958085*0.998;0.997;*0.990
X_inc = 5*beta; 5 mm per aperture * focus ratio
Y_inc = 5*beta; 1/3.324226
pix_inc=0.015; mm/pix
x_inc_factor=1.0

;if checkfocana() then fitsdir='/data2/ohyama/DIST/' else fitsdir='/work/o99004/DIST/'
fitsdir=getenv("FOCASRED_FITS_IN")+'/'
if fitsdir EQ '/' then fitsdir=getenv('PWD')


;;;
;;; main program
;;;
retry:
fileName = DIALOG_PICKFILE (PATH=fitsdir, FILTER = '*.fits',/multiple,title='Choose a pair of 2 images')

if(n_elements(filename) EQ 1) then begin
	print,'Choose 2 files'
;	goto,retry
	message,'Choose 2 files'
endif

;read_fits,image1,header,DIR=fitsdir
;read_fits,image2,header,dir=fitsdir

image1=MRDFITS(filename[0],0,header1,/silent,/fscale)
image2=MRDFITS(filename[1],0,header2,/silent,/fscale)
;image1=REVERSE(image1, 2); Flip X direction

name = SXPAR( header1 ,'OBJECT')
naxis= SXPAR( header1,'NAXIS*')
samplefac=get_samplefac(naxis[1])

; image display after rebinning nicely

xoffset=10 & xend=2000 & yoffset=10 & yend=4000

readxy_dist,x_pos_id,y_pos_id,ndata,filenameinput='/grp01/o99004/ohyama/FOCAS/ENG/DIST_ANALYSIS/DISTDATA/spots_chip1_MIT.xy'
distortion_gaussfits,image1,naxis,X_pos_id,Y_pos_id,X_obs,Y_obs,X_pos,Y_pos,x0,y0
delta_X=X_obs-X_pos & delta_Y=Y_obs-Y_pos

readxy_dist,x_pos_id2,y_pos_id2,ndata2,filenameinput='/grp01/o99004/ohyama/FOCAS/ENG/DIST_ANALYSIS/DISTDATA/spots_chip2_MIT.xy'
distortion_gaussfits,image2,naxis,X_pos_id2,Y_pos_id2,X_obs2,Y_obs2,X_pos2,Y_pos2,x02,y02; was image2
delta_X2=X_obs2-X_pos2 & delta_Y2=Y_obs2-Y_pos2
;
;Rotate
;
!P.MULTI=0

fit_result_rotate=poly_fit(Y_obs[0:34],X_obs[0:34],1,yfit,yband,sigma_result,cor,/double)
rotangle=fit_result_rotate[1]
print,"rotangle=",rotangle*180/3.141592,"+-",sigma_result

fit_result_rotate=poly_fit(Y_obs2[0:34],X_obs2[0:34],1,yfit,yband,sigma_result,cor,/double)
rotangle2=fit_result_rotate[1]
print,"rotangle2=",rotangle2*180/3.141592,"+-",sigma_result

difrot=rotangle2-rotangle; positive in the current setting

distortion_chipcombine,naxis,X_pos_id,y_pos_id,X_pos_id2,Y_pos_id2,x_obs,y_obs,x_obs2,y_obs2,x_pos,y_pos,x_pos2,y_pos2,x0,y0,x02,y02,rotangle,rotangle2,$
	x_obs12,y_obs12,x_pos12,y_pos12,delta_X12,delta_Y12,x_pos_id12,y_pos_id12,y_shift,gapsize,x_offset

;X_rotcenter=FIX(naxis[0]/2)
;Y_rotcenter=FIX(naxis[1]/2)

xDOTcenter=X_obs12[17]-x_inc/pix_inc*1; was *2 for SITE;-x_offset
print,'Check XDOTCenter:',xdotcenter,X_obs12[n_elements(x_obs12)/2-1+17]+x_inc/pix_inc*1; was *2 for SITE
yDOTcenter=Y_obs12[17]
xFOVcenter=mean(x_obs12);-x_offset; was pos12
yFOVcenter=mean(y_obs12); was pos12
print,'Check Diff between DOTcenter - FOVcenter',xfovcenter-xdotcenter,yfovcenter-ydotcenter
;
; Add a refrence vector
;
X_pos12=[X_pos12,250] & Y_pos12=[Y_pos12,250]
X_obs12=[X_obs12,250] & Y_obs12=[Y_obs12,250]
delta_X12=[delta_X12,5] & delta_Y12=[delta_Y12,5]
;
; Plots vector
;
xoffset=0 & xend=naxis[0] & yoffset=0 & yend=naxis[1]
window,3,xsize=xend/samplefac,ysize=yend/samplefac,title='Distortion Plot'
!P.MULTI=0
partvelvec,delta_X12,delta_Y12,X_pos12,Y_pos12,[xoffset,xend],[yoffset,yend]
partvelvec,X_obs12-X_pos12,Y_obs12-Y_pos12,X_pos12,Y_pos12,[xoffset,xend],[yoffset,yend]

;;     info.ps_config = cmps_form(/Initialize)

;     formInfo = cmps_form(Cancel=canceled, Create=create)
;
;     IF NOT canceled THEN BEGIN
;        IF create THEN BEGIN
;           thisDevice = !D.Name
;           Set_Plot, "PS"
;           Device, _Extra=formInfo
;
;		partvelvec,delta_X12,delta_Y12,X_pos12,Y_pos12,[xoffset,xend],[yoffset,yend]
;
;           Device, /Close
;           Set_Plot, thisDevice
;;           info.ps_config = formInfo
;        ENDIF ELSE BEGIN
;           info.ps_config = formInfo
;	ENDELSE
;    ENDIF

; subtract -1 for consistensy (2004Sep)
;gapsize=gapsize-1

print,'Gapsize=',gapsize,'(pix)'
print,'Relative pixel shift in Y=',Y_shift,'(pix)'
;print,'Scale factor=,X_inc_factor
print,'rotation angle=',rotangle*180/3.141592,rotangle2*180/3.141592,'(deg)','difrot=',(rotangle2-rotangle)*180/3.141592,'deg'
print,'FOV center (X, Y)=',xFOVcenter,yFOVcenter
print,'DOT center (X, Y)=',xDOTcenter,yDOTcenter

;
; Distortion Fitting (X-Y)
;

;degree=4
;fit_result_delta_X12=sfitxyz(delta_X12,x_pos12,y_pos12,degree,kx=coef_X)
;fit_result_delta_Y12=sfitxyz(delta_Y12,x_pos12,y_pos12,degree,kx=coef_Y)

;xymatrix=fltarr(degree+1,degree+1)
;fitvector_x=fltarr(ndata+ndata2)
;fitvector_y=fltarr(ndata+ndata2)

;FOR l=0,ndata-1+ndata2 do begin
;	for i=0, degree do for j=0,degree do xymatrix[i,j]=[X_pos12[l]^j*Y_pos12[l]^i]
;	fitvector_x[l]=total(coef_x * xymatrix)
;	fitvector_y[l]=total(coef_y * xymatrix)
;ENDFOR

;fitvector_x=[fitvector_x,1]
;fitvector_y=[fitvector_y,1]

;window,6,xsize=400,ysize=400
;!P.MULTI=[0,2,2]
;partvelvec,fitvector_x,fitvector_y,X_pos12,Y_pos12,[xoffset,xend],[yoffset,yend],title='FIT'
;partvelvec,delta_X12,delta_Y12,X_pos12,Y_pos12,[xoffset,xend],[yoffset,yend],title='OBS'
;dif_x=fitvector_x-delta_X12
;dif_y=fitvector_y-delta_y12
;dif_x[N_elements(dif_x)-1]=1
;dif_y[N_elements(dif_y)-1]=1
;partvelvec,dif_x,dif_y,X_pos12,Y_pos12,[xoffset,xend],[yoffset,yend],title='Residual'

;X_pos_on_focusplane=(X_obs12-fitvector_x-xFOVcenter)*(pix_inc/X_inc_factor)/beta+90
;; for MOS orientation
;;X_pos_on_focusplane=180-(X_obs12-fitvector_x-xFOVcenter)*(pix_inc/X_inc_factor)/beta
;Y_pos_on_focusplane=(Y_obs12-fitvector_y-yFOVcenter)*(pix_inc/X_inc_factor)/beta+90

;window,8
;plot,X_pos_on_focusplane,Y_pos_on_focusplane,psym=1

;
; Fitting result output
;

;fileName = DIALOG_PICKFILE (/WRITE, FILTER = '*.dat')
;   IF (fileName NE '') THEN BEGIN
;
;      d = FINDFILE (fileName, COUNT = fileExists)
;      IF (fileExists) THEN BEGIN
;         IF (DIALOG_MESSAGE (/QUESTION, ['File ' + fileName + ' exists.', $
;	     'Overwrite?']) EQ 'No') THEN $
;            GOTO, do_nothing
;      ENDIF
;	openw,1,fileName
;	for i=0, degree do printf,1,coef_x[i,0],',',coef_x[i,1],',',coef_x[i,2],',',coef_x[i,3],',',coef_x[i,4],',',coef_x[i,5],',',coef_x[i,6]
;	close,1
;ENDIF

;fileName = DIALOG_PICKFILE (/WRITE, FILTER = '*.dat')
;   IF (fileName NE '') THEN BEGIN
;      d = FINDFILE (fileName, COUNT = fileExists)
;      IF (fileExists) THEN BEGIN
;         IF (DIALOG_MESSAGE (/QUESTION, ['File ' + fileName + ' exists.', $
;	     'Overwrite?']) EQ 'No') THEN $
;            GOTO, do_nothing
;      ENDIF
;	openw,1,fileName
;	for i=0, degree do printf,1,coef_y[i,0],',',coef_y[i,1],',',coef_y[i,2],',',coef_y[i,3],',',coef_y[i,4],',',coef_y[i,5],',',coef_y[i,6]
;	close,1
;ENDIF
;delvar,image12,image22,imagerot,bigimagerot2,bigimage

window,5

xFOVcenter_org=xFOVcenter
yFOVcenter_org=yFOVcenter

sigma=fltarr(61,61)

for j=-30,30 do begin
	for i=-30,30 do begin
		xFOVcenter=xFOVcenter_org+i
		yFOVcenter=yFOVcenter_org+j

		X_pos_on_focusplane2=(X_pos12-xFOVcenter)*(pix_inc/X_inc_factor)/beta
		Y_pos_on_focusplane2=(Y_pos12-yFOVcenter)*(pix_inc/X_inc_factor)/beta

		yc=sqrt(X_pos_on_focusplane2^2+Y_pos_on_focusplane2^2)
		y=sqrt(((X_obs12-xfovcenter)*pix_inc)^2+((Y_obs12-yfovcenter)*pix_inc)^2)
		dist=(y-beta*yc)/(beta*yc)*100
		distinv=1/(1+dist/100)
		;plot,yc,distinv,/ynozero,psym=2,xrange=[0,100],yrange=[0.98,1.01]
		;fitresult=poly_fit(yc[where(yc LT 100)],distinv[where(yc LT 100)],2,distfit,yband,sigma_tmp)
		fitresult=robust_poly_fit(yc[where(yc LT 100)],distinv[where(yc LT 100)],2,distfit,sigma_tmp)
		;result=dialog_plot2(xdata=yc,ydata=dist,/ps_option,xtitle='Yc (mm)',ytitle='Distorion (%)',xrange=[0,100],yrange=[-2,2],psym=1)
		res=distfit-distinv[where(yc LT 100)]
;		plot,yc,res,psym=2,yrange=[-0.004,0.004],xrange=[0,100]
		sigma[i+30,j+30]=sigma_tmp
;		print,i,j,sigma[i+20,j+20]
	endfor
endfor

minid=where(sigma EQ min(sigma))
xFOVcenter_tmp=xFOVcenter_org+(minid-FIX(minid/61)*61-30)
yFOVcenter_tmp=yFOVcenter_org+(FIX(minid/61)-30)
xFOVcenter=xFOVcenter_tmp[0] & yFOVcenter=yFOVcenter_tmp[0]
print,'X, Y and firresidual(%)',minid-FIX(minid/61)*61-30,FIX(minid/61)-30,min(sigma)*100
;print,'FOV center (X, Y)=',xFOVcenter,yFOVcenter
print,'Dist center (X, Y)=',xFOVcenter,yFOVcenter

X_pos_on_focusplane2=(X_pos12-xFOVcenter)*(pix_inc/X_inc_factor)/beta
Y_pos_on_focusplane2=(Y_pos12-yFOVcenter)*(pix_inc/X_inc_factor)/beta

yc=sqrt(X_pos_on_focusplane2^2+Y_pos_on_focusplane2^2)
y=sqrt(((X_obs12-xfovcenter)*pix_inc)^2+((Y_obs12-yfovcenter)*pix_inc)^2)
dist=(y-beta*yc)/(beta*yc)*100
distinv=1/(1+dist/100)
;fitresult=poly_fit(yc[where(yc LT 100)],distinv[where(yc LT 100)],3,distfit,yband,sigma_tmp)
fitresult=robust_poly_fit(yc[where(yc LT 100)],distinv[where(yc LT 100)],3,distfit,sigma_tmp)
result=dialog_plot2(xdata=yc,ydata=dist,/ps_option,xtitle='Yc (mm)',ytitle='Distorion (%)',xrange=[0,100],yrange=[-0.5,1.5],psym=1)
res=distfit-distinv[where(yc LT 100)]
plot,yc,res,psym=2,yrange=[-0.004,0.004],xrange=[0,100]

print,'Dist fit coefficient='
print,fitresult

plot,yc[where(yc LT 100)],dist[where(yc LT 100)]/100,psym=2
;fitresult2=poly_fit(yc[where(yc LT 100)],dist[where(yc LT 100)]/100,3,distfit,yband,sigma_tmp)
fitresult2=robust_poly_fit(yc[where(yc LT 100)],dist[where(yc LT 100)]/100,3,distfit,sigma_tmp)
print,'Dist fit coefficient (INV)='
print,fitresult2

;print,(mean(x_pos12[35:35+272])+mean(x_pos12[475:475+272]))/2,xfovcenter
;print,(mean(y_pos12[35:35+272])+mean(y_pos12[475:475+272]))/2,yfovcenter

window,6
n=n_elements(yc[where(yc LT 100)])
plot,x_obs12,distinv,/ynozero,psym=2,yrange=[0.98,1.01]
plot,y_obs12,distinv,/ynozero,psym=2,yrange=[0.98,1.01]
plot,x_obs12[0:n/2],res[0:n/2],psym=4,yrange=[-0.002,0.002]
plot,y_obs12[0:n/2],res[0:n/2],psym=4,yrange=[-0.002,0.002]
plot,x_obs12[n/2:n-1],res[n/2:n-1],psym=4,yrange=[-0.002,0.002]
plot,y_obs12[n/2:n-1],res[n/2:n-1],psym=4,yrange=[-0.002,0.002]
plot,yc[0:n/2-1],res[0:n/2-1],psym=2,yrange=[-0.004,0.004],xrange=[0,100]
plot,yc[n/2-1:n-1],res[n/2-1:n-1],psym=2,yrange=[-0.004,0.004],xrange=[0,100]


plot,x_obs12,res,psym=4,yrange=[-0.002,0.002]
plot,y_obs12,res,psym=4,yrange=[-0.002,0.002]
print,mean(y_obs12[n/2-1:n-1]),mean(y_obs12[0:n/2-1])
print,mean(y_pos12[n/2-1:n-1]),mean(y_pos12[0:n/2-1])

plot,x_obs12[0:n/2],y_obs12[0:n/2]-y_pos12[0:n/2],psym=4
plot,y_obs12[0:n/2],x_obs12[0:n/2]-x_pos12[0:n/2],psym=4
plot,x_obs12[n/2:n-1],y_obs12[n/2:n-1]-y_pos12[n/2:n-1],psym=4
plot,y_obs12[n/2:n-1],x_obs12[n/2:n-1]-x_pos12[n/2:n-1],psym=4


message,'Finish!'
DO_NOTHING:

END
