pro combine_chip12,image1,image2,bigimage,header,DISTCALIBFLAG=distcalibflag,OUTOFFOVZEROFLAG=outoffovzeroflag

IF (keyword_set(distcalibflag) EQ 0) THEN distcalibflag = 0
IF (keyword_set(outofFOVzeroflag) EQ 0) THEN outofFOVzeroflag = 0

OUT_OF_FOV_VALUE=0
;overscan=75; for SITe
;overscan=38; for MIT testing (Sep. 2001)
;overscan=58; MIT

bin=SXPAR(header,'BIN-FCT*')
xbin=bin[0]
ybin=bin[1]

s=size(image1)
naxis=intarr(2)
naxis[0]=s[1]
naxis[1]=s[2]

;IF distcalibflag then begin
;	difrot=0.01212
;	gapsize=71.0652
;	Y_shift=-2.39+1.0
;endif else begin
;;	difrot=0.01225
;;	gapsize=67.43465
;;	Y_shift=-2.4055320+1.0
;;
;; super distortion at Aug. run at summit;    scale=1.0029584
;;
;	difrot=0.012121
;	gapsize=69.5216
;	Y_shift=-3.1994+1.0
;;
;; super distortion after Aug. run at base
;;
;	difrot=0.012207
;	gapsize=71.6314; was 70.6771 for asymmetric version
;	Y_shift=-2.9787+1.0
;
;	difrot=0.01335846
;	gapsize=70.1760
;	Y_shift=-2.9230526
;
;	difrot=0.011134763
;	gapsize=69.0918
;	Y_shift=-0.53652383-2.0
;;
;; 0930 FIeld 10
;;

;	difrot=0.011134784
;	gapsize=69.0920+2.0
;	Y_shift=-0.50805068-2.0

;endelse
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
;read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv

if outofFOVzeroflag then begin
	r_fov=3.0*60/0.103
	params=dialog_input(prompt=['FOV radius (pix)','X FOV center','Y FOV center'],initial=[r_fov,xDISTcenter,yDISTcenter],nfields=3,title='Input FOV information')
	r_fov=float(params[0])
	xDISTcenter=float(params[1])
	yDISTcenter=float(params[2])
endif

;overscanvalue=mean(image1[1975:2040,50:1950])
if outofFOVzeroflag then overscanvalue=OUT_OF_FOV_VALUE else overscanvalue=mean(image1[naxis[0]-overscan/xbin+5:naxis[0]-5,50:naxis[1]-50]); was 1950
blank=make_array(FIX(gapsize/xbin),naxis[1],/float,value=overscanvalue)
;
; New trimming Overscan 75 between chip 1, 2
;

image2=image2[0:naxis[0]-1-FIX((overscan-1)/xbin),*]; 75 pix=[0:74]
image1=image1[FIX((overscan-1)/xbin):naxis[0]-1,*];
;
;
;
image2rot=rot(image2,-difrot/xbin*ybin,1.0,naxis[0],naxis[1]/2,/pivot,/interp)
image2rotshift=shift(image2rot,0,round(Y_shift/YBIN)) & image2rot=0
bigimage= [image2rotshift, blank, image1] & image2rotshift=0 & blank=0
naxis[0]=FIX(naxis[0]*2+gapsize/xbin-overscan*2/xbin)
;
; Set out of FOV to Zero
;
if outofFOVzeroflag then begin
for i=0,naxis[0]-1 do begin
	for j=0,naxis[1]-1 do begin
		r=sqrt((i-xDISTcenter)^2+(j-yDISTcenter)^2)
		if r gt r_fov then bigimage[i,j]=OUT_OF_FOV_VALUE
	end
end

end

;
; Header manupulation
;
cdelt1=double(SXPAR(header,'CDELT1'))
cdelt2=double(SXPAR(header,'CDELT2'))
cd2_1=double(SXPAR(header,'CD2_1'))
cd1_2=double(SXPAR(header,'CD1_2'))

cdelt1=cdelt1/abs(cdelt1)*2.8833e-5;=0.1038 arcsec/pix; was 2.88311e-5
cdelt2=cdelt2/abs(cdelt2)*2.8833e-5; was 2.88311e-5
cd2_1=0; was cd2_1/abs(cd2_1)*2.8833e-5; was 2.88311e-5
cd1_2=0; was cd1_2/abs(cd1_2)*2.8833e-5; was 2.88311e-5

sxaddpar,header, 'NAXIS1', naxis[0]
sxaddpar,header,'CDELT1',cdelt1
sxaddpar,header,'CDELT2',cdelt2
sxaddpar,header,'CD2_1',cd2_1
sxaddpar,header,'CD1_2',cd1_2

sxaddpar,header,'PC001001',-1.0
sxaddpar,header,'PC001002',0.0
sxaddpar,header,'PC002001',0.0
sxaddpar,header,'PC002002',1.0

check_FITS, bigimage, header,/update


end
