pro ciscored

;nframe_at_1pos=float(dialog_input(prompt=['# of Frames at each position']))

nfilename=DIALOG_PICKFILE(PATH='/wr25/ohyama/CISCO/NB/',filter='O*.fits',/MULTIPLE_FILES)
IF(STRLEN(nfilename[0]) EQ 0) THEN stop
nfiles=size(nfilename,/N_ELEMENTS)

header=headfits(nfilename[0])
naxis= SXPAR(header,'NAXIS*')

outfileName = DIALOG_PICKFILE (FILTER = '*.fits')

  IF (outfileName NE '') THEN BEGIN

      d = FINDFILE (outfileName, COUNT = fileExists)
      IF (fileExists) THEN BEGIN
         IF (DIALOG_MESSAGE (/QUESTION, ['File ' + outfileName + ' exists.', $
	     'Overwrite?']) EQ 'No') THEN GOTO, DO_NOTHING
      ENDIF
ENDIF

subpattern,original,subtract,step,nfiles

;
; FITS read
;
image=fltarr(naxis[0],naxis[1],nfiles,/nozero)
print,'Read Files'
for i=0,nfiles-1 do image[*,*,i]=MRDFITS(nfilename[i],0,header,/silent,/fscale)

;
; Making Flat
;
print,'Making flat'
flatimage=fltarr(naxis[0],naxis[1],/nozero)
image_flat_norm=fltarr(naxis[0],naxis[1],nfiles,/nozero)
;for i=0,naxis[1]-1 do for j=0,naxis[0]-1 do flatimage[j,i]=median(image[j,i,0:nfiles-1])
for i=0,nfiles-1 do image_flat_norm[*,*,i]=image[*,*,i]/median(image[*,*,i]);(total(image[*,*,i])/n_array)
;robust_mean,image_flat_norm,flatimage,cutstart=0,cutend=7./8.;,image_mask
;sigclipavgarr,image_flat_norm,flatimage,cutstart=0,cutend=7./8.;,image_mask
medarr,image_flat_norm,flatimage
undefine,image_flat_norm
;
; Image subtraction
;
print,'Image Sub'
image_sub=fltarr(naxis[0],naxis[1],nfiles,/nozero)
;image_sub[*,*,0:nframe_at_1pos]=image[*,*,0:nframe_at_1pos]-image[*,*,nframe_at_1pos:nframe_at_1pos*2]
;for i=nframe_at_1pos,nfiles-1 do image_sub[*,*,i]=image[*,*,i]-image[*,*,i-nframe_at_1pos]
;image_sub[*,*,indgen(nfiles)]=image[*,*,original]-image[*,*,subtract]
for i=0,nfiles-1 do image_sub[*,*,i]=image[*,*,original[i]]-image[*,*,subtract[i]]
undefine,image

print,'Flat fielding'
image_flat=fltarr(naxis[0],naxis[1],nfiles,/nozero)
for i=0,nfiles-1 do image_flat[*,*,i]=image_sub[*,*,i]/flatimage[*,*]
undefine,image_sub
undefine,flatimage

print,'Bias sub'
image_mask=bytarr(naxis[0],naxis[1],nfiles)
image_mask[*,*,*]=1b
autorangeset,image_flat[*,*,0],range
window,1,xsize=naxis[0],ysize=naxis[1]
range[0]=range[0]-0.1*(range[1]-range[0])
range[1]=range[1]+0.1*(range[1]-range[0])
image_sky=fltarr(naxis[0],naxis[1],nfiles,/nozero)
;cutstart2=0
;cutend2=FIX((naxis[1]-40)*0.9)-1 
for i=0,nfiles-1 do begin
	sky=fltarr(naxis[0])
	for l=0,naxis[0]-1 do begin
;		array=image_flat[l,20:naxis[1]-21,i]
;		sortarray=array[sort(array)]
;		sortarraycut=sortarray[cutstart2:cutend2]
;		meanclip_fast_nosigma,sortarraycut,skymde
		meanclip_fast_nosigma,image_flat[l,20:naxis[1]-21,i],skymde
;		mmm,reform(image_flat[l,20:naxis[1]-21,i]),skymde,sigma,skew
;		sky,reform(image_flat[l,20:naxis[1]-21,i]),skymde,sigma
;		skymde=median(image_flat[l,20:naxis[1]-21,i])
		sky[l]=skymde
		endfor
	for j=0,naxis[1]-1 do begin
		for k=0,naxis[0]-1 do begin
			image_sky[k,j,i]=image_flat[k,j,i]-sky[k]
		endfor
	endfor
tv,bytscl(image_sky[*,*,i],min=range[0],max=range[1])
;
; Interactive rejction
;
result=dialog_menu(['Yes','No'],title='Do you want to use this frame?')
if result EQ 'No' then image_mask[*,*,i]=0b
endfor

undefine,image_flat

print,'Shift'

xpos=FLTARR(nfiles) & ypos=FLTARR(nfiles) & FWHM=FLTARR(nfiles) & flux=fltarr(nfiles)
width=50
window,1,xsize=naxis[0],ysize=naxis[1]
window,2;,xsize=width*2+1,ysize=width*2+1
autorangeset,image_sky[*,*,0],range
range[0]=range[0]-0.1*(range[1]-range[0])
range[1]=range[1]+0.1*(range[1]-range[0])
;for i=0,nfiles-1,nframe_at_1pos do begin
ii=0
while ii LT nfiles-1 do begin
	wset,1
;	tv,bytscl(image_sky[*,*,i],min=range[0],max=range[1])
	tv,bytscl(image_sky[*,*,ii],min=range[0],max=range[1])
	CURSOR,tmp_x,tmp_y,/device
;	xpos[i:i+nframe_at_1pos-1]=tmp_x & ypos[i:i+nframe_at_1pos-1]=tmp_y
	xpos[ii:ii+step[ii]-1]=tmp_x & ypos[ii:ii+step[ii]-1]=tmp_y
;		for j=0,nframe_at_1pos-1 do begin
		for j=0,step[ii]-1 do begin
;			image3=image_sky[xpos[i+j]-width:xpos[i+j]+width,ypos[i+j]-width:ypos[i+j]+width,i+j]
			image3=image_sky[xpos[ii+j]-width:xpos[ii+j]+width,ypos[ii+j]-width:ypos[ii+j]+width,ii+j] > (-100)
			result=gauss2dfit(image3,a)
			WSET,2 & ERASE
			show3,image3

;			xpos[i+j]=a[4]-width+xpos[i+j]
;			ypos[i+j]=a[5]-width+ypos[i+j]
			xpos[ii+j]=a[4]-width+xpos[ii+j]
			ypos[ii+j]=a[5]-width+ypos[ii+j]
			FWHM[ii+j]=(a[2]+a[3])/2
			aper,image3,a[4],a[5],flux_tmp,errap,sky,skyerr,1,[fwhm[ii+j]*5],[fwhm[ii+j]*5,fwhm[ii+j]*8],[-100,30000],/flux,/silent
			flux[ii+j]=flux_tmp
			print,fwhm[ii+j],flux[ii+j]
		endfor
;endfor
ii=ii+step[ii]
endwhile
undefine,image3

window
plot,FWHM
window
plot,flux

print,'Mask operation'
;image_mask=bytarr(naxis[0],naxis[1],nfiles)
;maskfilename=DIALOG_PICKFILE(PATH='/data2/ohyama/MisawaQSO/',filter='*.lst')
;maskmake_circular,maskfilename,nfiles,image_mask
makemaskarray_auto,image_sky,image_mask
;image_mask_shift=bytarr(naxis[0],naxis[1],nfiles)
;;for i=0,nfiles-1 do image_mask_shift[*,*,i]=shift(image_mask[*,*,i],-(xpos[0]-xpos[i]),-(ypos[0]-ypos[i]))
;;makemaskarray_auto,image,image_mask
;image_mask_shift=image_mask
image_mask_shift2=bytarr(naxis[0],naxis[1],nfiles,/nozero)

;image_mask_shift2[*,*,0:nframe_at_1pos]=image_mask[*,*,nframe_at_1pos:nframe_at_1pos*2]
;for i=nframe_at_1pos,nfiles-1 do image_mask_shift2[*,*,i]=image_mask[*,*,i-nframe_at_1pos]
;image_mask_shift2[*,*,original]=image_mask[*,*,subtract]
for i=0,nfiles-1 do image_mask_shift2[*,*,original[i]]=image_mask[*,*,subtract[i]]
;image_mask_shift3=bytarr(naxis[0],naxis[1],nfiles)
;for i=0,nfiles-1 do image_mask_shift3[*,*,i]=shift(image_mask_shift2[*,*,i],xpos[0]-xpos[i],ypos[0]-ypos[i])

undefine,image_mask

mosaic_engine,image_sky,image_mask_shift2,outimage,-(xpos[*]-xpos[0]),-(ypos[*]-ypos[0])

imdisp,sigrange(outimage)

MWRFITS,outimage ,outfileName,header
;write_fits,outimage,header
do_nothing:
message,'Finish'

END
