pro bigimage,TRANSPOSE_COORDINATE=transpose_coordinate,SKYSUBFLAG=skysubflag,BIASSUBFLAG=biassubflag,OVERSCANFLAG=overscanflag,FLATFIELDFLAG=flatfieldflag,DISPLAYFLAG=displayflag,DISTCALIBFLAG=distcalibflag,OUTOFFOVZEROFLAG=outoffovzeroflag

if max([keyword_set(transpose_coordinate),keyword_set(skysubflag), keyword_set(biassubflag), keyword_set(overscanflag),keyword_set(flatfieldflag), keyword_set(displayflag), keyword_set(distcalibflag), keyword_set(outofFOVzeroflag)]) EQ 0 then begin

	result=dialog_checklist(['CCD Coordinate -> SKY Coordinate','Sky Subtraction','Bias Subtraction','Overscan Subtraction','Flat Fielding','Imdisp Images','Distortion Correction','Set Out Of FOV and Gap to Zero'],/nonexclusive,title='Select Image-processing Action(s)')

	if result[0] EQ 0 then transpose_coordinate = 0 else transpose_coordinate = 1
	if result[1] EQ 0 then skysubflag=0 else skysubflag=1
	if result[2] EQ 0 then biassubflag=0 else biassubflag=1
	if result[3] EQ 0 then overscanflag=0 else overscanflag=1
	if result[4] EQ 0 then flatfieldflag=0 else flatfieldflag=1
	if result[5] EQ 0 then displayflag=0 else displayflag=1
	if result[6] EQ 0 then distcalibflag=0 else distcalibflag=1
	if result[7] EQ 0 then outofFOVzeroflag=0 else outofFOVzeroflag=1
endif else begin
	IF (keyword_set(transpose_coordinate) EQ 0) THEN $
	   transpose_coordinate = 0
	IF (keyword_set(skysubflag) EQ 0) THEN $
	   skysubflag = 0
	IF (keyword_set(biassubflag) EQ 0) THEN $
	   biassubflag = 0
	IF (keyword_set(overscanflag) EQ 0) THEN $
	   overscanflag = 0
	IF (keyword_set(flatfieldflag) EQ 0) THEN $
	   flatfieldflag = 0
	IF (keyword_set(displayflag) EQ 0) THEN $
	   displayflag = 0
	IF (keyword_set(distcalibflag) EQ 0) THEN $
	   distcalibflag = 0
	IF (keyword_set(outofFOVzeroflag) EQ 0) THEN $
	   outofFOVzeroflag = 0
endelse

fitsindir=getenv("FOCASRED_FITS_IN")+'/'
if fitsindir EQ '/' then fitsindir=getenv('PWD')
fitsoutdir=getenv("FOCASRED_FITS_OUT")+'/'
if fitsoutdir EQ '/' then fitsoutdir=getenv('PWD')

common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

xoffset=100 & xend=1900 & yoffset=100 & yend=3900

fitsdir=strarr(3)
fitsdir[*]=fitsindir
outfitdir=fitsoutdir

files2=dialog_input(prompt=["Fits Dir","Chip 1 (no .fits)","Chip 2 (no .fits)"],nfield=3,initial=[fitsdir[0],'',''])

fitsdir=files2[0]

files=fitsdir+files2+'.fits'

retry:
if strlen(files2[1]) EQ 0 then begin
	fileName = DIALOG_PICKFILE (PATH=files2[0], FILTER = '*.fits',get_path=mygetpath,/multiple,title='Objects (Choose a pair of 2 images)')
	if(n_elements(filename) EQ 1) then begin
		print,'Choose 2 files'
		goto,retry
	endif
;	if(n_elements(filename) EQ 0) then message,'Cancel selected... Stop!'
endif

retry_b:
if biassubflag then biasName = DIALOG_PICKFILE (PATH=files2[0], FILTER = '*.fits',get_path=mygetpath,/multiple,title='Bias (Choose a pair of 2 images)')
	if(n_elements(biasname) EQ 1) then begin
		print,'Choose 2 files'
		goto,retry_b
	endif

retry_f:
if flatfieldflag then flatName = DIALOG_PICKFILE (PATH=files2[0], FILTER = '*.fits',get_path=mygetpath,/multiple,title='Flat (Choose a pair of 2 images)')
	if(n_elements(flatname) EQ 1) then begin
		print,'Choose 2 files'
		goto,retry_f
	endif

outfileName = DIALOG_PICKFILE (PATH=fitsoutdir, FILTER = '*.fits',title='Output File Name')
;	   IF (fileName NE '') THEN BEGIN
;	      d = FINDFILE (fileName, COUNT = fileExists)
;	      IF (fileExists EQ 0) THEN goto,do_nothing
;	endif


print,filename[0],filename[1]

image1=MRDFITS(filename[0],0,header1,/silent,/fscale)
image2=MRDFITS(filename[1],0,header2,/silent,/fscale)

name = SXPAR( header1 ,'OBJECT')
naxis= SXPAR( header1,'NAXIS*')



samplefac=get_samplefac(naxis[1])

if biassubflag then begin
	bimage1=MRDFITS(biasname[0],0,header3,/silent,/fscale)
	bimage2=MRDFITS(biasname[1],0,header3,/silent,/fscale)

	biassub_simple,image1,bimage1,image1_bs, 1,overscan
	biassub_simple,image2,bimage2,image2_bs, 2,overscan
endif else begin
	if overscanflag then begin
            bin= SXPAR( header1,'BIN-FCT*')
		suboverscan,image1,image1_bs,0,overscan,xbin=bin[0]
		suboverscan,image2,image2_bs,1,overscan,xbin=bin[0]
	endif else begin
		image1_bs=image1
		image2_bs=image2
	endelse
endelse

;image1=0
;image2=0

if flatfieldflag then begin
	fimage1=MRDFITS(flatname[0],0,header3,/silent,/fscale)
	fimage2=MRDFITS(flatname[1],0,header3,/silent,/fscale)

	flatnorm1=-1
	flatfield_simple,image1_bs,fimage1,bimage1,image1_ff,flatnorm1,1,overscan
	flatfield_simple,image2_bs,fimage2,bimage2,image2_ff,flatnorm1,2,overscan
endif else begin
	image1_ff=image1_bs
	image2_ff=image2_bs
endelse

;image1_bs=0
;image2_bs=0

if skysubflag then begin
	skysub_mmm,image1_ff,image1_ss
	skysub_mmm,image2_ff,image2_ss
endif else begin
	image1_ss=image1_ff
	image2_ss=image2_ff
endelse

;image1_ff=0
;image2_ff=0

if displayflag then begin
	WINDOW,0,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
	imdisp,sigrange(image1_ss[xoffset:xend-xoffset,yoffset:yend],fraction=0.999)
	WINDOW,1,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
	imdisp,sigrange(image2_ss[xoffset:xend-xoffset,yoffset:yend],fraction=0.999)
endif
;
; Combine 1 & 2
;

bin= SXPAR( header1,'BIN-FCT*')
combine_chip12,image1_ss,image2_ss,outbigimage,header1,DISTCALIBFLAG=distcalibflag,OUTOFFOVZEROFLAG=outoffovzeroflag
;image1_ss=0
;image2_ss=0

;
; Distcalib for bigimage
;
;if distcalibflag then distcalib_engine_big,outbigimage,outbigimage_dc $
chip = 2
if distcalibflag then distcalib_engine,outbigimage,outbigimage_dc,2,xbin=bin[0],ybin=bin[1] $; chip=2 means combined image
else outbigimage_dc=outbigimage
;
; Transpose image to set N to UP and E to Left
;
sxaddpar,header1,'CRPIX1',XRotatorCenter
sxaddpar,header1,'CRPIX2',YRotatorCenter

if transpose_coordinate then begin
;	bigimage=transpose(temporary(bigimage))
;	bigimage=rotate(temporary(bigimage),2)
;	bigimage=rotate(temporary(bigimage),6)
	hrotate, outbigimage_dc, header1,bigimagerot, header1_new,6,ERRMSG = errmsg
	print,errmsg
	outbigimage=bigimagerot
	header1=header1_new
end else begin
	outbigimage=outbigimage_dc
endelse

if displayflag then begin
	xoffset=20 & xend=3980 & yoffset=20 & yend=3980
	WINDOW,3,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
	imdisp,sigrange(outbigimage[xoffset:xend,yoffset:yend],fraction=0.999)
endif

MWRFITS,outbigimage ,OutfileName,header1
;write_fits,outbigimage,header1,dir=mygetpath;,myfilter='*.fits'

do_nothing:

end
