pro bestfocus_old,FITSDIR=fitsdir

	width=20 ; binning width

	xoffset=100
	xend=1900
	yoffset=100
	yend=3900

	samplefac=4

IF (N_ELEMENTS(fitsdir) EQ 0) THEN $
   fitsdir = '/data2/ohyama/FOCUSING'

	read_fits,image,header,DIR=fitsdir
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')
;
; image display after rebinning nicely
;
;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(NAXIS[0]/samplefac),FIX(NAXIS[1]/samplefac),image2

	WINDOW,0,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
	TV,BYTSCL(sigrange(image2[xoffset/samplefac:(xend-xoffset)/samplefac,yoffset/samplefac:yend/samplefac],fraction=0.999))

	CURSOR,xpos,ypos,/device
	xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset
	wait,1

	CURSOR,xpos2,ypos2,/device
	xpos2=xpos2*samplefac+xoffset & ypos2=ypos2*samplefac+yoffset

	image_cut=image[xpos:xpos2,ypos:ypos2]
	window,0,xsize=xpos2-xpos,ysize=ypos2-ypos
	imdisp,sigrange(image_cut),margin=0

	WINDOW,1,xsize=500,ysize=500,TITLE=name

nmeasure=dialog_input(prompt="How many exposure did you take?")

	width_x=FLTARR(nmeasure)
	width_y=FLTARR(nmeasure)
	sequence=FLTARR(nmeasure)


FOR i=0,nmeasure-1 do begin

	sequence[i]=i

	wset,0
	CURSOR,xpos,ypos,/device
;	xpos=xpos*(xpos2-xpos) & ypos=ypos*(ypos2-ypos)
;	xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset
	print,xpos,ypos

	image3=image_cut[xpos-width:xpos+width,ypos-width:ypos+width]
	result=gauss2dfit(image3,a)

	width_x[i]=a[2] & width_y[i]=a[3]
	print,'Center pos., FWHM (X, Y) =',a[4]-width+xpos,a[5]-width+ypos,width_x[i],width_y[i]

	WSET,1 & ERASE
	show3,image3

ENDFOR

;	i=i-1
;	x=FLTARR(i+1) & y=FLTARR(i+1) & t=FLTARR(i+1)
;	x=width_x[0:i]*2.355 & y=width_y[0:i]*2.355

	t=FIX(sequence/3)+1

	width_x=width_x*0.1*2.355
	width_y=width_y*0.1*2.355

	WINDOW,1,xsize=1000,ysize=1000
	plotmax=max(width_x)>max(width_y)
	plotmin=min(width_x)<min(width_y)

print,'solid line: X dir.; broken line: Y dir.'
	plot,t,width_x,yrange=[plotmin,plotmax],title="Point Source Size",xtitle="# of trial",ytitle="FWHM (arcsec)",psym=5
	oplot,t,width_y,psym=7

	result=poly_fit(t,width_x,2,fitx)
	result=poly_fit(t,width_y,2,fity)
	oplot,t,fitx,linestyle=0
	oplot,t,fity,linestyle=1

;	message,'Finish!'
do_nothing:

END
