pro bestfocus,FITSDIR=fitsdir

	width=20 ; binning width

	xoffset=100
	xend=1900
	yoffset=100
	yend=3900

;if checkfocana() then fitsdir='/data2/ohyama/FOCUSING/' else fitsdir='/data/o99004/'
fitsdir=getenv("FOCASRED_FITS_IN")+'/'
help,fitsdir
if fitsdir EQ '/' then fitsdir=getenv('PWD')

;IF (N_ELEMENTS(fitsdir) EQ 0) THEN $
;   fitsdir = '/data2/ohyama/FOCUSING'

	read_fits,image,header,DIR=fitsdir,mytitle='Telescope Focusing: Fits file input',myfilter='F*.fits'
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')
	samplefac=get_samplefac(naxis[1])

;
; image display after rebinning nicely
;
;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(NAXIS[0]/samplefac),FIX(NAXIS[1]/samplefac),image2

	WINDOW,0,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
	TV,BYTSCL(sigrange(image2[xoffset/samplefac:(xend-xoffset)/samplefac,yoffset/samplefac:yend/samplefac],fraction=0.999))

	CURSOR,xpos,ypos,/device
	xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset
	wait,0.5

	CURSOR,xpos2,ypos2,/device
	xpos2=xpos2*samplefac+xoffset & ypos2=ypos2*samplefac+yoffset

	image_cut=image[xpos:xpos2,ypos:ypos2]
	window,0,xsize=xpos2-xpos,ysize=ypos2-ypos
	imdisp,sigrange(image_cut),margin=0

	WINDOW,1,xsize=500,ysize=500,TITLE=name

;nmeasure=dialog_input(prompt="How many exposure did you take?")
nmeasure=21

print,'Click from lower-left to upper-right. Separate points are the last.'

	width_x=FLTARR(nmeasure)
	width_y=FLTARR(nmeasure)
	sequence=FLTARR(nmeasure)


FOR i=0,nmeasure-1 do begin

	sequence[i]=i
	wait,0.3
	wset,0
	CURSOR,xpos,ypos,/device
;	xpos=xpos*(xpos2-xpos) & ypos=ypos*(ypos2-ypos)
;	xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset
	print,xpos,ypos

	image3=image_cut[xpos-width:xpos+width,ypos-width:ypos+width]
	result=gauss2dfit(image3,a)

	width_x[i]=a[2]*0.1*2.355 & width_y[i]=a[3]*0.1*2.355
	print,'Center pos., FWHM (X, Y) =',a[4]-width+xpos,a[5]-width+ypos,width_x[i],width_y[i]

	WSET,1 & ERASE
	show3,image3

ENDFOR

;	i=i-1
;	x=FLTARR(i+1) & y=FLTARR(i+1) & t=FLTARR(i+1)
;	x=width_x[0:i]*2.355 & y=width_y[0:i]*2.355

	t=FIX(sequence/3)+1

;	width_x=width_x*0.1*2.355
;	width_y=width_y*0.1*2.355

	WINDOW,1,xsize=1000,ysize=1000
	plotmax=max(width_x)>max(width_y)
	plotmin=min(width_x)<min(width_y)

	plotmax=2.0
	plotmin=0

	range=dialog_input(prompt=["Z0","delta Z"],nfields=2,title='Input Focusing Parameter')
	z0=float(range[0]) & delta_z=float(range[1])
	z=(t-4)*delta_z+z0

	print,'solid line: X dir.; broken line: Y dir.'
	plot,z,width_x,yrange=[plotmin,plotmax],title="Point Source Size",xtitle="Telescope Z (mm)",ytitle="FWHM (arcsec)",psym=5
	oplot,z,width_y,psym=7

	result_x=robust_poly_fit(z,width_x,2,fitx)
	result_y=robust_poly_fit(z,width_y,2,fity)
	oplot,z,fitx,linestyle=0
	oplot,z,fity,linestyle=1

	z_min_x=-result_x[1]/result_x[2]/2
	z_min_y=-result_y[1]/result_y[2]/2
	z_min=(z_min_x+z_min_y)/2

;	z=(t_min-4)*delta_z+z0

	print,'Telescope Z=', z_min
	result=dialog_message(['Telescope Z= '+string(z_min)+' (mm)'],/information)

	message,'Finish!'
do_nothing:

END
