pro badcolumncor

common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan


fitsdir=getenv("FOCASRED_FITS_IN")+'/'
if fitsdir EQ '/' then fitsdir='./'
fitsoutdir=getenv("FOCASRED_FITS_OUT")+'/'
if fitsoutdir EQ '/' then fitsoutdir=getenv('PWD')
badlistdir=getenv("FOCASRED_DATA_IN")+'/'
if badlistdir EQ '/' then badlistdir=getenv('PWD')

filename=DIALOG_PICKFILE(PATH=fitsdir,filter='*.fits',title='Input FITS file names')
header=headfits(filename[0])
naxis=SXPAR( header,'NAXIS*')
nfiles=n_elements(filename)

outfilename=DIALOG_PICKFILE(PATH=fitsoutdir,filter='*.fits',title='Output FITS file name')

image=fltarr(naxis[0],naxis[1],/nozero)
image[*,*]=MRDFITS(filename,0,header,/silent,/fscale)

badpixlist=DIALOG_PICKFILE(PATH=badlistdir,filter='*.lst',title='Select a badpix list')
IF(STRLEN(badpixlist) EQ 0) THEN goto,do_nothing

maskmake2d,badpixlist,image,naxis,mask
;maskmake_outoffovzero,badpixlist,nfiles,naxis,mask

outimage = maskinterp(image,mask,1,6,"chebyshfit") 

;write_fits,outimage,header
MWRFITS,outimage ,outfileName,header

;message,'Finish'
do_nothing:
END
