pro autorangeset,image,range

s=size(image)
manualflag=0

maxx=s(1)
maxy=s(2)

samplefac=get_samplefac(maxy)

xoffset=0;50
xend=maxx-1;-50
yoffset=0;50
yend=maxy-1;-50

expand,image,FIX(maxx/samplefac),FIX(maxy/samplefac),image2
WINDOW,/free,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE='Intensity Change'
retry:
if manualflag then imdisp,bytscl(image2[xoffset/samplefac:xend/samplefac-1,yoffset/samplefac:yend/samplefac-1],min=range[0],max=range[1]),margin=0 $
else imdisp,sigrange(image2[xoffset/samplefac:xend/samplefac-1,yoffset/samplefac:yend/samplefac-1],fraction=0.99,range=range),margin=0

flag=dialog_message('Are you satisfied with this range of plot?',/question)
;flag = DIALOG_MENU (['Yes','No'], TITLE = 'Are you satisfied with this range of plot?')
	CASE flag OF
		'No': begin
				range=dialog_input(prompt=["MIN","MAX"],nfields=2,initial=range)
				manualflag=1
				goto,retry
			end
		'Yes': goto,ok
	ENDCASE

ok:

wdelete,!D.WINDOW

END
