PRO TILT

	linewidth=3
	samplefac=4; 2 for DAO; 6 for FOCAS
;;;
;;; main program
;;;
	nfilename=DIALOG_PICKFILE(PATH='~/FOCAS/NHALT',filter='*.fits',/MULTIPLE_FILES)
	IF(STRLEN(nfilename[0]) EQ 0) THEN stop
	nfiles=size(nfilename,/N_ELEMENTS)
;
; read main image array
;
	image= MRDFITS(nfilename[0], 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')
;
; read ascii extension
;
;	asciiext= MRDFITS(nfilename[0], 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;
	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE='Image'
	WINDOW,1,xsize=1000,ysize=500,TITLE='Spectral Plot'

pos=FLTARR(10)
dif=FLTARR(5)
sequence=FLTARR(10)
ccdpos=FLTARR(5,2)

FOR j=0,4 DO BEGIN

	sequence[j]=j

	image= MRDFITS(nfilename[0], 0, header)
        xmin=100 & xmax=naxis[0]-xmin & ymin=100 & ymax = naxis[1]-ymin
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)
        naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1

	naxis= SXPAR( header,'NAXIS*')
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WSET,0 & ERASE
	TV,BYTSCL(sigrange(image2,fraction=0.995))

	CURSOR,xcutstart,ycutstart,3,/device
	xcutstart=xcutstart*samplefac & ycutstart=ycutstart*samplefac
	CURSOR,xcutend,ycutend,3,/device
	xcutend=xcutend*samplefac & ycutend=ycutend*samplefac
	image3=image[xcutstart:xcutend,ycutstart:ycutend]

	TV,BYTSCL(sigrange(image3,fraction=0.999)),/device

	X=FLTARR(ycutend-ycutstart+1) & Y=FLTARR(ycutend-ycutstart+1)
	FOR i=0,ycutend-ycutstart do X[i]=i
	Y=total(image3,1)

	WSET,1
	PLOT,X,Y,/ynozero
	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=YY-MIN(YY) & YY=YY/MAX(YY)
	PLOT,XX,YY,/ynozero

	estpos=XX ## transpose(YY/total(YY))
        est=[1,estpos,linewidth,0]
        result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	OPLOT,XX,result,PSYM=10

	pos[j]=coef[1]
	print,pos[j]
;
; 2nd image
;
	print,nfilename[1]
	image= MRDFITS(nfilename[1], 0)
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)

	image3=image[xcutstart:xcutend,ycutstart:ycutend]
	WSET,0
	TV,BYTSCL(sigrange(image3,fraction=0.975))

	X=FLTARR(ycutend-ycutstart+1) & Y=FLTARR(ycutend-ycutstart+1)
	FOR i=0,ycutend-ycutstart do X[i]=i
	Y=total(image3,1)

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	WSET,1
	PLOT,XX,YY,/ynozero

	estpos = XX ## transpose(YY/total(YY))
        est=[1,estpos,linewidth,0]
        result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	OPLOT,XX,result,PSYM=10

	ccdpos[j,0]=(xcutstart+xcutend)/2
	ccdpos[j,1]=(ycutstart+ycutend)/2

	pos[j+1]=coef[1]
	print,pos[j+1]

	dif[j]=pos[j]-pos[j+1]
	print,'Pos1, Pos2, Dif = ',pos[j],pos[j+1],dif[j]

ENDFOR

	result=DIALOG_PLOT2(XDATA=sequence,YDATA=dif,/YNOZERO,EXECUTE=[$
	'PLOT, XDATA,YDATA,/YNOZERO',$
	'OPLOT,XDATA,YDATA,psym=2'],$
	XTITLE='Sequence',YTITLE='Focus Offset',Title='Haltman Test',$
	/PS_OPTION,/ASCII_DUMP_OPTION)

message,'Finish!'

scale3,xrange=[0,2000],yrange=[0,4000],zrange=[-5,5]
plots,ccdpos[*,0],ccdpos[*,1],dif,/data


message,'Finish!'
FINISH:
END
