PRO SCATTER

; pick one file
; measure pos, FWHM, etc, at various positions
; analysis and plot
;
; Useful for GRISM ALIGNMENT & SLIT TILT
;
	nsum=10
	delay=0.0
;;;
;;; main program
;;;
	filename=DIALOG_PICKFILE(PATH='~/m3',filter='*.fits')
	IF(STRLEN(filename) EQ 0) THEN stop
;
; read main image array
;
	image= MRDFITS(filename, 0, header)

	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

	samplefac0=get_screen_size()
	samplefac=naxis[1]/samplefac0[1]

	xmin=100 & xmax=naxis[0]-xmin & ymin=100 & ymax = naxis[1]-ymin
	image=image-MIN(image)
	image=trim(image,xmin,xmax,ymin,ymax)
	naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1
;
; read ascii extension
;
;	asciiext= MRDFITS(filename, 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;
;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	print,naxis
	expand,image,FIX((xmax-xmin+1)/samplefac),FIX((ymax-ymin+1)/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(sigrange(image2,fraction=0.95)),/device

	result=dialog_menu(['Space','Wavelength'],TITLE='Scan Direction?')
	CASE result OF
		'Space': BEGIN
			END
		'Wavelength': BEGIN
			image=rotate(image,1); rotate 90 deg clockwise
			image2=rotate(image2,1)
			temp=naxis[0]
			naxis[0]=naxis[1]
			naxis[1]=temp
			END
	ENDCASE

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(sigrange(image2,fraction=0.95)),/device

	CURSOR,line,column,/device
	line=line*samplefac & column=column*samplefac
	startx=FIX(line)

	wait,0.5

	CURSOR,line,column,/device
	line=line*samplefac & column=column*samplefac
	endx=FIX(line)

	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 do begin
		X[i]=i
;		Y[i]=image(startx,i)
                Y[i]=total(image(FIX(startx)-FIX(nsum/2):FIX(startx)+FIX(nsum/2),i),1)

	ENDFOR

	ERASE
	WINDOW,0,xsize=500,ysize=300,TITLE='Select a Line (CLICK 2 times)'
	PLOT,X,Y,/ynozero

	print,'Find sky region'
	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	skystarty=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	skyendy=FIX(XY[0])
	skywidth=abs(skystarty-skyendy)

	print,'Find object region'
	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])
	PRINT,Xnew,X2new
	objwidth=abs(X2new-Xnew)
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center (top)'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0] & y1=XY[1]
	PRINT,'Click FWHM (left)'
	CURSOR,x1,tmp,3,/device
	XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
	x1=XY[0]
	PRINT,'Click FWHM (right)'
	CURSOR,x2,tmp,3,/device
	XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
	x2=XY[0]
	
	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result

	skyoffset=FIX(abs(skyendy-coef[1]))
;	print,'skyoffset=',skyoffset

;;;
;;; peak tracing
;;;

	colnum=dialog_slider([1,FIX(abs(startx-endx+1)/10)],prompt='# of tracing points?')

	step=FIX((endx-startx+1)/(colnum+1))
	num=FIX((endx-startx+1)/step)+1

;	print,startx,endx,colnum,step,num

	ypos=FLTARR(num)
	xpos=FLTARR(num)
	skew=FLTARR(num)
	kurt=FLTARR(num)
	FWHM=FLTARR(num)
	flux=FLTARR(num)
	amp=FLTARR(num)

i=0
FOR column=startx,endx,step DO BEGIN

	FOR k=0,naxis[1]-1 do begin
		X[k]=k
		Y[k]=image(column,k)
	ENDFOR

	Xnew=FIX(coef[1]-objwidth/2)
	X2new=FIX(coef[1]+objwidth/2)

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	statresult=moment(YY[1:10])
	thresh=statresult(1)*20
	IF abs(MAX(YY)-MIN(YY)) LT thresh then begin
		print,'SKIP'		
		goto,SKIP
	ENDIF

	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	PLOT,XX,YY,/YNOZERO

	est=[1,coef[1],coef[2],0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
;	PRINT,'#',i,column,': Amp., Cen., FWHM, Cont', coef

	RESY=YY-result
	PLOT,XX,RESY

	SCATIMAGE=	
WAIT,delay

	xpos[i]=column
	amp[i]=coef[0]
	ypos[i]=coef[1]
	FWHM[i]=coef[2]*2.355
;	skew[i]=skewness(YY)
;	kurt[i]=kurtosis(YY)

;	skyflux=0
;	for j=FIX(ypos[i]-skyoffset-skywidth/2),FIX(ypos[i]-skyoffset+skywidth/2) do begin
;	skyflux=skyflux+Y[j]
;	endfor

;	skyflux=skyflux/skywidth

;	for j=FIX(ypos[i]-objwidth/2),FIX(ypos[i]+objwidth/2) do begin
;	flux[i]=flux[i]+Y[j]-skyflux
;	endfor

	i=i+1

SKIP:

ENDFOR ; column loop

id=where(ypos gt 0)

fit_result=POLY_FIT(xpos[id],ypos[id],1,fit)
;PLOT, xpos,ypos,/YNOZERO
;OPLOT,xpos,fit,psym=2

dx=abs(startx-endx)
dy=fit_result[1]*dx
rotangle=ATAN(dy/dx)*180/3.1415926535
print,'Rotation angle =',rotangle,' deg'

;WINDOW,0,xsize=1024,ysize=512,TITLE=''

REPEAT BEGIN
flag = DIALOG_MENU (['TRACE','AMP','FLUX','FWHM','SKEW','KURT','END'], TITLE = 'Analysis Result')
	CASE flag OF

	'TRACE': BEGIN
		result=DIALOG_PLOT2(XDATA=xpos[id],YDATA=ypos[id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Peak Position',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)

		print,'Rotation angle =',rotangle,' deg'
	END

	'AMP': BEGIN
	result=DIALOG_PLOT2(XDATA=xpos[id],YDATA=amp[id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Amplitude',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'FLUX': BEGIN
	result=DIALOG_PLOT2(XDATA=xpos[id],YDATA=flux[id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Flux',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'FWHM': BEGIN
	result=DIALOG_PLOT2(XDATA=xpos[id],YDATA=FWHM[id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Width (FWHM)',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'SKEW': BEGIN
	result=DIALOG_PLOT2(XDATA=xpos[id],YDATA=skew[id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Skewness',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'KURT': BEGIN
	result=DIALOG_PLOT2(XDATA=xpos[id],YDATA=kurt[id],/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Kurtosis',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END


	'END': BEGIN & END ; do nothing
	''   : BEGIN & END ; do nothing

	ENDCASE

ENDREP UNTIL ((flag EQ 'END') OR (flag EQ ''))

FINISH:
END
