PRO PSF

	samplefac=4
	width=40

	X_inc = 30/3.3324226; 30 mm per aperture * focus ratio
	Y_inc = 30/3.3324226;
	pix_inc=0.015; mm/pix

;;;
;;; main program
;;;
	filename=DIALOG_PICKFILE(PATH='~/IDL/FITS',filter='*.fits')
	IF(STRLEN(filename) EQ 0) THEN stop
;
; read main image array
;
	image= MRDFITS(filename, 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

; image display after rebinning nicely
;
;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

xoffset=100
xend=1900
yoffset=100
yend=3900

X_obs=FLTARR(20)
Y_obs=FLTARR(20)
X_pos=FLTARR(20)
Y_pos=FLTARR(20)
delta_X=FLTARR(20)
delta_Y=FLTARR(20)


	WINDOW,0,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
	TV,BYTSCL(sigrange(image2[xoffset/samplefac:xend/samplefac,yoffset/samplefac:yend/samplefac],fraction=0.999))
	WINDOW,1,xsize=500,ysize=500,TITLE=name

	wset,0
	CURSOR,xpos,ypos,/device
	xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset

	image3=image[xpos-width:xpos+width,ypos-width:ypos+width]
	result=gauss2dfit(image3,a)

	X0=a[4]-width+xpos & Y0=a[5]-width+ypos

	X_obs[0]=a[2] & Y_obs[0]=a[3]

	X_pos_id=0
	Y_pos_id=0

	X_pos[0]=(X_pos_id*X_inc/pix_inc+X0); in units of pixel
	Y_pos[0]=(Y_pos_id*Y_inc/pix_inc+Y0)

	delta_X[0]=0
	delta_Y[0]=0

	WSET,1 & ERASE
	show3,image3

	print,"This is the Origin."

i=1

STEP1:

	wset,0
	wait,1
	CURSOR,xpos,ypos,/device
	xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset

	image3=image[xpos-width:xpos+width,ypos-width:ypos+width]
	result=gauss2dfit(image3,a)

	WSET,1 & ERASE
	show3,image3

	X_obs[i]=a[2] & Y_obs[i]=a[3]

	X_pos_id=dialog_input(prompt="Input X Inc.",CANCEL="Finish")
	if X_pos_id eq "" then goto,step2
	Y_pos_id=dialog_input(prompt="Input Y Inc.")

	X_pos[i]=(X_pos_id*X_inc/pix_inc+X0); in units of pixel
	Y_pos[i]=(Y_pos_id*Y_inc/pix_inc+Y0)

	delta_X[i]=X_obs[i]-X_obs[0]
	delta_Y[i]=Y_obs[i]-Y_obs[0]

	print,"X pos, Y pos, X obs, Y obs, delta X, delta Y",X_pos[i],Y_pos[i],X_obs[i],Y_obs[i],delta_X[i],delta_Y[i]

	i=i+1

	goto,STEP1

STEP2:

	print,"This is STEP2"

	WINDOW,2,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
	wset,2
	partvelvec,delta_X,delta_Y,X_pos,Y_pos,[xoffset,xend],[yoffset,yend]

	message,'Finish!'

END
