PRO PICKSTAR

	samplefac=4; 2 for DAO
	width=15
;;;
;;; main program
;;;
	filename=DIALOG_PICKFILE(PATH='~/FOCUS',filter='*.fits')
	IF(STRLEN(filename) EQ 0) THEN stop
;
; read main image array
;
	image= MRDFITS(filename, 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')
;
; read ascii extension
;
;	asciiext= MRDFITS(filename, 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;
;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

xoffset=00
xend=1500
yoffset=1500
yend=2500

	WINDOW,0,xsize=FIX((xend-xoffset)/samplefac),ysize=FIX((yend-yoffset)/samplefac),TITLE=name
	TV,BYTSCL(sigrange(image2[xoffset/samplefac:1500/samplefac,yoffset/samplefac:yend/samplefac],fraction=0.99))
	WINDOW,1,xsize=FIX((naxis[0]-xoffset)/samplefac),ysize=FIX((naxis[1]-yoffset)/samplefac),TITLE=name

JUMP1:
	WSET,0 & ERASE
	TV,BYTSCL(sigrange(image2[xoffset/samplefac:1500/samplefac,yoffset/samplefac:yend/samplefac],fraction=0.99))

	CURSOR,xpos,ypos,/device
	xpos=xpos*samplefac+xoffset & ypos=ypos*samplefac+yoffset

	image3=image[xpos-width:xpos+width,ypos-width:ypos+width]
	result=gauss2dfit(image3,a)

	print,'Center pos., X- & Y-width =',a[4]-width+xpos,a[5]-width+ypos,a[2],a[3]

	WSET,1 & ERASE
	show3,image3

GOTO,JUMP1

	message,'Finish!'

END
