PRO fspecred_qlook

samplefac=3
;
; Data Read
;
if checkfocana() then localdir='/home/falcon/FITS/' else localdir='/data/o99004/'

read_fits,image,header,dir=localdir,mytitle='Select a FILE',myfilter='*fits'

name = SXPAR( header ,'OBJECT')
naxis= SXPAR( header,'NAXIS*')
bin= SXPAR( header,'BIN-FCT*')
;
; Overscan subtraction
;
suboverscan,image,image_os,overscan,xbin=bin[0]
;
; Trimming
;
WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
imdisp,sigrange(image_os),margin=0
CURSOR,line,column,/normal
startx=line*naxis[0] & starty=column*naxis[1]
wait,1
CURSOR,line,column,/normal
endx=line*naxis[0] & endy=column*naxis[1]

s=size(image)
maxx=s(1) & maxy=s(2)
;
; CR removeal
;
image_cr=point_remover(image_os[startx:endx,starty:endy],5,7,10);was 5,10,3; was 5,7,5
;
; Sky sub
;
skysub,image_cr,image_ss

window,0,ysize=1000,xsize=(endx-startx+1)
imdisp,sigrange(image_ss)

write_fits,image_ss,header,dir=localdir

message,'Finish'
;FINISH:

END
