PRO fspecred_qlook

;
; Data Read
;
if checkfocana() then begin
	localdir='/home/falcon/FITS/'
	outdir='/data2/ohyama/'
endif else begin
	localdir='/data/o99004/'
	outdir='/work/o99004/'
endelse

result=dialog_checklist(['Distortion Correction'],/nonexclusive,title='Select Image-processing Action(s)')

if result[0] EQ 1 then DISTORTIONFLAG=1 else DISTORTIONFLAG=0

CRREMOVEFLAG=1
SUBOVERSCANFLAG=0
FLUXCONSERVEFLAG=0
CONVOLVEFLAG=0

read_fits,image,header,dir=localdir,mytitle='Select a FILE',myfilter='F*fits'

name = SXPAR( header ,'OBJECT')
naxis= SXPAR( header,'NAXIS*')
bin= SXPAR( header,'BIN-FCT*')

samplefac=2/(2/bin[1])

;
; Overscan subtraction
;
suboverscan,image,image_os,overscan,xbin=bin[0]
;
; Trimming
;
autorangeset,image_os,range
WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
imdisp,bytscl(image_os,min=range[0],max=range[1]),margin=0
;imdisp,sigrange(image_os),margin=0
CURSOR,line,column,/normal
startx=line*naxis[0] & starty=column*naxis[1]
wait,1
CURSOR,line,column,/normal
endx=line*naxis[0] & endy=column*naxis[1]

s=size(image)
maxx=s(1) & maxy=s(2)
;
; CR removeal
;
if CRREMOVEFLAG then $
image_cr=point_remover(image_os[startx:endx,starty:endy],1,7,10) $
else image_cr=image_os[startx:endx,starty:endy]
;
; Distortion Correction
;
;if DISTCALIBFLAG then begin
;distcalib_engine,  image_cr,    image_dc    ,chip,xstart=FIX(startx),xend=FIX(endx),ystart=FIX(starty),yend=FIX(endy),xbin=bin[0],ybin=bin[1],SUBOVERSCANFLAG=suboverscanflag,FLUXCONSERVEFLAG=fluxconservflag,CONVOLVEFLAG=convolveflag 
;endif else begin
image_dc=image_cr
;endelse
;
; Sky sub
;
skysub,image_dc,image_ss
;
; Display
;
window,0,ysize=1000,xsize=(endx-startx+1)
imdisp,sigrange(image_ss)

write_fits,image_ss,header,dir=outdir

message,'Finish'
;FINISH:

END
