PRO fspecred_dash,flatimagefile,compimagefile,imagefile,outimagefile

samplefac=2

result=dialog_checklist(['Grism Rotation'],/nonexclusive,title='Select Image-processing Action(s)')
if result[0] EQ 1 then GRISMROTFLAG = 1 else GRISMROTFLAG = 0

read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan
;
; Data Read
;
localdir='/data2/ohyama/NGC253/'

LOGGER = OBJ_NEW ('widget_LOGGER', MAP = 0, TITLE = 'FSPECRED LOG')
LOGGER->setClearButton, 'Clear Log Text'
LOGGER->show

LOGGER->append, ['FLAT.fits data read']
;read_fits,flatimage,header,dir=localdir,mytitle='FLAT',myfilter='*.fits',mygetpath=workdir; dirr='/export/scr/home/falcon/FITS'
flatimage=MRDFITS(flatimagefile,0,header,/silent,/fscale)
LOGGER->append, ['COMP.fits data read']
;read_fits,compimage,header,mytitle='Comparison',myfilter='*.fits',dir=workdir; dirr='/export/scr/home/falcon/FITS'
compimage=MRDFITS(compimagefile,0,header,/silent,/fscale)
LOGGER->append, ['OBJECT.fits data read']
image=MRDFITS(imagefile,0,header,/silent,/fscale)
;read_fits,image,header,dir=workdir,mytitle='object',myfilter='*fits'
name = SXPAR( header ,'OBJECT')
naxis= SXPAR( header,'NAXIS*')
bin= SXPAR( header,'BIN-FCT*')
det_id= SXPAR( header,'DET-ID')
;chip=0 mean chip=1; chhip=2 mean chip2
if det_id EQ 1 then chip=0 else chip=1
samplefac=samplefac/bin[1]*2
;
; Overscan subtraction
;
LOGGER->append, ['Overscan subtraction']
suboverscan,image,image_os,overscan,xbin=bin[0]
suboverscan,flatimage,flatimage_os,overscan,xbin=bin[0]
suboverscan,compimage,compimage_os,overscan,xbin=bin[0]
;
; Trimming
;
LOGGER->append, ['Data trimming']
WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
imdisp,sigrange(image_os),margin=0
LOGGER->append, ['	Click lower-left and upper-right edges of your interest region.']
CURSOR,line,column,/normal
startx=line*naxis[0] & starty=column*naxis[1]
wait,1
CURSOR,line,column,/normal
endx=line*naxis[0] & endy=column*naxis[1]

;starty=0
;endy=naxis[1]-1
;beta=0.29958085*0.997
mag=0.015/beta
;gapsize=69.0920+2.0
;Y_shift=-0.50805068-2.0

;xFOVcenter=1995.3449
;yFOVcenter=2044.3084

xFOVcenter=xDISTcenter
yFOVcenter=yDISTcenter

if chip EQ 0 then begin; chip=0 means chip1
	X_CEN=xFOVcenter-2047-gapsize;-96
	Y_CEN=yFOVcenter;2003
endif else begin
	X_CEN=xFOVcenter;2022
	Y_CEN=yFOVcenter-y_shift;2006
endelse

s=size(image)
maxx=s(1) & maxy=s(2)

disttransform_inv,startx*BIN[0],X_CEN,starty*BIN[1],Y_CEN,startx_trans,starty_trans,mag,maxx*bin[0],maxy*bin[1],coef
disttransform_inv,endx*BIN[0],X_CEN,endy*BIN[1],Y_CEN,endx_trans,endy_trans,mag,maxx*bin[0],maxy*bin[1],coef

;print,startx_trans/bin[0],endx_trans/bin[0],starty_trans/bin[1],endy_trans/bin[1]
;print,startx,endx,starty,endy

startx=startx_trans/bin[0] & starty=starty_trans/bin[1]
endx=endx_trans/bin[0] & endy=endy_trans/bin[1]


image_tr=trim(image_os,startx,endx,starty,endy)
flatimage_tr=trim(flatimage_os,startx,endx,starty,endy)
compimage_tr=trim(compimage_os,startx,endx,starty,endy)

gap=206*3/bin[0]
startx_gap=gap-20
endx_gap=gap+20

image_gap_tr=trim(image_os,startx_gap,endx_gap,starty,endy)
flatimage_gap_tr=trim(flatimage_os,startx_gap,endx_gap,starty,endy)
compimage_gap_tr=trim(compimage_os,startx_gap,endx_gap,starty,endy)

window,xsize=1000,ysize=1000
!P.MULTI=[0,3,1]
imdisp,sigrange(image_tr)
imdisp,sigrange(flatimage_tr)
imdisp,sigrange(compimage_tr)
!P.MULTI=0
;
; Make flatfield images
;
LOGGER->append, ['Flat fielding']
;was _tr, gap_tr
specflat_engine,flatimage_tr,flatimage_os,flatimage_gap_tr,flatimage_os,chip,ptpimage,flatpattern,xstart=FIX(startx),xend=FIX(endx),ystart=FIX(starty),yend=FIX(endy),xbin=bin[0],ybin=bin[1],GRISMROTFLAG=grismrotflag
;
; PTP flatfield
;
image_ptp=image_os/ptpimage
compimage_ptp=compimage_os/ptpimage
;
; CR removeal
;
LOGGER->append, ['Cosmic Ray Removal','	3 iterative procedure. Please wait.']
image_cr=point_remover(image_ptp,5,10,3);was 5,10,3; was 5,7,5
;image_cr=image_ptp
;
; Distortion correction
;
suboverscanflag=0 & fluxconserveflag=0 & convolveflag=0
LOGGER->append, ['Object Distortion Correction']
distcalib_engine,  image_cr,    image_dc    ,chip,xstart=FIX(startx),xend=FIX(endx),ystart=FIX(starty),yend=FIX(endy),xbin=bin[0],ybin=bin[1],SUBOVERSCANFLAG=suboverscanflag,FLUXCONSERVEFLAG=fluxconservflag,CONVOLVEFLAG=convolveflag
;distcalib_engine,  image_gap_tr,image_gap_dc,chip,xstart=FIX(startx_gap),xend=FIX(endx_gap),ystart=FIX(starty),yend=FIX(endy),xbin=bin[0],ybin=bin[1],SUBOVERSCANFLAG=suboverscanflag,FLUXCONSERVEFLAG=fluxconservflag,CONVOLVEFLAG=convolveflag
LOGGER->append, ['Comparison Distortion Correction']
distcalib_engine,compimage_ptp,compimage_dc   ,chip,xstart=FIX(startx),xend=FIX(endx),ystart=FIX(starty),yend=FIX(endy),xbin=bin[0],ybin=bin[1],SUBOVERSCANFLAG=suboverscanflag,FLUXCONSERVEFLAG=fluxconservflag,CONVOLVEFLAG=convolveflag
;
; Grism rotation
;
if GRISMROTFLAG then begin
	; was compimage_gap_tr
	distcalib_engine,compimage_os,compimage_gap_dc,chip,xstart=FIX(startx_gap),xend=FIX(endx_gap),ystart=FIX(starty),yend=FIX(endy),xbin=bin[0],ybin=bin[1],SUBOVERSCANFLAG=suboverscanflag,FLUXCONSERVEFLAG=fluxconservflag,CONVOLVEFLAG=convolveflag
	LOGGER->append, ['Grism rotation']
	LOGGER->append, ['	Object']
	grismrot,image_dc,compimage_gap_dc,image_rot,bin
	LOGGER->append, ['	Comparison']
	grismrot,compimage_dc,compimage_gap_dc,compimage_rot,bin
end else begin
	image_rot=image_dc
	compimage_rot=compimage_dc
endelse
;
; Slit pattern measurement
;
LOGGER->append, ['Slit pattern shift calculation']
get_slitpattern,compimage_rot[*,FIX((endy-starty+1.)/5.):FIX((endy-starty+1.)*4./5.)],comppattern,medianmod=1

plot,comppattern,yrange=[0.95,1.05]
oplot,flatpattern

calc_optimum_slit,flatpattern,comppattern,slitpattern
;
; Slit pattern correction
;
LOGGER->append, ['Slit pattern correction']
image_slt=image_tr
for i=0,n_elements(image_tr[1,*])-1 do image_slt[*,i]=image_rot[*,i]/slitpattern
;
; Output data
;
goto,jump1
LOGGER->append, ['Write OBJECT_CORRECTED.fits']
write_fits,image_slt,header,dir=workdir
LOGGER->append, ['Write COMPARISON_CORRECTED.fits']
write_fits,compimage_dc,header,dir=workdir
LOGGER->append, ['End of this procedure. Use IRAF for identify -> transform.']
message,'Use IRAF for identify -> transform'
;
; Sky sub
;
read_fits,image_slt,header,dir=workdir

skysub,image_slt,image_ss

window,0,ysize=1000,xsize=(endx-startx+1)
imdisp,sigrange(image_ss)

jump1:
;write_fits,image_ss,header,dir=localdir
MWRFITS,image_slt ,outimagefile,header

OBJ_DESTROY, LOGGER

;message,'Finish'
;FINISH:

END
