PRO distcalib_engine_big,image,convoutimage,XSTART=xstart,XEND=xend,YSTART=ystart,YEND=yend,XBIN=xbin,YBIN=ybin,SUBOVERSCANFLAG=suboverscanflag,FLUXCONSERVEFLAG=fluxconserveflag,CONVOLVEFLAG=convolveflag
;
; region in binned ccd pixel numbers
;
IF (not keyword_set(suboverscanflag)) THEN suboverscanflag = 0
IF (not keyword_set(fluxconserveflag)) THEN fluxconserveflag = 0
IF (not keyword_set(convolveflag)) THEN convolveflag = 0

;read_focaspar,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv
common focaspars,Y_shift,gapsize,difrot,beta,XDistCenter,YDistCenter, XMaskCenter,YMaskCenter,XMaskRotCenter,YMaskRotCenter,XRotatorCenter,YRotatorCenter,mos_rot,coef,coef_inv,overscan

mag=0.015/beta
;;;
;;; main program
;;;
s=size(image)
naxis=intarr(2)
naxis[0]=s[1]
naxis[1]=s[2]

if suboverscanflag EQ 1 then begin
	suboverscan,image,osimage,chip+1,overscan
	image=osimage
	undefine,osimage
endif else begin
	endelse

xFOVcenter=xDISTcenter
yFOVcenter=yDISTcenter

X_cen=XdistCenter
Y_cen=YdistCenter

;if chip EQ 0 then begin; chip=0 means chip1
;	X_CEN=xFOVcenter-2047-gapsize-overscan*2; was 75*2; 75 correct the overscan
;	Y_CEN=yFOVcenter;2003
;endif else begin
;	X_CEN=xFOVcenter;2022
;	Y_CEN=yFOVcenter-y_shift;2006
;endelse

if not keyword_set(xstart) then xstart=0
if not keyword_set(xend) then xend=naxis[0]-1
if not keyword_set(ystart) then ystart=0
if not keyword_set(yend) then yend=naxis[1]-1

outimage=fltarr(xend-xstart+1,yend-ystart+1)

if not keyword_set(XBIN) then XBIN=1
if not keyword_set(YBIN) then YBIN=1

xdim=(naxis[0]+xstart-1)*XBIN
ydim=(naxis[1]+ystart-1)*YBIN
xmin=xstart*XBIN
ymin=ystart*YBIN

xdim=naxis[0]*XBIN
ydim=naxis[1]*YBIN
xmin=0
ymin=0

;print,xstart,xend,ystart,yend,xbin,ybin,chip

newtransx=FLTARR(xend-xstart+1);(xend+1)
newtransy=FLTARR(xend-xstart+1);(xend+1)

Y_NEW=0; float(ystart)
for jj=0,xend-xstart do begin
;	X_NEW=jj; was float(jj)
	disttransform,(jj+xstart+0.5)*XBIN  ,X_CEN,(Y_NEW+ystart+0.5)*YBIN  ,Y_CEN,TransX4,TransY4,mag,xdim,ydim,xmin,ymin,coef_inv;,naxis[0],naxis[1],coef_inv
;	if TransX4 GT naxis[0]-2 then TransX4=naxis[0]-2
;	if TransX4 LT 0 then TransX4=0
	newtransx[jj]=TransX4/XBIN;-xstart
	newtransy[jj]=TransY4/YBIN;-ystart

;	print,jj,(jj+xstart+0.5)*XBIN,(Y_NEW+ystart+0.5)*YBIN,TransX4,TransY4,TransX4/XBIN-xstart,TransY4/YBIN-ystart

endfor

oldtransx=newtransx
oldtransy=newtransy

progress = OBJ_NEW ('widget_progress', CANCEL_LABEL = 'Interrupt',title='Distorion Calibration Progress')

for i=0,yend-ystart do begin

         fraction = float(i) / float(yend-ystart+1)
         progress->update, fraction
         IF (progress->cancel ()) THEN $
            GOTO, done

;	Y_NEW=i & X_NEW=xstart; was float (i), float(xstart)
	Y_NEW_05=i+0.5; was Y_NEW
	disttransform,(xstart-0.5)*XBIN  ,X_CEN,(i+ystart-0.5)*YBIN  ,Y_CEN,jj11,ii11,mag,xdim,ydim,xmin,ymin,coef_inv;,naxis[0],naxis[1],coef_inv
	disttransform,(xstart-0.5)*XBIN  ,X_CEN,(i+ystart+0.5)*YBIN  ,Y_CEN,jj33,ii33,mag,xdim,ydim,xmin,ymin,coef_inv;,naxis[0],naxis[1],coef_inv

;	TransX2=TransX1 & TransX4=TransX3
;	TransY2=TransY1 & TransY4=TransY3

;	jj11=TransX1 & ii11=TransY1
	jj11=jj11/XBIN;-xstart
	ii11=ii11/YBIN;-ystart
	jj22=jj11 & ii22=ii11; was TransX2 TransY2
;	jj33=TransX3 & ii33=TransY3
	jj33=jj33/XBIN;-xstart
	ii33=ii33/YBIN;-ystart
	jj44=jj33 & ii44=ii33; was TransX4 TransY4

	jj111=round(jj11) & ii111=round(ii11) ; remove FIX
	jj222=round(jj22) & ii222=round(ii22)
	jj333=round(jj33) & ii333=round(ii33) ; remove FIX
	jj444=round(jj44) & ii444=round(ii44)

	jj1=FIX(jj111) & ii1=FIX(ii111) ; was FIX
	jj2=FIX(jj222) & ii2=FIX(ii222)
	jj3=FIX(jj333) & ii3=FIX(ii333) ; was FIX
	jj4=FIX(jj444) & ii4=FIX(ii444)

	NewTransX=OldTransX
	NewTransY=OldTransY

;print,i,(i+ystart+0.5)*YBIN,ii11,ii33

	for j=0,xend-xstart do begin
;		X_NEW=j; was float(j)

		jj11=jj22 & ii11=ii22
		jj33=jj44 & ii33=ii44
;		TransX1=TransX2
;		TransX3=jj44; TransX4
;		TransY1=TransY2
;		TransY3=ii44; TransY4

;		disttransform,X_NEW+0.5  ,X_CEN,Y_NEW-0.5  ,Y_CEN,TransX2,TransY2,beta,naxis[0],naxis[1],coef_inv
;		disttransform,j+0.5  ,X_CEN,Y_NEW_05  ,Y_CEN,TransX4,TransY4,mag,naxis[0],naxis[1]; was X_NEW, Y_NEW+0.5,coef_inv
		disttransform,(j+xstart+0.5)*XBIN  ,X_CEN,(Y_NEW_05+ystart)*YBIN  ,Y_CEN,jj44,ii44,mag,xdim,ydim,xmin,ymin,coef_inv; was X_NEW, Y_NEW+0.5,coef_inv

		jj44=jj44/XBIN;-xstart
		ii44=ii44/YBIN;-ystart

;	if (jj44 LT 0) OR (jj44 GT xdim-2) then goto,j_loop_end

;		transx2=newtransx[j] & transy2=newtransy[j]
;		oldtransx[j]=transx4 & oldtransy[j]=transy4
		OldTransX[j]=jj44 & OldTransY[j]=ii44

;		jj11=TransX1 & ii11=TransY1
		jj22=NewTransX[j] & ii22=NewTransY[j]; was TransX2 & ii22=TransY2
;		jj33=TransX3 & ii33=TransY3
;		jj44=TransX4 & ii44=TransY4

  	      jj1=jj2 & jj3=jj4
      	ii1=ii2 & ii3=ii4   

  	      jj111=jj222 & jj333=jj444
      	ii111=ii222 & ii333=ii444   

;		jj111=round(jj11) & ii111=round(ii11) ; remove FIX
		jj222=round(jj22) & ii222=round(ii22)
;		jj333=round(jj33) & ii333=round(ii33) ; remove FIX
		jj444=round(jj44) & ii444=round(ii44)


;		jj1=FIX(jj111) & ii1=FIX(ii111) ; remove FIX
		jj2=FIX(jj222) & ii2=FIX(ii222) ; was FIX
;		jj3=FIX(jj333) & ii3=FIX(ii333) ; remove FIX
		jj4=FIX(jj444) & ii4=FIX(ii444) ; was FIX

		fac1= (0.5-(jj11-jj111))* (0.5- (ii11-ii111))
		fac2= (0.5+(jj22-jj222))* (0.5- (ii22-ii222))
		fac3= (0.5-(jj33-jj333))* (0.5+ (ii33-ii333))
		fac4= (0.5+(jj44-jj444))* (0.5+ (ii44-ii444))

		outimageadd=    image[jj1,ii1] * fac1 $
		      	   +image[jj2,ii2] * fac2 $
      		     	   +image[jj3,ii3] * fac3 $
	             	   +image[jj4,ii4] * fac4

;	print,i,j,jj1,ii1,jj2,ii2,jj3,ii3,jj4,ii4
		outimagearea=    fac1+fac2+fac3+fac4

;	IF NOT ( ((jj1 * jj2 * jj3 * jj4) EQ (jj1 * (jj1+1) * jj1 * (jj1+1))) AND ((ii1 * ii2 * ii3 * ii4) * (ii1 * (ii1+1) * ii1 * (ii1+1))) ) then begin
	IF (NOT ( (jj2 EQ (jj1+1)) AND (ii2 EQ ii1) AND (jj3 EQ jj1) AND (ii3 EQ (ii1+1)) AND (jj4 EQ (jj1 +1)) AND (ii4 EQ (ii1 +1)) )) then begin

	flag=0
	flagx=0

		IF ((jj2 - jj1) GT 1) then begin
			IF (ii2 EQ ii1) then begin
				outimageadd=outimageadd+image[jj2-1,ii1] * (0.5- (ii11-ii111))
				outimagearea=outimagearea+(0.5- (ii11-ii111))
			endif

			IF (ii2 EQ (ii1 -1)) then begin
				outimageadd=outimageadd+image[jj2-1,ii1]
				outimagearea=outimagearea+1.0
			endif

			IF (ii2 EQ (ii1 +1)) then begin
				outimageadd=outimageadd+image[jj2-1,ii1+1]
				outimagearea=outimagearea+1.0
				flagx=1
			endif
		endif


		IF ((ii3 - ii1) GT 1) then begin
			IF (jj3 EQ jj1) then begin
				outimageadd=outimageadd+image[jj1,ii3-1] * (0.5-(jj11-jj111))
				outimagearea=outimagearea+(0.5-(jj11-jj111))
			endif
			IF (jj3 EQ (jj1 -1)) then begin
				outimageadd=outimageadd+image[jj1,ii3-1]
				outimagearea=outimagearea+1.0
			endif
			IF (jj3 EQ (jj1+1)) AND (flagx EQ 0) then begin
				outimageadd=outimageadd+image[jj1+1,ii3-1]
				outimagearea=outimagearea+1.0
				flag=1
			endif
		ENDIF


		IF ((jj4 - jj3) GT 1) then begin
			IF (ii3 EQ ii4) then begin
				outimageadd=outimageadd+image[jj4-1,ii3] * (0.5+ (ii33-ii333))
				outimagearea=outimagearea+(0.5+ (ii33-ii333))
			endif
			IF (ii3 EQ (ii4-1)) then begin
				outimageadd=outimageadd+image[jj4-1,ii3]
				outimagearea=outimagearea+1.0
			endif
			IF (ii3 EQ (ii4+1)) AND (jj1 EQ jj3) then begin
				outimageadd=outimageadd+image[jj4-1,ii3-1]
				outimagearea=outimagearea+1.0 
			endif
		ENDIF


		IF ((ii4 - ii2) GT 1) then begin
			IF (jj4 EQ jj2) then begin
				outimageadd=outimageadd+image[jj2,ii2+1] * (0.5+ (jj22-jj222))
				outimagearea=outimagearea + (0.5+ (jj22-jj222))
			endif
			IF (jj4 EQ (jj2-1)) AND (ii2 EQ ii1) then begin
				outimageadd=outimageadd+image[jj2-1,ii2+1]
				outimagearea=outimagearea+1.0
			endif
			IF (jj4 EQ (jj2+1)) AND (ii2 EQ ii1) AND (ii3 EQ ii4) then begin
				outimageadd=outimageadd+image[jj2,ii2+1]
				outimagearea=outimagearea+1.0
			endif
		ENDIF

		IF ((jj4 - jj1) GT 1) AND ((ii4 - ii1) GT 1) AND ((jj2 - jj3) GT 1) AND ((ii3 - ii2) GT 1) then begin
			outimageadd=outimageadd+image[jj44-1,ii44-1]
			outimagearea=outimagearea+1.0
		endif

ENDIF
            outimageadd=outimageadd/(1.+ (fluxconserveflag EQ 0) * (outimagearea-1.))
;		if fluxconserveflag EQ 0 then outimageadd=outimageadd/outimagearea

		outimage[j,i]=outimageadd
;
; Debug only
;

;		if outimage[j,i] GT 10000 then print,jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4,outimage[j,i],flagx,flag
;		if outimage[j,i] LT 300 then print,jj1,jcj2,jj3,jj4,ii1,ii2,ii3,ii4,outimage[j,i],flagx,flag

;		if outimagearea GT 1.2 then begin
;			if (min([jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4]) GT 1) AND (max([jj1,jj2,jj3,jj4]) LT xend) then print,jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4,outimagearea,flagx,flag
;		endif
;		if outimagearea LT 1.00 then begin
;			if min(([jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4]) GT 1)  AND (max([jj1,jj2,jj3,jj4]) LT xend) then print,jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4,outimagearea,flagx,flag
;		endif


;	ENDIF
;skip1:

;	j_loop_end:
	endfor
;	print,i
;print,jj1
endfor

if convolveflag EQ 1 then begin
psf=psf_gaussian(npixel=3,FWHM=[2,2],/normal)
convoutimage=convolve(outimage,psf)
endif else begin
convoutimage=outimage
endelse

;message,'Finish'
FINISH:
done:
     OBJ_DESTROY, progress
END
