PRO N_POINT
;
; Scan N files and make a trajectry of the shift of a certain point
;
	width = 30
	samplefac=4;2 for DAO; 6 for FOCAS
;;;
;;; main program
;;;
	nfilename=DIALOG_PICKFILE(PATH='~/FOCAS/SUBJECT',filter='*.fits',/MULTIPLE_FILES)
	IF(STRLEN(nfilename[0]) EQ 0) THEN stop
	nfiles=size(nfilename,/N_ELEMENTS)

;
; read main image array
;
	image= MRDFITS(nfilename[0], 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

        xmin=100 & xmax=naxis[0]-xmin & ymin=100 & ymax = naxis[1]-ymin
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)
        naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1
;
; read ascii extension
;
;	asciiext= MRDFITS(nfilename[0], 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;

;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	WINDOW,1,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	wset,0
	ERASE
	TV,BYTSCL(sigrange(image2,fraction=0.999)),/device

	CURSOR,xpos,ypos,/device
	xpos=xpos*samplefac & ypos=ypos*samplefac

	image3=image[xpos-width:xpos+width,ypos-width:ypos+width]
	wset,1
	show3,image3
	result=gauss2dfit(image3,a)
	print,a
	ref_x=a[4] & ref_y=a[5]


dif_x=FLTARR(nfiles)
dif_y=FLTARR(nfiles)
sequence=FLTARR(nfiles)

j=0
FOR fileid=0,nfiles-1 DO BEGIN

	print,nfilename[fileid]
	image= MRDFITS(nfilename[fileid], 0, header)
	image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)
	
	sequence[j]=j

	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2
	wset,0
;	ERASE
;	TV,BYTSCL(sigrange(image2,fraction=0.999)),/device
	image3=image[xpos-width:xpos+width,ypos-width:ypos+width]

	result=gauss2dfit(image3,a)
	print,a
	wset,1
	show3,image3
	dif_x[j]=a[4]-ref_x
	dif_y[j]=a[5]-ref_y
	print,dif_x[fileid],dif_y[fileid]
	j=j+1

ENDFOR

	result=DIALOG_PLOT2(XDATA=sequence,YDATA=dif_x,/YNOZERO,EXECUTE=[$
	'PLOT, XDATA,YDATA,/YNOZERO',$
	'OPLOT,XDATA,YDATA,psym=2'],$
	XTITLE='Sequence',YTITLE='X Shift',Title='Point Shift',$
	/PS_OPTION,/ASCII_DUMP_OPTION)

	result=DIALOG_PLOT2(XDATA=sequence,YDATA=dif_y,/YNOZERO,EXECUTE=[$
	'PLOT, XDATA,YDATA,/YNOZERO',$
	'OPLOT,XDATA,YDATA,psym=2'],$
	XTITLE='Sequence',YTITLE='Y Shift',Title='Point Shift',$
	/PS_OPTION,/ASCII_DUMP_OPTION)

	result=DIALOG_PLOT2(XDATA=dif_x,YDATA=dif_y,/YNOZERO,EXECUTE=[$
	'PLOT, XDATA,YDATA,/YNOZERO',$
	'OPLOT,XDATA,YDATA,psym=2'],$
	XTITLE='X Shift',YTITLE='Y Shift',Title='Point Shift',$
	/PS_OPTION,/ASCII_DUMP_OPTION)


message,'Finish!'
FINISH:
END
