PRO N_IDENTIFY

	nsum=10
	delay=0.25
	samplefac=4
;;;
;;; main program
;;;

nfilename=STRARR(10)

nfiles=dialog_input(prompt="How many files?")

for i=0,nfiles-1 do begin
	nfilename[i]=DIALOG_PICKFILE(PATH='~/m3',filter='*.fits')
	IF(STRLEN(nfilename[i]) EQ 0) THEN stop
endfor

filename=nfilename[0]
;
; read main image array
;
	image= MRDFITS(filename[0], 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

;
; read ascii extension
;
	asciiext= MRDFITS(filename, 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;

        xmin=100 & xmax=naxis[0]-xmin & ymin=100 & ymax = naxis[1]-ymin
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)
        naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1

;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(sigrange(image2)),/device

	CURSOR,line,column,/device & line=line*samplefac

	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 do begin
		X[i]=i
		Y[i]=total(image(FIX(line)-FIX(nsum/2):FIX(line)+FIX(nsum/2),i),1)
	ENDFOR

;
; identify
;
	compwidth=30; in units of Angstrom, 30 for 300R
	ncomplines=10
	fit_order=2; 2 for 300R

	compwave=FLTARR(ncomplines)
	lpos=FLTARR(3); 3
	wave=FLTARR(3); 3
;	linelist2=['7822.39','8573.12','9122.97']
	linelist2=['7471.16','8829.69','9307.90']
;	linelist2=['7471.16','7822.39','8829.69','9307.90']
	compwave[0]=6965.43
	compwave[1]=7084.17
	compwave[2]=7329.49
	compwave[3]=7471.16
;	compwave[4]=7635.11
;	compwave[5]=7651.75
	compwave[4]=7822.39
	compwave[5]=7948.18
	compwave[6]=8297.18
;	compwave[9]=8388.54
;	compwave[10]=8554.94
;	compwave[11]=8573.12
	compwave[7]=8829.69
;	compwave[13]=9094.83
;	compwave[14]=9122.97
	compwave[8]=9307.90
	compwave[9]=9595.39

;
; First ID
;
	ERASE
	WINDOW,0,xsize=2000,ysize=500,TITLE='Select a Line'

;	PLOT,X[1000:2000],Y[1000:2000],/ynozero
	PLOT,X,Y,/ynozero

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center (top)'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0] & y1=XY[1]

	print,cen,y1

	PRINT,'Click FWHM (left)'
	CURSOR,x1,tmp,3,/device
	XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
	x1=XY[0]
	PRINT,'Click FWHM (right)'
	CURSOR,x2,tmp,3,/device
	XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
	x2=XY[0]

	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero
	OPLOT,XX,result,psym=10

	wave[0]=DIALOG_MENU(linelist2, TITLE = 'Select Wavelength')
	lpos[0]=coef[1]
;
; Second ID
;
;	PLOT,X[1000:2000],Y[1000:2000],/ynozero
	PLOT,X,Y,/ynozero
	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0]

	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero
	OPLOT,XX,result,psym=10

	wave[1] = DIALOG_MENU (linelist2, TITLE = 'Select Wavelength')
	lpos[1]=coef[1]

;
; Third ID
;

;	PLOT,X[1000:2000],Y[1000:2000],/ynozero
	PLOT,X,Y,/ynozero

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0]

	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero
	OPLOT,XX,result,psym=10

	wave[2] = DIALOG_MENU (linelist2, TITLE = 'Select Wavelength')
	lpos[2]=coef[1]

;
; 4
;
;	PLOT,X[1000:2000],Y[1000:2000],/ynozero
;	PLOT,X,Y,/ynozero

;	CURSOR,Xnew,Ynew,3,/device
;	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
;	Xnew=FIX(XY[0])
;	CURSOR,X2new,Ynew,3,/device
;	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
;	X2new=FIX(XY[0])

;	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

;	YY=YY-MIN(YY) & YY=YY/MAX(YY)

;	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

;	PRINT,'Click Center'
;	CURSOR,cen,y1,3,/device
;	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
;	cen=XY[0]

;	est=[1,cen,abs(x1-x2),0]
;	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
;	PRINT,'Amp., Cen., FWHM, Cont', coef

;	PLOT,XX,YY,/ynozero
;	OPLOT,XX,result,psym=10

;	wave[3] = DIALOG_MENU (linelist2, TITLE = 'Select Wavelength')
;	lpos[3]=coef[1]

;
; do the preliminary fit
;
	fit2_result=POLY_FIT(lpos,wave,fit_order,fittedwave,/double)
	plot,lpos,wave,/ynozero
	oplot,lpos,fittedwave

;;;
;;; auto-identify
;;;
	fit_result=FLTARR(3)
	new_fit_result=FLTARR(3)
	wavepar=FLTARR(nfiles,2)
	lpos2=FLTARR(nfiles,ncomplines)
	wave2=FLTARR(nfiles,ncomplines)
	sequence=FLTARR(nfiles)

fit_result=fit2_result

FOR fileid=0,nfiles-1 DO BEGIN
	sequence[fileid]=fileid

	image= MRDFITS(nfilename[fileid], 0)
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)

	FOR i=0,naxis[1]-1 do begin
		X[i]=i
		Y[i]=total(image(FIX(line)-FIX(nsum/2):FIX(line)+FIX(nsum/2),i),1)
	ENDFOR
	
	new_fit_result=fit_result

	FOR i=0,ncomplines-1 DO BEGIN
		cen=compwave[i]
;		lposnew=(cen-compwidth-new_fit_result[0])/new_fit_result[1]
		tmp=cen-compwidth
		lposnew=(-new_fit_result[1]-sqrt(new_fit_result[1]^2-4*new_fit_result[2]*(new_fit_result[0]-tmp)))/(2*new_fit_result[2])
		Xnew=FIX(lposnew)

		tmp=cen+compwidth
		lposnew=(-new_fit_result[1]-sqrt(new_fit_result[1]^2-4*new_fit_result[2]*(new_fit_result[0]-tmp)))/(2*new_fit_result[2])
;		lposnew=(cen+compwidth-new_fit_result[0])/new_fit_result[1]
		X2new=FIX(lposnew)

		IF Xnew GT X2new then begin tmp=X2new & X2new = Xnew & Xnew = tmp & ENDIF

		XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
		YY=YY-MIN(YY) & YY=YY/MAX(YY)
		plot,XX,YY,/YNOZERO

		lposnew=XX##transpose(YY/total(YY))
;		lposnew=(compwave[i]-new_fit_result[0])/new_fit_result[1]
		est=[1,lposnew,abs(x1-x2),0]
		result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
		PRINT,'Amp., Cen., FWHM, Cont', coef
		OPLOT,XX,result,psym=10
		wait,delay

		wave2[fileid,i]=cen
		lpos2[fileid,i]=coef[1]

	ENDFOR ; end of i loop

	wavepar[fileid,*]=POLY_FIT(lpos2[fileid,*],wave2[fileid,*],1,wavefit,/double)
	print,'Lambda0, delta_Lambda=',wavepar[fileid,0],wavepar[fileid,1]

	plot,lpos2[fileid,*],wave2[fileid,*],/YNOZERO
	oplot,lpos2[fileid,*],wave2[fileid,*],psym=2
	oplot,lpos2[fileid,*],wavefit

ENDFOR ; end of fileid loop


result=DIALOG_PLOT2(XDATA=sequence,YDATA=wavepar[*,0],/YNOZERO,EXECUTE=[$
'PLOT, XDATA,YDATA,/YNOZERO',$
'OPLOT,XDATA,YDATA,psym=2'],$
XTITLE='Sequence',YTITLE='Zero point',Title='Wavecalib',$
/PS_OPTION,/ASCII_DUMP_OPTION,xsize=750,ysize=500)

result=DIALOG_PLOT2(XDATA=sequence,YDATA=wavepar[*,1],/YNOZERO,EXECUTE=[$
'PLOT, XDATA,YDATA,/YNOZERO',$
'OPLOT,XDATA,YDATA,psym=2'],$
XTITLE='Sequence',YTITLE='Angstrom per pix',Title='Wavecalib',$
/PS_OPTION,/ASCII_DUMP_OPTION,xsize=750,ysize=500)


message,'Finish!'
FINISH:
END
