PRO N_HALTMAN
	nsum=30
	estwidth=3
	samplefac=4;
;;;
;;; main program
;;;
	nfilename=DIALOG_PICKFILE(PATH='~/wa52a/SUBJECT/NHALT/',filter='*.fits',/MULTIPLE_FILES)
	IF(STRLEN(nfilename[0]) EQ 0) THEN stop
	nfiles=size(nfilename,/N_ELEMENTS)
;
; read main image array
;
	image= MRDFITS(nfilename[0], 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')
;
; read ascii extension
;
;	asciiext= MRDFITS(nfilename[0], 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;
        xmin=100 & xmax=naxis[0]-xmin & ymin=100 & ymax = naxis[1]-ymin
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)
        naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1

;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(sigrange(image2)),/device

	CURSOR,line,column,/device
;	column=column*samplefac
	line=line*samplefac

	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 do begin
		X[i]=i
;		Y[i]=image(i,FIX(column))
;		Y[i]=image(FIX(line),i)	
		Y[i]=total(image(FIX(line)-FIX(nsum/2):FIX(line)+FIX(nsum/2),i),1)
ENDFOR

	WINDOW,0,xsize=750,ysize=500,TITLE='Select a Line (CLICK 2 times)'
	PLOT,X,Y,/ynozero

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=YY-MIN(YY) & YY = YY/max(YY)

	ERASE
	PLOT,XX,YY,/ynozero
;
; main loop
;

pos=FLTARR(nfiles)
dif=FLTARR(FIX(nfiles/2))
sequence=FLTARR(FIX(nfiles/2))

j=0
FOR fileid=0,nfiles-1,2 DO BEGIN

	sequence[j]=j

;	print,nfilename[fileid]
	image= MRDFITS(nfilename[fileid], 0)
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)

	FOR i=0,naxis[1]-1 do begin
		X[i]=i
;		Y[i]=image(i,FIX(column))
		Y[i]=total(image(FIX(line)-FIX(nsum/2):FIX(line)+FIX(nsum/2),i),1)
	ENDFOR

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY= YY-MIN(YY) & YY=YY/MAX(YY)
	PLOT,XX,YY,/ynozero

	estpos=XX ## transpose (YY/total(YY))
	est=[1,estpos,estwidth,0]
        result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	OPLOT,XX,result,PSYM=10

	pos[fileid]=coef[1]
;	print,pos[fileid]

;
; 2nd file
;
;	print,nfilename[fileid+1]
	image= MRDFITS(nfilename[fileid+1], 0, header)
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)

	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 do begin
		X[i]=i
		Y[i]=total(image(FIX(line)-FIX(nsum/2):FIX(line)+FIX(nsum/2),i),1)
;		Y[i]=image(FIX(line),i)
	ENDFOR
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=YY-MIN(YY) & YY=YY/MAX(YY)
	PLOT,XX,YY,/ynozero

	estpos=XX ## transpose (YY/total(YY))
        est=[1,estpos,estwidth,0]
        result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	OPLOT,XX,result,PSYM=10

	pos[fileid+1]=coef[1]
;	print,pos[fileid+1]

	dif[j]=pos[fileid]-pos[fileid+1]
	print,nfilename[fileid],pos[fileid],pos[fileid+1],dif[j]
	j=j+1

ENDFOR

	result=DIALOG_PLOT2(XDATA=sequence,YDATA=dif,/YNOZERO,EXECUTE=[$
	'PLOT, XDATA,YDATA,/YNOZERO',$
	'OPLOT,XDATA,YDATA,psym=2'],$
	XTITLE='Sequence',YTITLE='Focus Offset',Title='Haltman Test',$
	/PS_OPTION,/ASCII_DUMP_OPTION)

message,'Finish!'
FINISH:
END
