PRO LINESHIFT

	delay=0.0
	samplefac=4; 2 for DAO


;;;
;;; main program
;;;

	nfilename=DIALOG_PICKFILE(PATH='~/IDL/FOCAS',filter='*.fits',/MULTIPLE_FILES)
	IF(STRLEN(nfilename[0]) EQ 0) THEN stop
	nfiles=size(nfilename,/N_ELEMENTS)
	filename=nfilename[0]
;
; read main image array
;
	image= MRDFITS(filename, 0, header)
	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')

	image=image+32768 ; offset for DAO data

;
; read ascii extension
;
	asciiext= MRDFITS(filename, 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;
;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(image2),/device

	result=dialog_menu(['X direction','Y direction'],TITLE='Cut Direction?')
	CASE result OF
		'Y direction': BEGIN
			END
		'X direction': BEGIN
			image=rotate(image,1); rotate 90 deg clockwise
			image2=rotate(image2,1)
			temp=naxis[0]
			naxis[0]=naxis[1]
			naxis[1]=temp
			END
	ENDCASE

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(image2),/device

	CURSOR,line,column,/device
	line=line*samplefac & column=column*samplefac
	startx=FIX(line)

	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 do begin
		X[i]=i
		Y[i]=image(FIX(startx),i)
	ENDFOR

	ERASE
	WINDOW,0,xsize=1024,ysize=512,TITLE='Select a Line (CLICK 2 times)'
	PLOT,X,Y,/ynozero

	print,'Find object region'
	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])
	PRINT,Xnew,X2new
	objwidth=abs(X2new-Xnew)
	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	YY=NORMARRAY(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center (top)'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0] & y1=XY[1]
	PRINT,'Click FWHM (left)'
	CURSOR,x1,tmp,3,/device
	XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
	x1=XY[0]
	PRINT,'Click FWHM (right)'
	CURSOR,x2,tmp,3,/device
	XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
	x2=XY[0]
	
	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result

;;;
;;; nfile loop
;;;

	filenum=FLTARR(nfiles)
	azimuth=FLTARR(nfiles)
	ypos=FLTARR(nfiles)
	xpos=FLTARR(nfiles)
	skew=FLTARR(nfiles)
	kurt=FLTARR(nfiles)
	FWHM=FLTARR(nfiles)
	amp =FLTARR(nfiles)

FOR fileid=0,nfiles-1 DO BEGIN
	print,nfilename[fileid]
	image= MRDFITS(nfilename[fileid], 0, header)

	azimuth[fileid] = SXPAR( header ,'AZIMUTH')

	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 do begin
		X[i]=i
		Y[i]=image(FIX(startx),i)
	ENDFOR

	Xnew=FIX(coef[1]-objwidth/2)
	X2new=FIX(coef[1]+objwidth/2)

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=NORMARRAY(YY)
	PLOT,XX,YY

	est=[1,coef[1],coef[2],0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'#',i,column,': Amp., Cen., FWHM, Cont', coef

	OPLOT,XX,result
	WAIT,delay

	filenum[fileid]=fileid
	amp[fileid]=coef[0]
	ypos[fileid]=coef[1]
	FWHM[fileid]=coef[2]
	skew[fileid]=skewness(YY)
	kurt[fileid]=kurtosis(YY)

	i=i+1
ENDFOR ; fileid loop

;WINDOW,0,xsize=1024,ysize=512,TITLE=''

REPEAT BEGIN
flag = DIALOG_MENU (['NUM','AZIMUTH','END'], TITLE = 'Analysis Result')
	CASE flag OF

	'NUM': BEGIN
		result=DIALOG_PLOT2(XDATA=filenum,YDATA=ypos,/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Peak Position',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'AZIMUTH': BEGIN
	result=DIALOG_PLOT2(XDATA=azimuth,YDATA=ypos,/YNOZERO,EXECUTE=[$
		'PLOT, XDATA,YDATA,/YNOZERO',$
		'OPLOT,XDATA,YDATA,psym=2'],$
		XTITLE='X-Pos.',YTITLE='Continuum Amplitude',Title='Continuum Trace',$
		/PS_OPTION,/ASCII_DUMP_OPTION)
	END

	'END': BEGIN & END ; do nothing
	''   : BEGIN & END ; do nothing

	ENDCASE

ENDREP UNTIL ((flag EQ 'END') OR (flag EQ ''))

FINISH:
END
