PRO IDENTIFY

	delay=0
	samplefac=4; 2 for DAO
;;;
;;; main program
;;;
	filename=DIALOG_PICKFILE(PATH='/wa52a/ohyamayi/SUBJECT/',filter='*.fits')
	IF(STRLEN(filename) EQ 0) THEN stop
;
; read main image array
;
	image= MRDFITS(filename, 0, header)
;	name = SXPAR( header ,'OBJECT')
	naxis= SXPAR( header,'NAXIS*')
;
; read ascii extension
;
;	asciiext= MRDFITS(filename, 1, asciiheader); read ASCII extension
;
; image display after rebinning nicely
;

        xmin=100 & xmax=naxis[0]-xmin & ymin=100 & ymax = naxis[1]-ymin
        image=image-MIN(image)
        image=trim(image,xmin,xmax,ymin,ymax)
        naxis[0]=xmax-xmin+1 & naxis[1]=ymax-ymin+1

;	image2=rebin(image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac))
	expand,image,FIX(naxis[0]/samplefac),FIX(naxis[1]/samplefac),image2

	WINDOW,0,xsize=FIX(naxis[0]/samplefac),ysize=FIX(naxis[1]/samplefac),TITLE=name
	ERASE
	TV,BYTSCL(sigrange(image2,fraction=0.95)),/device

	CURSOR,line,column,/device & line=line*samplefac

	X=FLTARR(naxis[1]) & Y=FLTARR(naxis[1])
	FOR i=0,naxis[1]-1 do begin
		X[i]=i
		Y[i]=image(FIX(line),i)
	ENDFOR

;
; identify
;
	compwidth=20
	ncomplines=10
	fit_order=2

	compwave=FLTARR(ncomplines)
	lpos=FLTARR(3)
	wave=FLTARR(3)

	linelist2=['7822.39','8573.12','9122.97']
	
	compwave[0]=6965.43
	compwave[1]=7084.17
	compwave[2]=7329.49
	compwave[3]=7471.16
;	compwave[4]=7635.11
;	compwave[5]=7651.75
	compwave[4]=7822.39
	compwave[5]=7948.18
	compwave[6]=8297.18
;	compwave[9]=8388.54
;	compwave[10]=8554.94
;	compwave[11]=8573.12
	compwave[7]=8829.69
;	compwave[13]=9094.83
;	compwave[14]=9122.97
	compwave[8]=9307.90
	compwave[9]=9595.39

	ERASE
	WINDOW,0,xsize=750,ysize=500,TITLE='Select a Line'

;
; First ID
;

	PLOT,X,Y,/ynozero

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center (top)'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0] & y1=XY[1]

	PRINT,'Click FWHM (left)'
	CURSOR,x1,tmp,3,/device
	XY = CONVERT_COORD(x1,tmp,/device,/TO_DATA)
	x1=XY[0]
	PRINT,'Click FWHM (right)'
	CURSOR,x2,tmp,3,/device
	XY = CONVERT_COORD(x2,tmp,/device,/TO_DATA)
	x2=XY[0]

	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result

	wave[0]=DIALOG_MENU(linelist2, TITLE = 'Select Wavelength')
	lpos[0]=coef[1]
;
; Second ID
;
	PLOT,X,Y,/ynozero

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0]

	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result
	wave[1] = DIALOG_MENU (linelist2, TITLE = 'Select Wavelength')
	lpos[1]=coef[1]

;
; Third ID
;
	PLOT,X,Y,/ynozero

	CURSOR,Xnew,Ynew,3,/device
	XY = CONVERT_COORD(Xnew,Ynew,/device,/TO_DATA)
	Xnew=FIX(XY[0])
	CURSOR,X2new,Ynew,3,/device
	XY = CONVERT_COORD(X2new,Ynew,/device,/TO_DATA)
	X2new=FIX(XY[0])

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)

	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	PLOT,XX,YY,/ynozero,TITLE='Gaussian Fit'

	PRINT,'Click Center'
	CURSOR,cen,y1,3,/device
	XY = CONVERT_COORD(cen,y1,/device,/TO_DATA)
	cen=XY[0]

	est=[1,cen,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	PLOT,XX,YY,/ynozero,psym=10
	OPLOT,XX,result

	wave[2] = DIALOG_MENU (linelist2, TITLE = 'Select Wavelength')
	lpos[2]=coef[1]

	plot,wave,lpos
	fit2_result=POLY_FIT(lpos,wave,2)
	PRINT,'Fit Reults', fit2_result

;;;
;;; auto-identify
;;;

	fit_result=FLTARR(fit_order)
	new_fit_result=FLTARR(fit_order)
	lpos2=FLTARR(ncomplines)
	wave2=FLTARR(ncomplines)

new_fit_result=fit2_result

FOR i=0,ncomplines-1 DO BEGIN
	cen=compwave[i]
	
;	lposnew=(cen-compwidth-new_fit_result[0])/new_fit_result[1]
	tmp=cen-compwidth
	lposnew=(-new_fit_result[1]-sqrt(new_fit_result[1]^2-4*new_fit_result[2]*(new_fit_result[0]-tmp)))/(2*new_fit_result[2])
	Xnew=FIX(lposnew)

	tmp=cen+compwidth
	lposnew=(-new_fit_result[1]-sqrt(new_fit_result[1]^2-4*new_fit_result[2]*(new_fit_result[0]-tmp)))/(2*new_fit_result[2])
;	lposnew=(cen+compwidth-new_fit_result[0])/new_fit_result[1]
	X2new=FIX(lposnew)

	IF Xnew GT X2new then begin tmp=X2new & X2new = Xnew & Xnew = tmp & ENDIF

	XX=X(XNew:X2new) & YY=Y(Xnew:X2new)
	YY=YY-MIN(YY) & YY=YY/MAX(YY)

	plot,XX,YY,/YNOZERO
	wait,delay

	lposnew=XX##transpose(YY/total(YY))

;	lposnew=(-new_fit_result[1]-sqrt(new_fit_result[1]^2-4*new_fit_result[2]*(new_fit_result[0]-cen)))/(2*new_fit_result[2])
;	lposnew=(cen-new_fit_result[0])/new_fit_result[1]
	est=[1,lposnew,abs(x1-x2),0]
	result=GAUSSFIT(XX,YY,coef,NTERMS=4,ESTIMATE=est)
	PRINT,'Amp., Cen., FWHM, Cont', coef

	oplot,XX,result
	wait,delay

	wave2[i]=cen
	lpos2[i]=coef[1]

ENDFOR ; end of i loop

;
; wavecalib at one column
;
fit_result=POLY_FIT(lpos2,wave2,1,wavefit)
print,fit_result

plot,lpos2,wave2,/YNOZERO
oplot,lpos2,wave2,psym=2
oplot,lpos2,wavefit

fit_result=POLY_FIT(wave2,lpos2,3,wavefit)
print,fit_result_inverse

FINISH:

END
